/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import org.openjdk.asmtools.common.Module;
import org.openjdk.asmtools.common.Tool;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Main;

public class ModuleData {
    private final Tool tool;
    private ConstantPool pool;
    private PrintWriter out;
    private Module module;

    public ModuleData(ClassData clsData) {
        this.tool = clsData.tool;
        this.pool = clsData.pool;
        this.out = clsData.out;
    }

    public String getModuleName() {
        return this.module == null ? "N/A" : this.module.getModuleName();
    }

    public String getModuleVersion() {
        return this.module.getModuleVersion();
    }

    public String getModuleHeader() {
        if (this.module == null) {
            return "N/A";
        }
        StringBuilder sb = new StringBuilder(this.module.getModuleFlags());
        sb.append(JasmTokens.Token.MODULE.parseKey()).append(" ");
        sb.append(this.module.getModuleName());
        if (this.module.getModuleVersion() != null) {
            sb.append("// @").append(this.module.getModuleVersion());
        }
        return sb.toString();
    }

    public void read(DataInputStream in) throws IOException {
        int j;
        HashSet<String> targets;
        int i;
        Module.Builder builder;
        String version;
        int versionIndex;
        String moduleName;
        int index;
        try {
            index = in.readUnsignedShort();
            moduleName = this.pool.getModule(index);
            int moduleFlags = in.readUnsignedShort();
            versionIndex = in.readUnsignedShort();
            version = this.pool.getString(versionIndex);
            builder = new Module.Builder(moduleName, moduleFlags, version);
        }
        catch (IOException ioe) {
            this.tool.error(Main.i18n.getString("jdis.error.invalid_header"));
            throw ioe;
        }
        try {
            int requires_count = in.readUnsignedShort();
            for (i = 0; i < requires_count; ++i) {
                index = in.readUnsignedShort();
                int requiresFlags = in.readUnsignedShort();
                versionIndex = in.readUnsignedShort();
                moduleName = this.pool.getModule(index);
                version = this.pool.getString(versionIndex);
                builder.require(moduleName, requiresFlags, version);
            }
        }
        catch (IOException ioe) {
            this.tool.error(Main.i18n.getString("jdis.error.invalid_requires"));
            throw ioe;
        }
        try {
            int exports_count = in.readUnsignedShort();
            if (exports_count > 0) {
                for (i = 0; i < exports_count; ++i) {
                    index = in.readUnsignedShort();
                    String packageName = this.pool.getPackage(index);
                    int exportsFlags = in.readUnsignedShort();
                    int exports_to_count = in.readUnsignedShort();
                    if (exports_to_count > 0) {
                        targets = new HashSet<String>(exports_to_count);
                        for (j = 0; j < exports_to_count; ++j) {
                            int exports_to_index = in.readUnsignedShort();
                            targets.add(this.pool.getModule(exports_to_index));
                        }
                        builder.exports(packageName, exportsFlags, targets);
                        continue;
                    }
                    builder.exports(packageName, exportsFlags);
                }
            }
        }
        catch (IOException ioe) {
            this.tool.error(Main.i18n.getString("jdis.error.invalid_exports"));
            throw ioe;
        }
        try {
            int opens_count = in.readUnsignedShort();
            if (opens_count > 0) {
                for (i = 0; i < opens_count; ++i) {
                    index = in.readUnsignedShort();
                    String packageName = this.pool.getPackage(index);
                    int opensFlags = in.readUnsignedShort();
                    int opens_to_count = in.readUnsignedShort();
                    if (opens_to_count > 0) {
                        targets = new HashSet(opens_to_count);
                        for (j = 0; j < opens_to_count; ++j) {
                            int opens_to_index = in.readUnsignedShort();
                            targets.add(this.pool.getModule(opens_to_index));
                        }
                        builder.opens(packageName, opensFlags, targets);
                        continue;
                    }
                    builder.opens(packageName, opensFlags);
                }
            }
        }
        catch (IOException ioe) {
            this.tool.error(Main.i18n.getString("jdis.error.invalid_opens"));
            throw ioe;
        }
        try {
            int uses_count = in.readUnsignedShort();
            if (uses_count > 0) {
                for (i = 0; i < uses_count; ++i) {
                    index = in.readUnsignedShort();
                    String serviceName = this.pool.getClassName(index);
                    builder.uses(serviceName);
                }
            }
        }
        catch (IOException ioe) {
            this.tool.error(Main.i18n.getString("jdis.error.invalid_uses"));
            throw ioe;
        }
        try {
            int provides_count = in.readUnsignedShort();
            if (provides_count > 0) {
                for (i = 0; i < provides_count; ++i) {
                    index = in.readUnsignedShort();
                    String serviceName = this.pool.getClassName(index);
                    int provides_with_count = in.readUnsignedShort();
                    HashSet<String> implNames = new HashSet<String>(provides_with_count);
                    for (int j2 = 0; j2 < provides_with_count; ++j2) {
                        int provides_with_index = in.readUnsignedShort();
                        implNames.add(this.pool.getClassName(provides_with_index));
                    }
                    builder.provides(serviceName, implNames);
                }
            }
        }
        catch (IOException ioe) {
            this.tool.error(Main.i18n.getString("jdis.error.invalid_provides"));
            throw ioe;
        }
        this.module = builder.build();
    }

    public void print() {
        if (this.module != null) {
            this.out.println(this.module.toString());
        }
    }
}

