/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Options;

public class SignatureData {
    ClassData cls;
    int signature_index;
    private Options options = Options.OptionObject();

    public SignatureData(ClassData cls) {
        this.cls = cls;
    }

    public SignatureData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        if (attribute_length != 2) {
            throw new ClassFormatError(String.format("%s: Invalid attribute length #%d", Tables.AttrTag.ATT_Signature.printval(), attribute_length));
        }
        this.signature_index = in.readUnsignedShort();
        return this;
    }

    public void print(String bodyPrefix, String commentPrefix) {
        boolean pr_cpx = this.options.contains(Options.PR.CPX);
        if (pr_cpx) {
            this.cls.out.print(String.format("%s#%d%s%s", bodyPrefix, this.signature_index, commentPrefix, this.cls.pool.StringValue(this.signature_index)));
        } else {
            this.cls.out.print(String.format("%s%s%s", bodyPrefix, this.cls.pool.getName(this.signature_index), commentPrefix));
        }
    }

    public String toString() {
        return String.format("signature[%d]=%s", this.signature_index, this.cls.pool.StringValue(this.signature_index));
    }
}

