/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.jdis.Options;

public class TraceUtils {
    public static String prefixString = "\t";

    public static void trace(String s) {
        if (!Options.OptionObject().debug()) {
            return;
        }
        System.out.print(s);
    }

    public static void trace(int prefixLength, String s) {
        if (!Options.OptionObject().debug()) {
            return;
        }
        System.out.print(prefixLength > 0 ? new String(new char[prefixLength]).replace("\u0000", prefixString) + s : s);
    }

    public static void traceln(String s) {
        if (!Options.OptionObject().debug()) {
            return;
        }
        System.out.println(s);
    }

    public static void traceln(String ... lines) {
        if (!Options.OptionObject().debug()) {
            return;
        }
        if (lines.length == 0) {
            System.out.println();
        } else {
            for (String s : lines) {
                System.out.println(s);
            }
        }
    }

    public static void traceln(int prefixLength, String s) {
        if (!Options.OptionObject().debug()) {
            return;
        }
        System.out.println(prefixLength > 0 ? new String(new char[prefixLength]).replace("\u0000", prefixString) + s : s);
    }

    public static void traceln(int prefixLength, String ... lines) {
        if (!Options.OptionObject().debug()) {
            return;
        }
        if (lines.length == 0) {
            System.out.println();
        } else {
            String prefix = prefixLength > 0 ? new String(new char[prefixLength]).replace("\u0000", prefixString) : "";
            for (String s : lines) {
                System.out.println(prefix + s);
            }
        }
    }

    public static String mapToHexString(int[] array) {
        return String.format("%d %s", array.length, Arrays.stream(array).mapToObj(val -> HexUtils.toHex(val)).collect(Collectors.joining(" ")));
    }
}

