/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.openjdk.asmtools.jasm.TypeAnnotationTargetInfoData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypePathData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class TypeAnnotationData
extends AnnotationData {
    private static TTVis TT_Visitor = new TTVis();
    private TypeAnnotationTargetInfoData targetInfo = null;
    private TypeAnnotationTypePathData typePath = new TypeAnnotationTypePathData();

    public TypeAnnotationData(boolean invisible, ClassData cls) {
        super(invisible, cls);
        this.visAnnotToken = "@T+";
        this.invAnnotToken = "@T-";
        this.dataName = "TypeAnnotationData";
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        int ttype = in.readUnsignedByte();
        TypeAnnotationTypes.ETargetType targetType = TypeAnnotationTypes.ETargetType.getTargetType(ttype);
        if (targetType == null) {
            throw new IOException("Bad target type: " + ttype + " in TypeAnnotationData");
        }
        TT_Visitor.init(in);
        TT_Visitor.visitExcept(targetType);
        this.targetInfo = TT_Visitor.getTargetInfo();
        int len = in.readUnsignedByte();
        TraceUtils.traceln(4, "[TypeAnnotationData.read]: Reading Location (length = " + len + ").");
        TraceUtils.trace(4, "[TypeAnnotationData.read]: [ ");
        for (int i = 0; i < len; ++i) {
            int pathType = in.readUnsignedByte();
            String pk = TypeAnnotationTypes.getPathKind(pathType).parseKey();
            char pathArgIndex = (char)in.readUnsignedByte();
            this.typePath.addTypePathEntry(new TypeAnnotationTypes.TypePathEntry(pathType, (int)pathArgIndex));
            TraceUtils.trace(" " + pk + "(" + pathType + "," + pathArgIndex + "), ");
        }
        TraceUtils.traceln("] ");
        super.read(in);
    }

    @Override
    protected void printBody(PrintWriter out, String tab) {
        out.print(" {");
        super.printBody(out, "");
        this.targetInfo.print(out, tab);
        this.typePath.print(out, tab);
        out.print(tab + "}");
    }

    private static class TTVis
    extends TypeAnnotationTypes.TypeAnnotationTargetVisitor {
        private TypeAnnotationTargetInfoData targetInfo = null;
        private IOException IOProb = null;
        private DataInputStream in;

        private TTVis() {
        }

        public void init(DataInputStream in) {
            this.in = in;
        }

        public int scanByteVal() {
            int val = 0;
            try {
                val = this.in.readUnsignedByte();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return val;
        }

        public int scanShortVal() {
            int val = 0;
            try {
                val = this.in.readUnsignedShort();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return val;
        }

        public void visitExcept(TypeAnnotationTypes.ETargetType tt) throws IOException {
            this.IOProb = null;
            this.targetInfo = null;
            TraceUtils.traceln(4, "Target Type: " + tt.parseKey());
            this.visit(tt);
            if (this.IOProb != null) {
                throw this.IOProb;
            }
        }

        public TypeAnnotationTargetInfoData getTargetInfo() {
            return this.targetInfo;
        }

        private boolean error() {
            return this.IOProb != null;
        }

        @Override
        public void visit_type_param_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.trace(4, "Type Param Target: ");
            int byteval = this.scanByteVal();
            TraceUtils.traceln("{ param_index: " + byteval + "}");
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.type_parameter_target(tt, byteval);
            }
        }

        @Override
        public void visit_supertype_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.trace(4, "SuperType Target: ");
            int shortval = this.scanShortVal();
            TraceUtils.traceln("{ type_index: " + shortval + "}");
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.supertype_target(tt, shortval);
            }
        }

        @Override
        public void visit_typeparam_bound_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.trace(4, "TypeParam Bound Target: ");
            int byteval1 = this.scanByteVal();
            if (this.error()) {
                return;
            }
            int byteval2 = this.scanByteVal();
            if (this.error()) {
                return;
            }
            TraceUtils.traceln("{ param_index: " + byteval1 + " bound_index: " + byteval2 + "}");
            this.targetInfo = new TypeAnnotationTargetInfoData.type_parameter_bound_target(tt, byteval1, byteval2);
        }

        @Override
        public void visit_empty_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.traceln(4, "Empty Target: ");
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.empty_target(tt);
            }
        }

        @Override
        public void visit_methodformalparam_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.trace(4, "MethodFormalParam Target: ");
            int byteval = this.scanByteVal();
            TraceUtils.traceln("{ param_index: " + byteval + "}");
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.formal_parameter_target(tt, byteval);
            }
        }

        @Override
        public void visit_throws_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.trace(4, "Throws Target: ");
            int shortval = this.scanShortVal();
            TraceUtils.traceln("{ exception_index: " + shortval + "}");
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.throws_target(tt, shortval);
            }
        }

        @Override
        public void visit_localvar_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.traceln(4, "LocalVar Target: ");
            int tblsize = this.scanShortVal();
            if (this.error()) {
                return;
            }
            TypeAnnotationTargetInfoData.localvar_target locvartab = new TypeAnnotationTargetInfoData.localvar_target(tt, tblsize);
            this.targetInfo = locvartab;
            for (int i = 0; i < tblsize; ++i) {
                int shortval1 = this.scanShortVal();
                if (this.error()) {
                    return;
                }
                int shortval2 = this.scanShortVal();
                if (this.error()) {
                    return;
                }
                int shortval3 = this.scanShortVal();
                TraceUtils.trace(4, "LocalVar[" + i + "]: ");
                TraceUtils.traceln("{ startPC: " + shortval1 + ", length: " + shortval2 + ", CPX: " + shortval3 + "}");
                locvartab.addEntry(shortval1, shortval2, shortval3);
            }
        }

        @Override
        public void visit_catch_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.trace(4, "Catch Target: ");
            int shortval = this.scanShortVal();
            TraceUtils.traceln("{ catch_index: " + shortval + "}");
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.catch_target(tt, shortval);
            }
        }

        @Override
        public void visit_offset_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.trace(4, "Offset Target: ");
            int shortval = this.scanShortVal();
            TraceUtils.traceln("{ offset_index: " + shortval + "}");
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.offset_target(tt, shortval);
            }
        }

        @Override
        public void visit_typearg_target(TypeAnnotationTypes.ETargetType tt) {
            TraceUtils.trace(4, "TypeArg Target: ");
            int shortval = this.scanShortVal();
            if (this.error()) {
                return;
            }
            int byteval = this.scanByteVal();
            if (this.error()) {
                return;
            }
            TraceUtils.traceln("{ offset: " + shortval + " type_index: " + byteval + "}");
            this.targetInfo = new TypeAnnotationTargetInfoData.type_argument_target(tt, shortval, byteval);
        }
    }
}

