/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import java.util.Objects;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public class TextBinding {
    private final char MNEMONIC_SYMBOL = (char)95;
    private String sourceText = null;
    private String text = null;
    private String mnemonic = null;
    private KeyCombination mnemonicKeyCombination = null;
    private int mnemonicIndex = -1;
    private String extendedMnemonicText = null;

    public String getText() {
        return this.text;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public KeyCombination getMnemonicKeyCombination() {
        if (this.mnemonic != null && this.mnemonicKeyCombination == null) {
            this.mnemonicKeyCombination = new MnemonicKeyCombination(this.mnemonic);
        }
        return this.mnemonicKeyCombination;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public String getExtendedMnemonicText() {
        return this.extendedMnemonicText;
    }

    public TextBinding(String string) {
        this.update(string);
    }

    public void update(String string) {
        if (!Objects.equals(this.sourceText, string)) {
            this.sourceText = string;
            this.mnemonic = null;
            this.mnemonicKeyCombination = null;
            this.mnemonicIndex = -1;
            this.extendedMnemonicText = null;
            this.parseAndSplit(string);
        }
    }

    private void parseAndSplit(String string) {
        if (string == null || string.length() == 0) {
            this.text = string;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (this.isEscapedMnemonicSymbol(string, i)) {
                stringBuilder.append(string.charAt(i++));
                continue;
            }
            if (this.isSimpleMnemonic(string, i)) {
                char c = string.charAt(i + 1);
                stringBuilder.append(c);
                this.mnemonic = String.valueOf(c);
                this.mnemonicIndex = i++;
                continue;
            }
            if (this.isExtendedMnemonic(string, i)) {
                this.mnemonic = String.valueOf(string.charAt(i + 2));
                this.extendedMnemonicText = string.substring(i + 1, i + 4);
                i += 3;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        this.text = stringBuilder.toString();
    }

    private boolean isEscapedMnemonicSymbol(String string, int n) {
        return string.length() > n + 1 && string.charAt(n) == '_' && string.charAt(n + 1) == '_';
    }

    private boolean isSimpleMnemonic(String string, int n) {
        return string.length() > n + 1 && string.charAt(n) == '_' && Character.isAlphabetic(string.charAt(n + 1));
    }

    private boolean isExtendedMnemonic(String string, int n) {
        return string.length() > n + 3 && string.charAt(n) == '_' && string.charAt(n + 1) == '(' && Character.isAlphabetic(string.charAt(n + 2)) && string.charAt(n + 3) == ')';
    }

    public static class MnemonicKeyCombination
    extends KeyCombination {
        private String character = "";

        public MnemonicKeyCombination(String string) {
            super(new KeyCombination.Modifier[]{PlatformUtil.isMac() ? KeyCombination.META_DOWN : KeyCombination.ALT_DOWN});
            this.character = string;
        }

        public final String getCharacter() {
            return this.character;
        }

        public boolean match(KeyEvent keyEvent) {
            String string = keyEvent.getText();
            return string != null && !string.isEmpty() && string.equalsIgnoreCase(this.getCharacter()) && super.match(keyEvent);
        }

        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.getName());
            if (stringBuilder.length() > 0) {
                stringBuilder.append("+");
            }
            return stringBuilder.append('\'').append(this.character.replace("'", "\\'")).append('\'').toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MnemonicKeyCombination)) {
                return false;
            }
            return this.character.equals(((MnemonicKeyCombination)((Object)object)).getCharacter()) && super.equals(object);
        }

        public int hashCode() {
            return 23 * super.hashCode() + this.character.hashCode();
        }
    }
}

