/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCombination;

public class ControlAcceleratorSupport {
    private static Map<Object, WeakReference<ChangeListener<Scene>>> sceneChangeListenerMap = new WeakHashMap<Object, WeakReference<ChangeListener<Scene>>>();
    private static Map<MenuItem, WeakReference<ChangeListener<KeyCombination>>> changeListenerMap = new WeakHashMap<MenuItem, WeakReference<ChangeListener<KeyCombination>>>();

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, Tab tab) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, (Object)tab);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, TableColumnBase<?, ?> tableColumnBase) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, tableColumnBase);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, Node node) {
        WeakReference<ChangeListener<Scene>> weakReference;
        if (observableList == null) {
            return;
        }
        if (node == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        Scene scene = node.getScene();
        if (scene != null) {
            ControlAcceleratorSupport.doAcceleratorInstall(observableList, scene);
        }
        if ((weakReference = sceneChangeListenerMap.get(node)) != null) {
            ChangeListener changeListener = (ChangeListener)weakReference.get();
            if (changeListener != null) {
                node.sceneProperty().removeListener(changeListener);
            }
            sceneChangeListenerMap.remove(node);
        }
        node.sceneProperty().addListener(ControlAcceleratorSupport.getSceneChangeListener(node, observableList));
    }

    private static void addAcceleratorsIntoScene(final ObservableList<MenuItem> observableList, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        final ReadOnlyObjectProperty<? extends Control> readOnlyObjectProperty = ControlAcceleratorSupport.getControlProperty(object);
        Control control = (Control)readOnlyObjectProperty.get();
        if (control == null) {
            readOnlyObjectProperty.addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    Control control = (Control)readOnlyObjectProperty.get();
                    if (control != null) {
                        readOnlyObjectProperty.removeListener((InvalidationListener)this);
                        ControlAcceleratorSupport.addAcceleratorsIntoScene((ObservableList<MenuItem>)observableList, (Node)control);
                    }
                }
            });
        } else {
            ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, (Node)control);
        }
    }

    private static ChangeListener<Scene> getSceneChangeListener(Object object, ObservableList<MenuItem> observableList) {
        ChangeListener changeListener;
        WeakReference<ChangeListener<Scene>> weakReference = sceneChangeListenerMap.get(object);
        ChangeListener changeListener2 = changeListener = weakReference == null ? null : (ChangeListener)weakReference.get();
        if (changeListener == null) {
            changeListener = (observableValue, scene, scene2) -> {
                if (scene != null) {
                    ControlAcceleratorSupport.removeAcceleratorsFromScene((List<? extends MenuItem>)observableList, scene);
                }
                if (scene2 != null) {
                    ControlAcceleratorSupport.doAcceleratorInstall(observableList, scene2);
                }
            };
            sceneChangeListenerMap.put(object, new WeakReference<ChangeListener>(changeListener));
        }
        return changeListener;
    }

    private static void doAcceleratorInstall(ObservableList<MenuItem> observableList, Scene scene) {
        observableList.addListener(change -> {
            while (change.next()) {
                if (change.wasRemoved()) {
                    ControlAcceleratorSupport.removeAcceleratorsFromScene((List<? extends MenuItem>)change.getRemoved(), scene);
                }
                if (!change.wasAdded()) continue;
                ControlAcceleratorSupport.doAcceleratorInstall(change.getAddedSubList(), scene);
            }
        });
        ControlAcceleratorSupport.doAcceleratorInstall(observableList, scene);
    }

    private static void doAcceleratorInstall(List<? extends MenuItem> list, Scene scene) {
        for (MenuItem menuItem : list) {
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.doAcceleratorInstall(((Menu)menuItem).getItems(), scene);
                continue;
            }
            if (menuItem.getAccelerator() != null) {
                ObservableMap observableMap = scene.getAccelerators();
                Runnable runnable = () -> {
                    Menu menu;
                    if (menuItem.getOnMenuValidation() != null) {
                        Event.fireEvent((EventTarget)menuItem, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if ((menu = menuItem.getParentMenu()) != null && menu.getOnMenuValidation() != null) {
                        Event.fireEvent((EventTarget)menu, (Event)new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if (!menuItem.isDisable()) {
                        if (menuItem instanceof RadioMenuItem) {
                            ((RadioMenuItem)menuItem).setSelected(!((RadioMenuItem)menuItem).isSelected());
                        } else if (menuItem instanceof CheckMenuItem) {
                            ((CheckMenuItem)menuItem).setSelected(!((CheckMenuItem)menuItem).isSelected());
                        }
                        menuItem.fire();
                    }
                };
                observableMap.put(menuItem.getAccelerator(), runnable);
            }
            menuItem.acceleratorProperty().addListener(ControlAcceleratorSupport.getListener(scene, menuItem));
        }
    }

    private static ChangeListener<KeyCombination> getListener(Scene scene, MenuItem menuItem) {
        ChangeListener changeListener;
        WeakReference<ChangeListener<KeyCombination>> weakReference = changeListenerMap.get(menuItem);
        ChangeListener changeListener2 = changeListener = weakReference == null ? null : (ChangeListener)weakReference.get();
        if (changeListener == null) {
            changeListener = (observableValue, keyCombination, keyCombination2) -> {
                ObservableMap observableMap = scene.getAccelerators();
                Runnable runnable = (Runnable)observableMap.remove(keyCombination);
                if (keyCombination2 != null) {
                    observableMap.put(keyCombination2, runnable);
                }
            };
            changeListenerMap.put(menuItem, new WeakReference<ChangeListener>(changeListener));
        }
        return changeListener;
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> list, Tab tab) {
        TabPane tabPane = tab.getTabPane();
        if (tabPane == null) {
            return;
        }
        Scene scene = tabPane.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(list, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> list, TableColumnBase<?, ?> tableColumnBase) {
        ReadOnlyObjectProperty<? extends Control> readOnlyObjectProperty = ControlAcceleratorSupport.getControlProperty(tableColumnBase);
        if (readOnlyObjectProperty == null) {
            return;
        }
        Control control = (Control)readOnlyObjectProperty.get();
        if (control == null) {
            return;
        }
        Scene scene = control.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(list, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> list, Node node) {
        WeakReference<ChangeListener<Scene>> weakReference;
        Scene scene = node.getScene();
        if (scene == null && (weakReference = sceneChangeListenerMap.get(node)) != null) {
            ChangeListener changeListener = (ChangeListener)weakReference.get();
            if (changeListener != null) {
                node.sceneProperty().removeListener(changeListener);
            }
            sceneChangeListenerMap.remove(node);
        }
        ControlAcceleratorSupport.removeAcceleratorsFromScene(list, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> list, Scene scene) {
        if (scene == null) {
            return;
        }
        for (MenuItem menuItem : list) {
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.removeAcceleratorsFromScene(((Menu)menuItem).getItems(), scene);
                continue;
            }
            ObservableMap observableMap = scene.getAccelerators();
            observableMap.remove(menuItem.getAccelerator());
            WeakReference<ChangeListener<KeyCombination>> weakReference = changeListenerMap.get(menuItem);
            if (weakReference == null) continue;
            ChangeListener changeListener = (ChangeListener)weakReference.get();
            if (changeListener != null) {
                menuItem.acceleratorProperty().removeListener(changeListener);
            }
            changeListenerMap.remove(menuItem);
        }
    }

    private static ReadOnlyObjectProperty<? extends Control> getControlProperty(Object object) {
        if (object instanceof TableColumn) {
            return ((TableColumn)object).tableViewProperty();
        }
        if (object instanceof TreeTableColumn) {
            return ((TreeTableColumn)object).treeTableViewProperty();
        }
        if (object instanceof Tab) {
            return ((Tab)object).tabPaneProperty();
        }
        return null;
    }
}

