/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AcceleratedScreen;
import com.sun.glass.ui.monocle.EGLAcceleratedScreen;
import com.sun.glass.ui.monocle.EGLCursor;
import com.sun.glass.ui.monocle.EGLScreen;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.LinuxPlatform;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.NullCursor;
import com.sun.glass.ui.monocle.SoftwareCursor;
import java.util.ArrayList;
import java.util.List;

public class EGLPlatform
extends LinuxPlatform {
    private List<NativeScreen> screens;

    public EGLPlatform() {
        long l;
        String string = System.getProperty("monocle.egl.lib");
        if (string != null && (l = LinuxSystem.getLinuxSystem().dlopen(string, 257)) == 0L) {
            throw new UnsatisfiedLinkError("EGLPlatform failed to load the requested library " + string);
        }
    }

    @Override
    protected NativeCursor createCursor() {
        boolean bl = Boolean.getBoolean("monocle.egl.swcursor");
        NativeCursor nativeCursor = useCursor ? (bl ? new SoftwareCursor() : new EGLCursor()) : new NullCursor();
        return this.logSelectedCursor(nativeCursor);
    }

    @Override
    protected NativeScreen createScreen() {
        return new EGLScreen(0);
    }

    @Override
    protected synchronized List<NativeScreen> createScreens() {
        if (this.screens == null) {
            int n = this.nGetNumberOfScreens();
            this.screens = new ArrayList<NativeScreen>(n);
            for (int i = 0; i < n; ++i) {
                this.screens.add(new EGLScreen(i));
            }
        }
        return this.screens;
    }

    @Override
    public synchronized AcceleratedScreen getAcceleratedScreen(int[] nArray) throws GLException {
        if (this.accScreen == null) {
            this.accScreen = new EGLAcceleratedScreen(nArray);
        }
        return this.accScreen;
    }

    private native int nGetNumberOfScreens();
}

