/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.Framebuffer;
import com.sun.glass.ui.monocle.LinuxFrameBuffer;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.SoftwareCursor;
import com.sun.glass.ui.monocle.SysFS;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.util.function.IntConsumer;

class FBDevScreen
implements NativeScreen {
    private int nativeFormat;
    private long nativeHandle;
    private FileChannel fbdev;
    private ByteBuffer mappedFB;
    private boolean isShutdown;
    private int consoleCursorBlink;
    private Framebuffer fb;
    private LinuxFrameBuffer linuxFB;
    private final String fbDevPath;

    FBDevScreen() {
        String string;
        this.fbDevPath = string = AccessController.doPrivileged(() -> System.getProperty("monocle.screen.fb", "/dev/fb0"));
        try {
            this.linuxFB = new LinuxFrameBuffer(this.fbDevPath);
            this.nativeHandle = 1L;
            this.nativeFormat = 1;
            try {
                this.consoleCursorBlink = SysFS.readInt("/sys/devices/virtual/graphics/fbcon/cursor_blink");
                if (this.consoleCursorBlink != 0) {
                    SysFS.write("/sys/devices/virtual/graphics/fbcon/cursor_blink", "0");
                }
            }
            catch (IOException iOException) {
                this.consoleCursorBlink = 0;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw (IllegalStateException)new IllegalStateException().initCause(iOException);
        }
    }

    @Override
    public int getDepth() {
        return this.linuxFB.getDepth();
    }

    @Override
    public int getNativeFormat() {
        return this.nativeFormat;
    }

    @Override
    public int getWidth() {
        return this.linuxFB.getWidth();
    }

    @Override
    public int getHeight() {
        return this.linuxFB.getHeight();
    }

    @Override
    public long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public int getDPI() {
        return 96;
    }

    private boolean isFBDevOpen() {
        return this.mappedFB != null || this.fbdev != null;
    }

    private void openFBDev() throws IOException {
        if (this.mappedFB == null) {
            Path path = FileSystems.getDefault().getPath(this.fbDevPath, new String[0]);
            this.fbdev = FileChannel.open(path, StandardOpenOption.WRITE);
        }
    }

    private void closeFBDev() {
        if (this.mappedFB != null) {
            this.linuxFB.releaseMappedBuffer(this.mappedFB);
            this.mappedFB = null;
        } else if (this.fbdev != null) {
            try {
                this.fbdev.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fbdev = null;
        }
        this.linuxFB.close();
    }

    private Framebuffer getFramebuffer() {
        if (this.fb == null) {
            if (this.linuxFB.getDepth() == 32 && this.linuxFB.canDoubleBuffer()) {
                this.mappedFB = this.linuxFB.getMappedBuffer();
            }
            ByteBuffer byteBuffer = this.mappedFB != null ? this.mappedFB : ByteBuffer.allocateDirect(this.getWidth() * this.getHeight() * 4);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.fb = new Framebuffer(byteBuffer, this.getWidth(), this.getHeight(), this.getDepth(), true);
            this.fb.setStartAddress(this.linuxFB.getNextAddress());
        }
        return this.fb;
    }

    private void forEachPixelOffset(IntConsumer intConsumer) {
        int n = this.getHeight();
        int n2 = this.getWidth();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                intConsumer.accept(i * n2 + j);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        this.getFramebuffer().clearBufferContents();
        try {
            if (this.isFBDevOpen()) {
                this.writeBuffer();
                this.closeFBDev();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.isShutdown = true;
        }
        if (this.consoleCursorBlink != 0) {
            try {
                SysFS.write("/sys/devices/virtual/graphics/fbcon/cursor_blink", String.valueOf(this.consoleCursorBlink));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void uploadPixels(Buffer buffer, int n, int n2, int n3, int n4, float f) {
        this.getFramebuffer().composePixels(buffer, n, n2, n3, n4, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void swapBuffers() {
        try {
            if (this.isShutdown || this.fb == null || !this.getFramebuffer().hasReceivedData()) {
                return;
            }
            NativeCursor nativeCursor = NativePlatformFactory.getNativePlatform().getCursor();
            if (nativeCursor instanceof SoftwareCursor && nativeCursor.getVisiblity()) {
                SoftwareCursor softwareCursor = (SoftwareCursor)nativeCursor;
                Buffer buffer = softwareCursor.getCursorBuffer();
                Size size = softwareCursor.getBestSize();
                this.uploadPixels(buffer, softwareCursor.getRenderX(), softwareCursor.getRenderY(), size.width, size.height, 1.0f);
            }
            this.writeBuffer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.getFramebuffer().reset();
        }
    }

    private synchronized void writeBuffer() throws IOException {
        if (!this.linuxFB.isDoubleBuffer()) {
            this.linuxFB.vSync();
        }
        if (this.mappedFB == null) {
            if (!this.isFBDevOpen()) {
                this.openFBDev();
            }
            this.fbdev.position(this.linuxFB.getNextAddress());
            this.getFramebuffer().write(this.fbdev);
        } else if (this.linuxFB.isDoubleBuffer()) {
            this.linuxFB.next();
            this.linuxFB.vSync();
            this.getFramebuffer().setStartAddress(this.linuxFB.getNextAddress());
        }
    }

    @Override
    public synchronized ByteBuffer getScreenCapture() {
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = this.linuxFB.getMappedBuffer();
        if (byteBuffer2 != null) {
            byteBuffer2.position(this.linuxFB.getNativeOffset());
            byteBuffer2.order(ByteOrder.nativeOrder());
            byteBuffer = ByteBuffer.allocate(this.getHeight() * this.getWidth() * 4);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            if (this.getDepth() == 32) {
                IntBuffer intBuffer2 = byteBuffer2.asIntBuffer();
                this.forEachPixelOffset(n -> intBuffer.put(intBuffer2.get(n)));
            } else {
                ShortBuffer shortBuffer = byteBuffer2.asShortBuffer();
                this.forEachPixelOffset(n -> {
                    short s = shortBuffer.get(n);
                    int n2 = 0xFF000000 | (s & 0xF800) << 8 | (s & 0x7E0) << 5 | (s & 0x1F) << 3;
                    intBuffer.put(n2);
                });
            }
            this.linuxFB.releaseMappedBuffer(byteBuffer2);
        }
        return byteBuffer;
    }
}

