/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxInputProcessor;
import com.sun.glass.ui.monocle.LinuxKeyProcessor;
import com.sun.glass.ui.monocle.LinuxMouseProcessor;
import com.sun.glass.ui.monocle.LinuxSimpleTouchProcessor;
import com.sun.glass.ui.monocle.LinuxStatefulMultiTouchProcessor;
import com.sun.glass.ui.monocle.LinuxStatelessMultiTouchProcessor;
import com.sun.glass.ui.monocle.SysFS;
import com.sun.glass.ui.monocle.Udev;
import com.sun.glass.ui.monocle.UdevListener;
import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

class LinuxInputDeviceRegistry
extends InputDeviceRegistry {
    LinuxInputDeviceRegistry(boolean bl) {
        if (bl) {
            return;
        }
        HashMap hashMap = new HashMap();
        UdevListener udevListener = (string, map2) -> {
            String string2 = (String)map2.get("SUBSYSTEM");
            String string3 = (String)map2.get("DEVPATH");
            String string4 = (String)map2.get("DEVNAME");
            if (string2 != null && string2.equals("input") && string3 != null && string4 != null) {
                try {
                    File file = new File("/sys", string3);
                    if (string.equals("add") || string.equals("change") && !hashMap.containsKey(file)) {
                        File file2 = new File(string4);
                        LinuxInputDevice linuxInputDevice = this.createDevice(file2, file, map2);
                        if (linuxInputDevice != null) {
                            hashMap.put(file, linuxInputDevice);
                        }
                    } else if (string.equals("remove")) {
                        LinuxInputDevice linuxInputDevice = (LinuxInputDevice)hashMap.get(file);
                        hashMap.remove(file);
                        if (linuxInputDevice != null) {
                            this.devices.remove((Object)linuxInputDevice);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        Udev.getInstance().addListener(udevListener);
        SysFS.triggerUdevNotification("input");
    }

    private LinuxInputDevice createDevice(File file, File file2, Map<String, String> map) throws IOException {
        LinuxInputDevice linuxInputDevice = new LinuxInputDevice(file, file2, map);
        return this.addDeviceInternal(linuxInputDevice, "Linux input: " + file.toString());
    }

    LinuxInputDevice addDevice(LinuxInputDevice linuxInputDevice, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        return this.addDeviceInternal(linuxInputDevice, string);
    }

    private LinuxInputDevice addDeviceInternal(LinuxInputDevice linuxInputDevice, String string) {
        LinuxInputProcessor linuxInputProcessor = this.createInputProcessor(linuxInputDevice);
        if (linuxInputProcessor == null) {
            return null;
        }
        linuxInputDevice.setInputProcessor(linuxInputProcessor);
        Thread thread = new Thread(linuxInputDevice);
        thread.setName(string);
        thread.setDaemon(true);
        thread.start();
        this.devices.add((Object)linuxInputDevice);
        return linuxInputDevice;
    }

    void removeDevice(LinuxInputDevice linuxInputDevice) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        this.devices.remove((Object)linuxInputDevice);
    }

    private LinuxInputProcessor createInputProcessor(LinuxInputDevice linuxInputDevice) {
        if (linuxInputDevice.isTouch()) {
            boolean bl;
            BitSet bitSet = linuxInputDevice.getCapability("abs");
            boolean bl2 = bl = bitSet.get(53) && bitSet.get(54);
            if (bl) {
                if (bitSet.get(57)) {
                    return new LinuxStatefulMultiTouchProcessor(linuxInputDevice);
                }
                return new LinuxStatelessMultiTouchProcessor(linuxInputDevice);
            }
            return new LinuxSimpleTouchProcessor(linuxInputDevice);
        }
        if (linuxInputDevice.isRelative()) {
            return new LinuxMouseProcessor();
        }
        BitSet bitSet = linuxInputDevice.getCapability("key");
        if (bitSet != null && !bitSet.isEmpty()) {
            return new LinuxKeyProcessor();
        }
        return null;
    }
}

