/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MonocleApplication;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.RunnableProcessor;
import java.util.BitSet;

class MouseInput {
    private static MouseInput instance = new MouseInput();
    private MouseState state = new MouseState();
    private IntSet buttons = new IntSet();
    private boolean dragInProgress = false;
    private int dragButton = 211;
    private MonocleView dragView = null;
    private BitSet dragActions = new BitSet();
    private static final int DRAG_ENTER = 1;
    private static final int DRAG_LEAVE = 2;
    private static final int DRAG_OVER = 3;
    private static final int DRAG_DROP = 4;

    MouseInput() {
    }

    static MouseInput getInstance() {
        return instance;
    }

    void getState(MouseState mouseState) {
        this.state.copyTo(mouseState);
    }

    void setState(MouseState mouseState, boolean bl) {
        boolean bl2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        MonocleView monocleView;
        if (MonocleSettings.settings.traceEvents) {
            MonocleTrace.traceEvent("Set %s", mouseState);
        }
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        int n6 = Math.max(0, Math.min(mouseState.getX(), nativeScreen.getWidth() - 1));
        int n7 = Math.max(0, Math.min(mouseState.getY(), nativeScreen.getHeight() - 1));
        mouseState.setX(n6);
        mouseState.setY(n7);
        MonocleWindow monocleWindow = this.state.getWindow(false, null);
        boolean bl4 = this.state.getButtonsPressed().isEmpty();
        MonocleWindow monocleWindow2 = mouseState.getWindow(bl4, null);
        MonocleView monocleView2 = monocleView = monocleWindow2 == null ? null : (MonocleView)monocleWindow2.getView();
        if (monocleWindow != monocleWindow2 && monocleWindow != null) {
            if (!monocleWindow.isEnabled()) {
                RunnableProcessor.runLater(() -> MonocleWindowManager.getInstance().notifyFocusDisabled(monocleWindow));
            } else {
                MonocleView monocleView3 = (MonocleView)monocleWindow.getView();
                if (monocleView3 != null) {
                    KeyState keyState = new KeyState();
                    KeyInput.getInstance().getState(keyState);
                    n5 = this.state.getModifiers() | keyState.getModifiers();
                    int n8 = this.state.getButton();
                    n4 = 0;
                    n3 = this.state.getX();
                    n2 = this.state.getY();
                    n = n3 - monocleWindow.getX();
                    int bl3 = n2 - monocleWindow.getY();
                    try {
                        this.postMouseEvent(monocleView3, 226, n8, n, bl3, n3, n2, n5, n4 != 0, bl);
                    }
                    catch (RuntimeException runtimeException) {
                        Application.reportException(runtimeException);
                    }
                }
            }
        }
        boolean bl3 = bl2 = this.state.getX() != n6 || this.state.getY() != n7;
        if (bl2) {
            NativePlatformFactory.getNativePlatform().getCursor().setLocation(n6, n7);
        }
        if (monocleView == null) {
            mouseState.copyTo(this.state);
            return;
        }
        if (monocleWindow2 != null && !monocleWindow2.isEnabled()) {
            mouseState.copyTo(this.state);
            RunnableProcessor.runLater(() -> MonocleWindowManager.getInstance().notifyFocusDisabled(monocleWindow2));
            return;
        }
        int n9 = n6 - monocleWindow2.getX();
        n5 = n7 - monocleWindow2.getY();
        if (monocleWindow != monocleWindow2 && monocleView != null) {
            KeyState keyState = new KeyState();
            KeyInput.getInstance().getState(keyState);
            n4 = this.state.getModifiers() | keyState.getModifiers();
            n3 = this.state.getButton();
            n2 = 0;
            this.postMouseEvent(monocleView, 225, n3, n9, n5, n6, n7, n4, n2 != 0, bl);
        }
        if (monocleWindow != monocleWindow2 | bl2) {
            boolean bl6 = !this.state.getButtonsPressed().isEmpty();
            n4 = bl6 ? 223 : 224;
            KeyState keyState = new KeyState();
            KeyInput.getInstance().getState(keyState);
            n2 = this.state.getModifiers() | keyState.getModifiers();
            n = this.state.getButton();
            boolean bl5 = false;
            this.postMouseEvent(monocleView, n4, n, n9, n5, n6, n7, n2, bl5, bl);
        }
        mouseState.getButtonsPressed().difference(this.buttons, this.state.getButtonsPressed());
        if (!this.buttons.isEmpty()) {
            MouseState mouseState2 = new MouseState();
            this.state.copyTo(mouseState2);
            for (n4 = 0; n4 < this.buttons.size(); ++n4) {
                int n10 = this.buttons.get(n4);
                mouseState2.pressButton(n10);
                KeyState keyState = new KeyState();
                KeyInput.getInstance().getState(keyState);
                n = mouseState2.getModifiers() | keyState.getModifiers();
                boolean bl6 = false;
                this.postMouseEvent(monocleView, 221, n10, n9, n5, n6, n7, n, bl6, bl);
            }
        }
        this.buttons.clear();
        this.state.getButtonsPressed().difference(this.buttons, mouseState.getButtonsPressed());
        if (!this.buttons.isEmpty()) {
            MouseState mouseState3 = new MouseState();
            this.state.copyTo(mouseState3);
            for (n4 = 0; n4 < this.buttons.size(); ++n4) {
                int n11 = this.buttons.get(n4);
                mouseState3.releaseButton(n11);
                KeyState keyState = new KeyState();
                KeyInput.getInstance().getState(keyState);
                n = mouseState3.getModifiers() | keyState.getModifiers();
                boolean bl7 = false;
                this.postMouseEvent(monocleView, 222, n11, n9, n5, n6, n7, n, bl7, bl);
            }
        }
        this.buttons.clear();
        if (mouseState.getWheel() != this.state.getWheel()) {
            double d;
            switch (mouseState.getWheel()) {
                case -1: {
                    d = -1.0;
                    break;
                }
                case 1: {
                    d = 1.0;
                    break;
                }
                default: {
                    d = 0.0;
                }
            }
            if (d != 0.0) {
                KeyState keyState = new KeyState();
                KeyInput.getInstance().getState(keyState);
                int n12 = mouseState.getModifiers() | keyState.getModifiers();
                RunnableProcessor.runLater(() -> monocleView.notifyScroll(n9, n5, n6, n7, 0.0, d, n12, 1, 0, 0, 0, 1.0, 1.0));
            }
            mouseState.setWheel(0);
        }
        mouseState.copyTo(this.state);
    }

    private void postMouseEvent(MonocleView monocleView, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        RunnableProcessor.runLater(() -> this.notifyMouse(monocleView, n, n2, n3, n4, n5, n6, n7, bl, bl2));
    }

    private void notifyMouse(MonocleView monocleView, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        switch (n) {
            case 221: {
                if (this.dragButton != 211) break;
                this.dragButton = n2;
                break;
            }
            case 222: {
                if (this.dragButton != n2) break;
                this.dragButton = 211;
                if (!this.dragInProgress) break;
                try {
                    monocleView.notifyDragDrop(n3, n4, n5, n6, 2);
                }
                catch (RuntimeException runtimeException) {
                    Application.reportException(runtimeException);
                }
                try {
                    monocleView.notifyDragEnd(2);
                }
                catch (RuntimeException runtimeException) {
                    Application.reportException(runtimeException);
                }
                ((MonocleApplication)Application.GetApplication()).leaveDndEventLoop();
                this.dragActions.clear();
                this.dragView = null;
                this.dragInProgress = false;
                break;
            }
            case 223: {
                if (this.dragButton == 211) break;
                if (this.dragInProgress) {
                    if (this.dragView == monocleView && this.dragActions.isEmpty()) {
                        try {
                            monocleView.notifyDragEnter(n3, n4, n5, n6, 2);
                        }
                        catch (RuntimeException runtimeException) {
                            Application.reportException(runtimeException);
                        }
                        this.dragActions.set(1);
                    } else if (this.dragView == monocleView && this.dragActions.get(1)) {
                        try {
                            monocleView.notifyDragOver(n3, n4, n5, n6, 2);
                        }
                        catch (RuntimeException runtimeException) {
                            Application.reportException(runtimeException);
                        }
                        this.dragActions.set(3);
                    } else if (this.dragView != monocleView) {
                        if (this.dragView != null) {
                            try {
                                this.dragView.notifyDragLeave();
                            }
                            catch (RuntimeException runtimeException) {
                                Application.reportException(runtimeException);
                            }
                        }
                        try {
                            monocleView.notifyDragEnter(n3, n4, n5, n6, 2);
                        }
                        catch (RuntimeException runtimeException) {
                            Application.reportException(runtimeException);
                        }
                        this.dragActions.clear();
                        this.dragActions.set(1);
                        this.dragView = monocleView;
                    }
                    return;
                }
                if (this.dragView != null) break;
                this.dragView = monocleView;
            }
        }
        monocleView.notifyMouse(n, n2, n3, n4, n5, n6, n7, bl, bl2);
    }

    void notifyDragStart() {
        this.dragInProgress = true;
    }
}

