/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.C;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.utils.NativeLibLoader;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.Permission;
import java.text.MessageFormat;

class EPDSystem {
    static final int FB_ACTIVATE_FORCE = 128;
    static final int FB_ROTATE_UR = 0;
    static final int FB_ROTATE_CW = 1;
    static final int FB_ROTATE_UD = 2;
    static final int FB_ROTATE_CCW = 3;
    static final int GRAYSCALE_8BIT = 1;
    static final int GRAYSCALE_8BIT_INVERTED = 2;
    static final int AUTO_UPDATE_MODE_REGION_MODE = 0;
    static final int AUTO_UPDATE_MODE_AUTOMATIC_MODE = 1;
    static final int UPDATE_SCHEME_SNAPSHOT = 0;
    static final int UPDATE_SCHEME_QUEUE = 1;
    static final int UPDATE_SCHEME_QUEUE_AND_MERGE = 2;
    static final int UPDATE_MODE_PARTIAL = 0;
    static final int UPDATE_MODE_FULL = 1;
    static final int WAVEFORM_MODE_AUTO = 257;
    static final int TEMP_USE_AMBIENT = 4096;
    static final int EPDC_FLAG_ENABLE_INVERSION = 1;
    static final int EPDC_FLAG_FORCE_MONOCHROME = 2;
    static final int EPDC_FLAG_USE_DITHERING_Y1 = 8192;
    static final int EPDC_FLAG_USE_DITHERING_Y4 = 16384;
    static final int FB_POWERDOWN_DISABLE = -1;
    static final int WAVEFORM_MODE_INIT = 0;
    static final int WAVEFORM_MODE_DU = 1;
    static final int WAVEFORM_MODE_GC4 = 3;
    static final int WAVEFORM_MODE_GC16 = 2;
    static final int WAVEFORM_MODE_A2 = 4;
    private static final Permission PERMISSION = new RuntimePermission("loadLibrary.*");
    private static final EPDSystem INSTANCE = new EPDSystem();
    final int MXCFB_SET_WAVEFORM_MODES;
    final int MXCFB_SET_TEMPERATURE;
    final int MXCFB_SET_AUTO_UPDATE_MODE;
    final int MXCFB_SEND_UPDATE;
    final int MXCFB_WAIT_FOR_UPDATE_COMPLETE;
    final int MXCFB_SET_PWRDOWN_DELAY;
    final int MXCFB_GET_PWRDOWN_DELAY;
    final int MXCFB_SET_UPDATE_SCHEME;
    private final LinuxSystem system = LinuxSystem.getLinuxSystem();

    private static void checkPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(PERMISSION);
        }
    }

    static EPDSystem getEPDSystem() {
        EPDSystem.checkPermissions();
        return INSTANCE;
    }

    private EPDSystem() {
        this.MXCFB_SET_WAVEFORM_MODES = this.system.IOW(70, 43, 24);
        this.MXCFB_SET_TEMPERATURE = this.system.IOW(70, 44, 4);
        this.MXCFB_SET_AUTO_UPDATE_MODE = this.system.IOW(70, 45, 4);
        this.MXCFB_SEND_UPDATE = this.system.IOW(70, 46, 68);
        this.MXCFB_WAIT_FOR_UPDATE_COMPLETE = this.system.IOW(70, 47, 4);
        this.MXCFB_SET_PWRDOWN_DELAY = this.system.IOW(70, 48, 4);
        this.MXCFB_GET_PWRDOWN_DELAY = this.system.IOR(70, 49, 4);
        this.MXCFB_SET_UPDATE_SCHEME = this.system.IOW(70, 50, 4);
    }

    void loadLibrary() {
        NativeLibLoader.loadLibrary("glass_monocle_epd");
    }

    native int ioctl(long var1, int var3, int var4);

    public String toString() {
        return MessageFormat.format("{0}[MXCFB_SET_WAVEFORM_MODES=0x{1} MXCFB_SET_TEMPERATURE=0x{2} MXCFB_SET_AUTO_UPDATE_MODE=0x{3} MXCFB_SEND_UPDATE=0x{4} MXCFB_WAIT_FOR_UPDATE_COMPLETE=0x{5} MXCFB_SET_PWRDOWN_DELAY=0x{6} MXCFB_GET_PWRDOWN_DELAY=0x{7} MXCFB_SET_UPDATE_SCHEME=0x{8}]", this.getClass().getName(), Integer.toHexString(this.MXCFB_SET_WAVEFORM_MODES), Integer.toHexString(this.MXCFB_SET_TEMPERATURE), Integer.toHexString(this.MXCFB_SET_AUTO_UPDATE_MODE), Integer.toHexString(this.MXCFB_SEND_UPDATE), Integer.toHexString(this.MXCFB_WAIT_FOR_UPDATE_COMPLETE), Integer.toHexString(this.MXCFB_SET_PWRDOWN_DELAY), Integer.toHexString(this.MXCFB_GET_PWRDOWN_DELAY), Integer.toHexString(this.MXCFB_SET_UPDATE_SCHEME));
    }

    static class MxcfbWaveformModes
    extends C.Structure {
        private static final int MODE_INIT = 0;
        private static final int MODE_DU = 1;
        private static final int MODE_GC4 = 2;
        private static final int MODE_GC8 = 3;
        private static final int MODE_GC16 = 4;
        private static final int MODE_GC32 = 5;
        private static final int NUM_INTS = 6;
        private static final int BYTES = 24;
        private final IntBuffer data;

        MxcfbWaveformModes() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asIntBuffer();
        }

        @Override
        int sizeof() {
            return 24;
        }

        int getModeInit(long l) {
            return this.data.get(0);
        }

        int getModeDu(long l) {
            return this.data.get(1);
        }

        int getModeGc4(long l) {
            return this.data.get(2);
        }

        int getModeGc8(long l) {
            return this.data.get(3);
        }

        int getModeGc16(long l) {
            return this.data.get(4);
        }

        int getModeGc32(long l) {
            return this.data.get(5);
        }

        void setModes(long l, int n, int n2, int n3, int n4, int n5, int n6) {
            this.data.put(0, n);
            this.data.put(1, n2);
            this.data.put(2, n3);
            this.data.put(3, n4);
            this.data.put(4, n5);
            this.data.put(5, n6);
        }

        public String toString() {
            return MessageFormat.format("{0}[mode_init={1} mode_du={2} mode_gc4={3} mode_gc8={4} mode_gc16={5} mode_gc32={6}]", this.getClass().getName(), this.getModeInit(this.p), this.getModeDu(this.p), this.getModeGc4(this.p), this.getModeGc8(this.p), this.getModeGc16(this.p), this.getModeGc32(this.p));
        }
    }

    static class MxcfbUpdateData
    extends C.Structure {
        private static final int UPDATE_REGION_TOP = 0;
        private static final int UPDATE_REGION_LEFT = 1;
        private static final int UPDATE_REGION_WIDTH = 2;
        private static final int UPDATE_REGION_HEIGHT = 3;
        private static final int WAVEFORM_MODE = 4;
        private static final int UPDATE_MODE = 5;
        private static final int UPDATE_MARKER = 6;
        private static final int TEMP = 7;
        private static final int FLAGS = 8;
        private static final int ALT_BUFFER_DATA_VIRT_ADDR = 9;
        private static final int ALT_BUFFER_DATA_PHYS_ADDR = 10;
        private static final int ALT_BUFFER_DATA_WIDTH = 11;
        private static final int ALT_BUFFER_DATA_HEIGHT = 12;
        private static final int ALT_BUFFER_DATA_ALT_UPDATE_REGION_TOP = 13;
        private static final int ALT_BUFFER_DATA_ALT_UPDATE_REGION_LEFT = 14;
        private static final int ALT_BUFFER_DATA_ALT_UPDATE_REGION_WIDTH = 15;
        private static final int ALT_BUFFER_DATA_ALT_UPDATE_REGION_HEIGHT = 16;
        private static final int NUM_INTS = 17;
        private static final int BYTES = 68;
        private final IntBuffer data;

        MxcfbUpdateData() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asIntBuffer();
        }

        @Override
        int sizeof() {
            return 68;
        }

        int getUpdateRegionTop(long l) {
            return this.data.get(0);
        }

        int getUpdateRegionLeft(long l) {
            return this.data.get(1);
        }

        int getUpdateRegionWidth(long l) {
            return this.data.get(2);
        }

        int getUpdateRegionHeight(long l) {
            return this.data.get(3);
        }

        int getWaveformMode(long l) {
            return this.data.get(4);
        }

        int getUpdateMode(long l) {
            return this.data.get(5);
        }

        int getUpdateMarker(long l) {
            return this.data.get(6);
        }

        int getTemp(long l) {
            return this.data.get(7);
        }

        int getFlags(long l) {
            return this.data.get(8);
        }

        long getAltBufferDataVirtAddr(long l) {
            return this.data.get(9);
        }

        long getAltBufferDataPhysAddr(long l) {
            return this.data.get(10);
        }

        int getAltBufferDataWidth(long l) {
            return this.data.get(11);
        }

        int getAltBufferDataHeight(long l) {
            return this.data.get(12);
        }

        int getAltBufferDataAltUpdateRegionTop(long l) {
            return this.data.get(13);
        }

        int getAltBufferDataAltUpdateRegionLeft(long l) {
            return this.data.get(14);
        }

        int getAltBufferDataAltUpdateRegionWidth(long l) {
            return this.data.get(15);
        }

        int getAltBufferDataAltUpdateRegionHeight(long l) {
            return this.data.get(16);
        }

        void setUpdateRegion(long l, int n, int n2, int n3, int n4) {
            this.data.put(0, n);
            this.data.put(1, n2);
            this.data.put(2, n3);
            this.data.put(3, n4);
        }

        void setWaveformMode(long l, int n) {
            this.data.put(4, n);
        }

        void setUpdateMode(long l, int n) {
            this.data.put(5, n);
        }

        void setUpdateMarker(long l, int n) {
            this.data.put(6, n);
        }

        void setTemp(long l, int n) {
            this.data.put(7, n);
        }

        void setFlags(long l, int n) {
            this.data.put(8, n);
        }

        void setAltBufferData(long l, long l2, long l3, int n, int n2, int n3, int n4, int n5, int n6) {
            this.data.put(9, (int)l2);
            this.data.put(10, (int)l3);
            this.data.put(11, n);
            this.data.put(12, n2);
            this.data.put(13, n3);
            this.data.put(14, n4);
            this.data.put(15, n5);
            this.data.put(16, n6);
        }

        public String toString() {
            return MessageFormat.format("{0}[update_region.top={1} update_region.left={2} update_region.width={3} update_region.height={4} waveform_mode={5} update_mode={6} update_marker={7} temp={8} flags=0x{9} alt_buffer_data.virt_addr=0x{10} alt_buffer_data.phys_addr=0x{11} alt_buffer_data.width={12} alt_buffer_data.height={13} alt_buffer_data.alt_update_region.top={14} alt_buffer_data.alt_update_region.left={15} alt_buffer_data.alt_update_region.width={16} alt_buffer_data.alt_update_region.height={17}]", this.getClass().getName(), Integer.toUnsignedLong(this.getUpdateRegionTop(this.p)), Integer.toUnsignedLong(this.getUpdateRegionLeft(this.p)), Integer.toUnsignedLong(this.getUpdateRegionWidth(this.p)), Integer.toUnsignedLong(this.getUpdateRegionHeight(this.p)), Integer.toUnsignedLong(this.getWaveformMode(this.p)), Integer.toUnsignedLong(this.getUpdateMode(this.p)), Integer.toUnsignedLong(this.getUpdateMarker(this.p)), this.getTemp(this.p), Integer.toHexString(this.getFlags(this.p)), Long.toHexString(this.getAltBufferDataVirtAddr(this.p)), Long.toHexString(this.getAltBufferDataPhysAddr(this.p)), Integer.toUnsignedLong(this.getAltBufferDataWidth(this.p)), Integer.toUnsignedLong(this.getAltBufferDataHeight(this.p)), Integer.toUnsignedLong(this.getAltBufferDataAltUpdateRegionTop(this.p)), Integer.toUnsignedLong(this.getAltBufferDataAltUpdateRegionLeft(this.p)), Integer.toUnsignedLong(this.getAltBufferDataAltUpdateRegionWidth(this.p)), Integer.toUnsignedLong(this.getAltBufferDataAltUpdateRegionHeight(this.p)));
        }
    }

    static class IntStructure
    extends C.Structure {
        private static final int VALUE = 0;
        private static final int NUM_INTS = 1;
        private static final int BYTES = 4;
        private final IntBuffer data;

        IntStructure() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asIntBuffer();
        }

        @Override
        int sizeof() {
            return 4;
        }

        int get(long l) {
            return this.data.get(0);
        }

        void set(long l, int n) {
            this.data.put(0, n);
        }
    }

    static class FbVarScreenInfo
    extends LinuxSystem.FbVarScreenInfo {
        FbVarScreenInfo() {
        }

        native int getGrayscale(long var1);

        native int getRedOffset(long var1);

        native int getRedLength(long var1);

        native int getRedMsbRight(long var1);

        native int getGreenOffset(long var1);

        native int getGreenLength(long var1);

        native int getGreenMsbRight(long var1);

        native int getBlueOffset(long var1);

        native int getBlueLength(long var1);

        native int getBlueMsbRight(long var1);

        native int getTranspOffset(long var1);

        native int getTranspLength(long var1);

        native int getTranspMsbRight(long var1);

        native int getNonstd(long var1);

        native int getActivate(long var1);

        native int getHeight(long var1);

        native int getWidth(long var1);

        native int getAccelFlags(long var1);

        native int getPixclock(long var1);

        native int getLeftMargin(long var1);

        native int getRightMargin(long var1);

        native int getUpperMargin(long var1);

        native int getLowerMargin(long var1);

        native int getHsyncLen(long var1);

        native int getVsyncLen(long var1);

        native int getSync(long var1);

        native int getVmode(long var1);

        native int getRotate(long var1);

        native void setGrayscale(long var1, int var3);

        native void setNonstd(long var1, int var3);

        native void setHeight(long var1, int var3);

        native void setWidth(long var1, int var3);

        native void setAccelFlags(long var1, int var3);

        native void setPixclock(long var1, int var3);

        native void setLeftMargin(long var1, int var3);

        native void setRightMargin(long var1, int var3);

        native void setUpperMargin(long var1, int var3);

        native void setLowerMargin(long var1, int var3);

        native void setHsyncLen(long var1, int var3);

        native void setVsyncLen(long var1, int var3);

        native void setSync(long var1, int var3);

        native void setVmode(long var1, int var3);

        native void setRotate(long var1, int var3);
    }
}

