/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxInput;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class LinuxEventBuffer {
    private static final int EVENT_BUFFER_SIZE = 1000;
    private final ByteBuffer bb;
    private final EventStruct eventStruct;
    private int positionOfLastSync;
    private int currentPosition;
    private int mark;

    LinuxEventBuffer(int n) {
        this.eventStruct = n == 64 ? new EventStruct64Bit() : new EventStruct32Bit();
        this.bb = ByteBuffer.allocate(this.eventStruct.getSize() * 1000);
        this.bb.order(ByteOrder.nativeOrder());
    }

    int getEventSize() {
        return this.eventStruct.getSize();
    }

    synchronized boolean put(ByteBuffer byteBuffer) throws InterruptedException {
        boolean bl;
        boolean bl2 = bl = byteBuffer.getShort(this.eventStruct.getTypeIndex()) == 0 && byteBuffer.getInt(this.eventStruct.getValueIndex()) == 0;
        while (this.bb.limit() - this.bb.position() < byteBuffer.limit()) {
            if (MonocleSettings.settings.traceEventsVerbose) {
                MonocleTrace.traceEvent("Event buffer %s is full, waiting for some space to become available", this.bb);
            }
            this.wait();
        }
        if (bl) {
            this.positionOfLastSync = this.bb.position();
        }
        this.bb.put(byteBuffer);
        if (MonocleSettings.settings.traceEventsVerbose) {
            int n = this.bb.position() - this.eventStruct.getSize();
            MonocleTrace.traceEvent("Read %s [index=%d]", this.getEventDescription(n), n);
        }
        return bl;
    }

    synchronized void startIteration() {
        this.currentPosition = 0;
        this.mark = 0;
        if (MonocleSettings.settings.traceEventsVerbose) {
            MonocleTrace.traceEvent("Processing %s [index=%d]", this.getEventDescription(), this.currentPosition);
        }
    }

    synchronized void compact() {
        this.positionOfLastSync -= this.currentPosition;
        int n = this.bb.position();
        this.bb.position(this.currentPosition);
        this.bb.limit(n);
        this.bb.compact();
        if (MonocleSettings.settings.traceEventsVerbose) {
            MonocleTrace.traceEvent("Compacted event buffer %s", this.bb);
        }
        this.notifyAll();
    }

    synchronized short getEventType() {
        return this.bb.getShort(this.currentPosition + this.eventStruct.getTypeIndex());
    }

    short getEventCode() {
        return this.bb.getShort(this.currentPosition + this.eventStruct.getCodeIndex());
    }

    synchronized int getEventValue() {
        return this.bb.getInt(this.currentPosition + this.eventStruct.getValueIndex());
    }

    synchronized String getEventDescription() {
        return this.getEventDescription(this.currentPosition);
    }

    private synchronized String getEventDescription(int n) {
        short s = this.bb.getShort(n + this.eventStruct.getTypeIndex());
        short s2 = this.bb.getShort(n + this.eventStruct.getCodeIndex());
        int n2 = this.bb.getInt(n + this.eventStruct.getValueIndex());
        String string = LinuxInput.typeToString(s);
        return string + " " + LinuxInput.codeToString(string, s2) + " " + n2;
    }

    synchronized void nextEvent() {
        if (this.currentPosition > this.positionOfLastSync) {
            throw new IllegalStateException("Cannot advance past the last EV_SYN EV_SYN_REPORT 0");
        }
        this.currentPosition += this.eventStruct.getSize();
        if (MonocleSettings.settings.traceEventsVerbose && this.hasNextEvent()) {
            MonocleTrace.traceEvent("Processing %s [index=%d]", this.getEventDescription(), this.currentPosition);
        }
    }

    synchronized void mark() {
        this.mark = this.currentPosition;
    }

    synchronized void reset() {
        this.currentPosition = this.mark;
    }

    synchronized boolean hasNextEvent() {
        return this.currentPosition <= this.positionOfLastSync;
    }

    synchronized boolean hasData() {
        return this.bb.position() != 0;
    }

    class EventStruct64Bit
    implements EventStruct {
        EventStruct64Bit() {
        }

        @Override
        public int getTypeIndex() {
            return 16;
        }

        @Override
        public int getCodeIndex() {
            return 18;
        }

        @Override
        public int getValueIndex() {
            return 20;
        }

        @Override
        public int getSize() {
            return 24;
        }
    }

    class EventStruct32Bit
    implements EventStruct {
        EventStruct32Bit() {
        }

        @Override
        public int getTypeIndex() {
            return 8;
        }

        @Override
        public int getCodeIndex() {
            return 10;
        }

        @Override
        public int getValueIndex() {
            return 12;
        }

        @Override
        public int getSize() {
            return 16;
        }
    }

    static interface EventStruct {
        public int getTypeIndex();

        public int getCodeIndex();

        public int getValueIndex();

        public int getSize();
    }
}

