/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.TouchFilter;
import com.sun.glass.ui.monocle.TouchState;

class LookaheadTouchFilter
implements TouchFilter {
    private TouchState previousState = new TouchState();
    private TouchState tmpState = new TouchState();
    private boolean assignIDs;
    private FilterState filterState = FilterState.CLEAN;

    LookaheadTouchFilter(boolean bl) {
        this.assignIDs = bl;
    }

    @Override
    public boolean filter(TouchState touchState) {
        touchState.sortPointsByID();
        switch (this.filterState) {
            case CLEAN: {
                touchState.copyTo(this.previousState);
                this.filterState = FilterState.PENDING_UNMODIFIABLE;
                return true;
            }
            case PENDING_UNMODIFIABLE: {
                touchState.copyTo(this.tmpState);
                this.previousState.copyTo(touchState);
                this.tmpState.copyTo(this.previousState);
                if (touchState.canBeFoldedWith(this.previousState, this.assignIDs)) {
                    this.filterState = FilterState.PENDING_MODIFIABLE;
                }
                return false;
            }
            case PENDING_MODIFIABLE: {
                if (touchState.canBeFoldedWith(this.previousState, this.assignIDs)) {
                    touchState.copyTo(this.previousState);
                    return true;
                }
                touchState.copyTo(this.tmpState);
                this.previousState.copyTo(touchState);
                this.tmpState.copyTo(this.previousState);
                this.filterState = FilterState.PENDING_UNMODIFIABLE;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean flush(TouchState touchState) {
        switch (this.filterState) {
            case PENDING_UNMODIFIABLE: 
            case PENDING_MODIFIABLE: {
                this.previousState.copyTo(touchState);
                this.filterState = FilterState.CLEAN;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 101;
    }

    public String toString() {
        return "Lookahead[previousState=" + this.previousState + ",filterState=" + this.filterState + "]";
    }

    private static enum FilterState {
        CLEAN,
        PENDING_UNMODIFIABLE,
        PENDING_MODIFIABLE;

    }
}

