/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.monocle.InputDevice;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.MonocleCursor;
import com.sun.glass.ui.monocle.MonoclePixels;
import com.sun.glass.ui.monocle.MonocleRobot;
import com.sun.glass.ui.monocle.MonocleTimer;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.RunnableProcessor;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.List;

public final class MonocleApplication
extends Application {
    private final NativePlatform platform = NativePlatformFactory.getNativePlatform();
    private final RunnableProcessor runnableProcessor = this.platform.getRunnableProcessor();
    private static final int DEVICE_TOUCH = 0;
    private static final int DEVICE_MULTITOUCH = 1;
    private static final int DEVICE_POINTER = 2;
    private static final int DEVICE_5WAY = 3;
    private static final int DEVICE_PC_KEYBOARD = 4;
    private static final int DEVICE_MAX = 4;
    private int[] deviceFlags = new int[5];
    private Thread shutdownHookThread;
    private Runnable renderEndNotifier = () -> this.platform.getScreen().swapBuffers();

    MonocleApplication() {
        for (InputDevice inputDevice : this.platform.getInputDeviceRegistry().getInputDevices()) {
            this.updateDeviceFlags(inputDevice, true);
        }
        this.platform.getInputDeviceRegistry().getInputDevices().addListener(change -> {
            if (change.wasAdded()) {
                InputDevice inputDevice = (InputDevice)change.getElementAdded();
                this.updateDeviceFlags(inputDevice, true);
            } else if (change.wasRemoved()) {
                InputDevice inputDevice = (InputDevice)change.getElementRemoved();
                this.updateDeviceFlags(inputDevice, false);
            }
        });
    }

    private void updateDeviceFlags(InputDevice inputDevice, boolean bl) {
        int n;
        int n2 = n = bl ? 1 : -1;
        if (inputDevice.isTouch()) {
            this.deviceFlags[0] = this.deviceFlags[0] + n;
        }
        if (inputDevice.isMultiTouch()) {
            this.deviceFlags[1] = this.deviceFlags[1] + n;
        }
        if (inputDevice.isRelative()) {
            this.deviceFlags[2] = this.deviceFlags[2] + n;
            if (this.deviceFlags[2] >= 1 && bl) {
                this.staticCursor_setVisible(true);
            } else if (this.deviceFlags[2] < 1 && !bl) {
                this.staticCursor_setVisible(false);
            }
        }
        if (inputDevice.isFullKeyboard()) {
            this.deviceFlags[4] = this.deviceFlags[4] + n;
        }
        if (inputDevice.is5Way()) {
            this.deviceFlags[3] = this.deviceFlags[3] + n;
        }
    }

    @Override
    protected void runLoop(Runnable runnable) {
        this.runnableProcessor.invokeLater(runnable);
        long l = AccessController.doPrivileged(() -> Long.getLong("monocle.stackSize", 0L));
        Thread thread = new Thread(new ThreadGroup("Event"), this.runnableProcessor, "Event Thread", l);
        MonocleApplication.setEventThread(thread);
        thread.start();
        this.shutdownHookThread = new Thread("Monocle shutdown hook"){

            @Override
            public void run() {
                MonocleApplication.this.platform.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        this.runnableProcessor.invokeAndWait(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        this.runnableProcessor.invokeLater(runnable);
    }

    @Override
    protected Object _enterNestedEventLoop() {
        return this.runnableProcessor.enterNestedEventLoop();
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        this.runnableProcessor.leaveNestedEventLoop(object);
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        return new MonocleWindow(window, screen, n);
    }

    @Override
    public Window createWindow(long l) {
        return new MonocleWindow(l);
    }

    @Override
    public View createView() {
        return new MonocleView();
    }

    @Override
    public Cursor createCursor(int n) {
        return new MonocleCursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        return new MonocleCursor(n, n2, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
        NativeCursor nativeCursor = NativePlatformFactory.getNativePlatform().getCursor();
        nativeCursor.setVisibility(this.deviceFlags[2] >= 1 ? bl : false);
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        NativeCursor nativeCursor = NativePlatformFactory.getNativePlatform().getCursor();
        return nativeCursor.getBestSize();
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new MonoclePixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new MonoclePixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f, float f2) {
        return new MonoclePixels(n, n2, intBuffer, f, f2);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return this.platform.getScreen().getNativeFormat();
    }

    @Override
    public GlassRobot createRobot() {
        return new MonocleRobot();
    }

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected Screen[] staticScreen_getScreens() {
        List<NativeScreen> list = this.platform.getScreens();
        Screen[] screenArray = new Screen[list.size()];
        int n = 0;
        for (NativeScreen nativeScreen : list) {
            Screen screen;
            screenArray[n] = screen = new Screen(nativeScreen.getNativeHandle(), nativeScreen.getDepth(), nativeScreen.getOffsetX(), nativeScreen.getOffsetY(), nativeScreen.getWidth(), nativeScreen.getHeight(), nativeScreen.getOffsetX(), nativeScreen.getOffsetY(), nativeScreen.getWidth(), nativeScreen.getHeight(), nativeScreen.getOffsetX(), nativeScreen.getOffsetY(), nativeScreen.getWidth(), nativeScreen.getHeight(), nativeScreen.getDPI(), nativeScreen.getDPI(), 1.0f, 1.0f, nativeScreen.getScale(), nativeScreen.getScale());
            if (n == 0) {
                MouseState mouseState = new MouseState();
                mouseState.setX(nativeScreen.getWidth() / 2);
                mouseState.setY(nativeScreen.getHeight() / 2);
                MouseInput.getInstance().setState(mouseState, false);
            }
            ++n;
        }
        return screenArray;
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new MonocleTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return MonocleTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return MonocleTimer.getMaxPeriod_impl();
    }

    @Override
    public boolean hasWindowManager() {
        return false;
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        Thread.dumpStack();
        throw new UnsupportedOperationException();
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return MonocleView._getMultiClickTime();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return MonocleView._getMultiClickMaxX();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return MonocleView._getMultiClickMaxY();
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return true;
    }

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    public boolean hasTwoLevelFocus() {
        return this.deviceFlags[4] == 0 && this.deviceFlags[3] > 0;
    }

    @Override
    public boolean hasVirtualKeyboard() {
        return this.deviceFlags[4] == 0 && this.deviceFlags[0] > 0;
    }

    @Override
    public boolean hasTouch() {
        return this.deviceFlags[0] > 0;
    }

    @Override
    public boolean hasMultiTouch() {
        return this.deviceFlags[1] > 0;
    }

    @Override
    public boolean hasPointer() {
        return this.deviceFlags[2] > 0;
    }

    @Override
    public void notifyRenderingFinished() {
        MonocleApplication.invokeLater(this.renderEndNotifier);
    }

    @Override
    protected void finishTerminating() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
        MonocleApplication.setEventThread(null);
        this.platform.shutdown();
        super.finishTerminating();
    }

    void enterDnDEventLoop() {
        this._enterNestedEventLoop();
    }

    void leaveDndEventLoop() {
        this._leaveNestedEventLoop(null);
    }

    @Override
    protected int _getKeyCodeForChar(char c) {
        return KeyInput.getInstance().getKeyCodeForChar(c);
    }
}

