/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AssignPointIDTouchFilter;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.NearbyPointsTouchFilter;
import com.sun.glass.ui.monocle.SmallMoveTouchFilter;
import com.sun.glass.ui.monocle.TouchFilter;
import com.sun.glass.ui.monocle.TouchInput;
import com.sun.glass.ui.monocle.TouchState;
import java.util.ArrayList;

class TouchPipeline {
    private TouchInput touch = TouchInput.getInstance();
    private ArrayList<TouchFilter> filters = new ArrayList();
    private TouchState flushState = new TouchState();

    TouchPipeline() {
    }

    void add(TouchPipeline touchPipeline) {
        for (int i = 0; i < touchPipeline.filters.size(); ++i) {
            this.addFilter(touchPipeline.filters.get(i));
        }
    }

    void addNamedFilters(String string) {
        String[] stringArray = string.split(",");
        if (stringArray != null) {
            for (String string2 : stringArray) {
                String string3 = string2.trim();
                if (string3.length() <= 0) continue;
                this.addNamedFilter(string3);
            }
        }
    }

    void addNamedFilter(String object) {
        try {
            if (((String)object).equals("SmallMove")) {
                this.addFilter(new SmallMoveTouchFilter());
            } else if (((String)object).equals("NearbyPoints")) {
                this.addFilter(new NearbyPointsTouchFilter());
            } else if (((String)object).equals("AssignPointID")) {
                this.addFilter(new AssignPointIDTouchFilter());
            } else {
                if (!((String)object).contains(".")) {
                    object = "com.sun.glass.ui.monocle." + (String)object + "TouchFilter";
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                this.addFilter((TouchFilter)classLoader.loadClass((String)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot install touch filter '" + (String)object + "'");
            exception.printStackTrace();
        }
    }

    void addFilter(TouchFilter touchFilter) {
        int n;
        int n2 = touchFilter.getPriority();
        for (n = 0; n < this.filters.size(); ++n) {
            if (this.filters.get(n).equals(touchFilter)) {
                return;
            }
            if (this.filters.get(n).getPriority() < n2) break;
        }
        this.filters.add(n, touchFilter);
    }

    boolean filter(TouchState touchState) {
        for (int i = 0; i < this.filters.size(); ++i) {
            TouchFilter touchFilter = this.filters.get(i);
            if (MonocleSettings.settings.traceEventsVerbose) {
                MonocleTrace.traceEvent("Applying %s to %s", touchFilter, touchState);
            }
            if (!touchFilter.filter(touchState)) continue;
            return true;
        }
        return false;
    }

    void pushState(TouchState touchState) {
        if (MonocleSettings.settings.traceEventsVerbose) {
            MonocleTrace.traceEvent("Pushing %s to %s", touchState, this);
        }
        if (!this.filter(touchState)) {
            this.touch.setState(touchState);
        }
    }

    void flush() {
        for (int i = 0; i < this.filters.size(); ++i) {
            TouchFilter touchFilter = this.filters.get(i);
            while (touchFilter.flush(this.flushState)) {
                if (MonocleSettings.settings.traceEventsVerbose) {
                    MonocleTrace.traceEvent("Flushing %s from %s", this.flushState, touchFilter);
                }
                boolean bl = false;
                for (int j = i + 1; j < this.filters.size() && !bl; ++j) {
                    bl = this.filters.get(j).filter(this.flushState);
                }
                if (bl) continue;
                this.touch.setState(this.flushState);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TouchPipeline[");
        for (int i = 0; i < this.filters.size(); ++i) {
            stringBuffer.append(this.filters.get(i));
            if (i >= this.filters.size() - 1) continue;
            stringBuffer.append(" -> ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

