/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AndroidInputDevice;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.TouchInput;
import com.sun.glass.ui.monocle.TouchPipeline;
import com.sun.glass.ui.monocle.TouchState;
import javafx.application.Platform;

class AndroidInputProcessor {
    private final AndroidInputDevice device;
    final TouchPipeline touchPipeline;
    private final KeyInput keyInput = new KeyInput();

    AndroidInputProcessor(AndroidInputDevice androidInputDevice) {
        this.device = androidInputDevice;
        this.touchPipeline = new TouchPipeline();
        this.touchPipeline.add(TouchInput.getInstance().getBasePipeline());
    }

    void pushEvent(TouchState touchState) {
        this.touchPipeline.pushState(touchState);
    }

    void processEvents(AndroidInputDevice androidInputDevice) {
        this.touchPipeline.pushState(null);
    }

    synchronized void pushKeyEvent(KeyState keyState) {
        this.keyInput.setState(keyState);
    }

    synchronized void dispatchKeyEvent(int n, int n2, char[] cArray, int n3) {
        Platform.runLater(() -> {
            MonocleWindow monocleWindow = MonocleWindowManager.getInstance().getFocusedWindow();
            if (monocleWindow == null) {
                return;
            }
            MonocleView monocleView = (MonocleView)monocleWindow.getView();
            if (monocleView == null) {
                return;
            }
            RunnableProcessor.runLater(() -> monocleView.notifyKey(n, n2, cArray, n3));
        });
    }
}

