/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AcceleratedScreen;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.NativeScreen;

public class EGLAcceleratedScreen
extends AcceleratedScreen {
    private long eglWindowHandle = this.platformGetNativeWindow();

    EGLAcceleratedScreen(int[] nArray) throws GLException {
        this.eglDisplay = this.nGetEglDisplayHandle();
        this.nEglInitialize(this.eglDisplay);
        this.nEglBindApi(12448);
        long l = this.nEglChooseConfig(this.eglDisplay, nArray);
        if (l == -1L) {
            throw new IllegalArgumentException("Could not create an EGLChooseConfig");
        }
        this.eglSurface = this.nEglCreateWindowSurface(this.eglDisplay, l, this.eglWindowHandle);
        this.eglContext = this.nEglCreateContext(this.eglDisplay, l);
    }

    @Override
    protected long platformGetNativeWindow() {
        String string = System.getProperty("egl.displayid", "/dev/dri/card1");
        return this.nPlatformGetNativeWindow(string);
    }

    @Override
    public void enableRendering(boolean bl) {
        if (bl) {
            this.nEglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext);
        } else {
            this.nEglMakeCurrent(this.eglDisplay, 0L, 0L, this.eglContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean swapBuffers() {
        boolean bl = false;
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            bl = this.nEglSwapBuffers(this.eglDisplay, this.eglSurface);
        }
        return bl;
    }

    private native long nPlatformGetNativeWindow(String var1);

    private native long nGetEglDisplayHandle();

    private native boolean nEglInitialize(long var1);

    private native boolean nEglBindApi(int var1);

    private native long nEglChooseConfig(long var1, int[] var3);

    private native boolean nEglMakeCurrent(long var1, long var3, long var5, long var7);

    private native long nEglCreateWindowSurface(long var1, long var3, long var5);

    private native long nEglCreateContext(long var1, long var3);

    private native boolean nEglSwapBuffers(long var1, long var3);
}

