/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.C;
import com.sun.glass.ui.monocle.EPDSettings;
import com.sun.glass.ui.monocle.EPDSystem;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;

class EPDFrameBuffer {
    private static final int BITS_TO_BYTES = 3;
    private static final int POWERDOWN_DELAY = 1000;
    private static final int ENOTTY = 25;
    private final PlatformLogger logger = Logging.getJavaFXLogger();
    private final EPDSettings settings = EPDSettings.newInstance();
    private final LinuxSystem system = LinuxSystem.getLinuxSystem();
    private final EPDSystem driver = EPDSystem.getEPDSystem();
    private final long fd;
    private final int xres;
    private final int yres;
    private final int xresVirtual;
    private final int yresVirtual;
    private final int xoffset;
    private final int yoffset;
    private final int bitsPerPixel;
    private final int bytesPerPixel;
    private final int byteOffset;
    private final EPDSystem.MxcfbUpdateData updateData;
    private final EPDSystem.MxcfbUpdateData syncUpdate;
    private int updateMarker;
    private int lastMarker;

    EPDFrameBuffer(String string) throws IOException {
        this.fd = this.system.open(string, 2);
        if (this.fd == -1L) {
            throw new IOException(this.system.getErrorMessage());
        }
        EPDSystem.FbVarScreenInfo fbVarScreenInfo = new EPDSystem.FbVarScreenInfo();
        this.getScreenInfo(fbVarScreenInfo);
        fbVarScreenInfo.setBitsPerPixel(fbVarScreenInfo.p, this.settings.bitsPerPixel);
        fbVarScreenInfo.setGrayscale(fbVarScreenInfo.p, this.settings.grayscale);
        switch (this.settings.bitsPerPixel) {
            case 8: {
                fbVarScreenInfo.setRed(fbVarScreenInfo.p, 0, 0);
                fbVarScreenInfo.setGreen(fbVarScreenInfo.p, 0, 0);
                fbVarScreenInfo.setBlue(fbVarScreenInfo.p, 0, 0);
                fbVarScreenInfo.setTransp(fbVarScreenInfo.p, 0, 0);
                break;
            }
            case 16: {
                fbVarScreenInfo.setRed(fbVarScreenInfo.p, 5, 11);
                fbVarScreenInfo.setGreen(fbVarScreenInfo.p, 6, 5);
                fbVarScreenInfo.setBlue(fbVarScreenInfo.p, 5, 0);
                fbVarScreenInfo.setTransp(fbVarScreenInfo.p, 0, 0);
                break;
            }
            case 32: {
                fbVarScreenInfo.setRed(fbVarScreenInfo.p, 8, 16);
                fbVarScreenInfo.setGreen(fbVarScreenInfo.p, 8, 8);
                fbVarScreenInfo.setBlue(fbVarScreenInfo.p, 8, 0);
                fbVarScreenInfo.setTransp(fbVarScreenInfo.p, 8, 24);
                break;
            }
            default: {
                String string2 = MessageFormat.format("Unsupported color depth: {0} bpp", this.settings.bitsPerPixel);
                this.logger.severe(string2);
                throw new IllegalArgumentException(string2);
            }
        }
        fbVarScreenInfo.setActivate(fbVarScreenInfo.p, 128);
        fbVarScreenInfo.setRotate(fbVarScreenInfo.p, this.settings.rotate);
        this.setScreenInfo(fbVarScreenInfo);
        this.getScreenInfo(fbVarScreenInfo);
        this.logScreenInfo(fbVarScreenInfo);
        this.xres = fbVarScreenInfo.getXRes(fbVarScreenInfo.p);
        this.yres = fbVarScreenInfo.getYRes(fbVarScreenInfo.p);
        this.xresVirtual = fbVarScreenInfo.getXResVirtual(fbVarScreenInfo.p);
        this.yresVirtual = fbVarScreenInfo.getYResVirtual(fbVarScreenInfo.p);
        this.xoffset = fbVarScreenInfo.getOffsetX(fbVarScreenInfo.p);
        this.yoffset = fbVarScreenInfo.getOffsetY(fbVarScreenInfo.p);
        this.bitsPerPixel = fbVarScreenInfo.getBitsPerPixel(fbVarScreenInfo.p);
        this.bytesPerPixel = this.bitsPerPixel >>> 3;
        this.byteOffset = (this.xoffset + this.yoffset * this.xresVirtual) * this.bytesPerPixel;
        this.updateData = new EPDSystem.MxcfbUpdateData();
        this.syncUpdate = this.createDefaultUpdate(this.xres, this.yres);
    }

    private void getScreenInfo(EPDSystem.FbVarScreenInfo fbVarScreenInfo) throws IOException {
        int n = this.system.ioctl(this.fd, 17920, fbVarScreenInfo.p);
        if (n != 0) {
            this.system.close(this.fd);
            throw new IOException(this.system.getErrorMessage());
        }
    }

    private void setScreenInfo(EPDSystem.FbVarScreenInfo fbVarScreenInfo) throws IOException {
        int n = this.system.ioctl(this.fd, 17921, fbVarScreenInfo.p);
        if (n != 0) {
            this.system.close(this.fd);
            throw new IOException(this.system.getErrorMessage());
        }
    }

    private void logScreenInfo(EPDSystem.FbVarScreenInfo fbVarScreenInfo) {
        if (this.logger.isLoggable(PlatformLogger.Level.FINE)) {
            this.logger.fine("Frame buffer geometry: {0} {1} {2} {3} {4}", new Object[]{fbVarScreenInfo.getXRes(fbVarScreenInfo.p), fbVarScreenInfo.getYRes(fbVarScreenInfo.p), fbVarScreenInfo.getXResVirtual(fbVarScreenInfo.p), fbVarScreenInfo.getYResVirtual(fbVarScreenInfo.p), fbVarScreenInfo.getBitsPerPixel(fbVarScreenInfo.p)});
            this.logger.fine("Frame buffer rgba: {0}/{1},{2}/{3},{4}/{5},{6}/{7}", new Object[]{fbVarScreenInfo.getRedLength(fbVarScreenInfo.p), fbVarScreenInfo.getRedOffset(fbVarScreenInfo.p), fbVarScreenInfo.getGreenLength(fbVarScreenInfo.p), fbVarScreenInfo.getGreenOffset(fbVarScreenInfo.p), fbVarScreenInfo.getBlueLength(fbVarScreenInfo.p), fbVarScreenInfo.getBlueOffset(fbVarScreenInfo.p), fbVarScreenInfo.getTranspLength(fbVarScreenInfo.p), fbVarScreenInfo.getTranspOffset(fbVarScreenInfo.p)});
            this.logger.fine("Frame buffer grayscale: {0}", new Object[]{fbVarScreenInfo.getGrayscale(fbVarScreenInfo.p)});
        }
    }

    private EPDSystem.MxcfbUpdateData createDefaultUpdate(int n, int n2) {
        EPDSystem.MxcfbUpdateData mxcfbUpdateData = new EPDSystem.MxcfbUpdateData();
        mxcfbUpdateData.setUpdateRegion(mxcfbUpdateData.p, 0, 0, n, n2);
        mxcfbUpdateData.setWaveformMode(mxcfbUpdateData.p, this.settings.waveformMode);
        mxcfbUpdateData.setUpdateMode(mxcfbUpdateData.p, 0);
        mxcfbUpdateData.setTemp(mxcfbUpdateData.p, 4096);
        mxcfbUpdateData.setFlags(mxcfbUpdateData.p, this.settings.flags);
        return mxcfbUpdateData;
    }

    private void setWaveformModes(int n, int n2, int n3, int n4, int n5, int n6) {
        EPDSystem.MxcfbWaveformModes mxcfbWaveformModes = new EPDSystem.MxcfbWaveformModes();
        mxcfbWaveformModes.setModes(mxcfbWaveformModes.p, n, n2, n3, n4, n5, n6);
        int n7 = this.system.ioctl(this.fd, this.driver.MXCFB_SET_WAVEFORM_MODES, mxcfbWaveformModes.p);
        if (n7 != 0 && this.system.errno() != 25) {
            this.logger.severe("Failed setting waveform modes: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno()});
        }
    }

    private void setTemperature(int n) {
        int n2 = this.driver.ioctl(this.fd, this.driver.MXCFB_SET_TEMPERATURE, n);
        if (n2 != 0) {
            this.logger.severe("Failed setting temperature to {2} degrees Celsius: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), n});
        }
    }

    private void setAutoUpdateMode(int n) {
        int n2 = this.driver.ioctl(this.fd, this.driver.MXCFB_SET_AUTO_UPDATE_MODE, n);
        if (n2 != 0) {
            this.logger.severe("Failed setting auto-update mode to {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), n});
        }
    }

    private int sendUpdate(int n, int n2, int n3) {
        this.updateData.setUpdateRegion(this.updateData.p, 0, 0, this.xres, this.yres);
        this.updateData.setUpdateMode(this.updateData.p, n);
        this.updateData.setTemp(this.updateData.p, 4096);
        this.updateData.setFlags(this.updateData.p, n3);
        return this.sendUpdate(this.updateData, n2);
    }

    private int sendUpdate(EPDSystem.MxcfbUpdateData mxcfbUpdateData, int n) {
        ++this.updateMarker;
        if (this.updateMarker == 0) {
            ++this.updateMarker;
        }
        mxcfbUpdateData.setWaveformMode(mxcfbUpdateData.p, n);
        mxcfbUpdateData.setUpdateMarker(mxcfbUpdateData.p, this.updateMarker);
        int n2 = this.system.ioctl(this.fd, this.driver.MXCFB_SEND_UPDATE, mxcfbUpdateData.p);
        if (n2 != 0) {
            this.logger.severe("Failed sending update {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), Integer.toUnsignedLong(this.updateMarker)});
        } else if (this.logger.isLoggable(PlatformLogger.Level.FINER)) {
            this.logger.finer("Sent update: {0} x {1}, waveform {2}, selected {3}, flags 0x{4}, marker {5}", new Object[]{mxcfbUpdateData.getUpdateRegionWidth(mxcfbUpdateData.p), mxcfbUpdateData.getUpdateRegionHeight(mxcfbUpdateData.p), n, mxcfbUpdateData.getWaveformMode(mxcfbUpdateData.p), Integer.toHexString(mxcfbUpdateData.getFlags(mxcfbUpdateData.p)).toUpperCase(), Integer.toUnsignedLong(this.updateMarker)});
        }
        return this.updateMarker;
    }

    private void waitForUpdateComplete(int n) {
        int n2 = this.driver.ioctl(this.fd, this.driver.MXCFB_WAIT_FOR_UPDATE_COMPLETE, n);
        if (n2 < 0) {
            this.logger.severe("Failed waiting for update {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), Integer.toUnsignedLong(n)});
        } else if (n2 == 0 && this.logger.isLoggable(PlatformLogger.Level.FINER)) {
            this.logger.finer("Update completed before wait: marker {0}", new Object[]{Integer.toUnsignedLong(n)});
        }
    }

    private void setPowerdownDelay(int n) {
        int n2 = this.driver.ioctl(this.fd, this.driver.MXCFB_SET_PWRDOWN_DELAY, n);
        if (n2 != 0) {
            this.logger.severe("Failed setting power-down delay to {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), n});
        }
    }

    private int getPowerdownDelay() {
        EPDSystem.IntStructure intStructure = new EPDSystem.IntStructure();
        int n = this.system.ioctl(this.fd, this.driver.MXCFB_GET_PWRDOWN_DELAY, intStructure.p);
        if (n != 0) {
            this.logger.severe("Failed getting power-down delay: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno()});
        }
        return intStructure.get(intStructure.p);
    }

    private void setUpdateScheme(int n) {
        int n2 = this.driver.ioctl(this.fd, this.driver.MXCFB_SET_UPDATE_SCHEME, n);
        if (n2 != 0) {
            this.logger.severe("Failed setting update scheme to {2}: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), n});
        }
    }

    void init() {
        this.setWaveformModes(0, 1, 3, 2, 2, 2);
        this.setTemperature(4096);
        this.setAutoUpdateMode(0);
        this.setPowerdownDelay(1000);
        this.setUpdateScheme(0);
    }

    void clear() {
        this.lastMarker = this.sendUpdate(1, 1, 0);
        this.lastMarker = this.sendUpdate(1, 1, 1);
        this.waitForUpdateComplete(this.lastMarker);
    }

    void sync() {
        if (!this.settings.noWait) {
            this.waitForUpdateComplete(this.lastMarker);
        }
        this.lastMarker = this.sendUpdate(this.syncUpdate, this.settings.waveformMode);
    }

    int getByteOffset() {
        return this.byteOffset;
    }

    ByteBuffer getOffscreenBuffer() {
        int n = this.xresVirtual * this.yres * 4;
        return ByteBuffer.allocateDirect(n);
    }

    ByteBuffer getMappedBuffer() {
        ByteBuffer byteBuffer = null;
        int n = this.xresVirtual * this.yres * this.bytesPerPixel;
        this.logger.fine("Mapping frame buffer: {0} bytes", new Object[]{n});
        long l = this.system.mmap(0L, n, 2L, 1L, this.fd, 0L);
        if (l == 0xFFFFFFFFL) {
            this.logger.severe("Failed mapping {2} bytes of frame buffer: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), n});
        } else {
            byteBuffer = C.getC().NewDirectByteBuffer(l, n);
        }
        return byteBuffer;
    }

    void releaseMappedBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.capacity();
        this.logger.fine("Unmapping frame buffer: {0} bytes", new Object[]{n});
        int n2 = this.system.munmap(C.getC().GetDirectBufferAddress(byteBuffer), n);
        if (n2 != 0) {
            this.logger.severe("Failed unmapping {2} bytes of frame buffer: {0} ({1})", new Object[]{this.system.getErrorMessage(), this.system.errno(), n});
        }
    }

    void close() {
        this.system.close(this.fd);
    }

    long getNativeHandle() {
        return this.fd;
    }

    int getWidth() {
        return this.settings.getWidthVisible ? this.xres : this.xresVirtual;
    }

    int getHeight() {
        return this.yres;
    }

    int getBitDepth() {
        return this.bitsPerPixel;
    }

    public String toString() {
        return MessageFormat.format("{0}[width={1} height={2} bitDepth={3}]", this.getClass().getName(), this.getWidth(), this.getHeight(), this.getBitDepth());
    }
}

