/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxInputProcessor;
import com.sun.glass.ui.monocle.LinuxKeyProcessor;
import com.sun.glass.ui.monocle.LinuxSimpleTouchProcessor;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.ui.monocle.SysFS;
import com.sun.glass.ui.monocle.Udev;
import com.sun.glass.ui.monocle.UdevListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

class EPDInputDeviceRegistry
extends InputDeviceRegistry {
    private static final String KEYPAD_FILENAME = "event0";
    private static final String TOUCH_FILENAME = "event1";

    EPDInputDeviceRegistry(boolean bl) {
        if (bl) {
            return;
        }
        HashMap hashMap = new HashMap();
        UdevListener udevListener = (string, map2) -> {
            String string2 = (String)map2.get("SUBSYSTEM");
            String string3 = (String)map2.get("DEVPATH");
            String string4 = (String)map2.get("DEVNAME");
            if (string2 != null && string2.equals("input") && string3 != null && string4 != null) {
                try {
                    File file = new File("/sys", string3);
                    if (string.equals("add") || string.equals("change") && !hashMap.containsKey(file)) {
                        File file2 = new File(string4);
                        LinuxInputDevice linuxInputDevice = this.createDevice(file2, file, map2);
                        if (linuxInputDevice != null) {
                            hashMap.put(file, linuxInputDevice);
                        }
                    } else if (string.equals("remove")) {
                        LinuxInputDevice linuxInputDevice = (LinuxInputDevice)hashMap.get(file);
                        hashMap.remove(file);
                        if (linuxInputDevice != null) {
                            this.devices.remove((Object)linuxInputDevice);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        Udev.getInstance().addListener(udevListener);
        SysFS.triggerUdevNotification("input");
    }

    private LinuxInputDevice createDevice(File file, File file2, Map<String, String> map) throws IOException {
        LinuxSystem linuxSystem = LinuxSystem.getLinuxSystem();
        linuxSystem.open(file.getPath(), 0);
        LinuxInputDevice linuxInputDevice = new LinuxInputDevice(file, file2, map);
        return this.addDeviceInternal(linuxInputDevice, "Linux input: " + file.toString());
    }

    private LinuxInputDevice addDeviceInternal(LinuxInputDevice linuxInputDevice, String string) {
        LinuxInputProcessor linuxInputProcessor = null;
        if (string.endsWith(KEYPAD_FILENAME)) {
            linuxInputProcessor = new LinuxKeyProcessor();
        } else if (string.endsWith(TOUCH_FILENAME)) {
            linuxInputProcessor = new LinuxSimpleTouchProcessor(linuxInputDevice);
        }
        if (linuxInputProcessor == null) {
            return null;
        }
        linuxInputDevice.setInputProcessor(linuxInputProcessor);
        Thread thread = new Thread(linuxInputDevice);
        thread.setName(string);
        thread.setDaemon(true);
        thread.start();
        this.devices.add((Object)linuxInputDevice);
        return linuxInputDevice;
    }

    public String toString() {
        return MessageFormat.format("{0}[devices={1}]", this.getClass().getName(), this.devices);
    }
}

