/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.EPDPlatform;
import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.text.MessageFormat;

class EPDPlatformFactory
extends NativePlatformFactory {
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private static final String FB_FILE = "/proc/fb";
    private static final String FB_NAME = "mxc_epdc_fb";
    private final PlatformLogger logger = Logging.getJavaFXLogger();

    EPDPlatformFactory() {
    }

    @Override
    protected boolean matches() {
        String string = AccessController.doPrivileged(() -> {
            String string = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(FB_FILE));){
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                this.logger.severe("Failed reading /proc/fb", (Throwable)iOException);
            }
            return string;
        });
        return string != null && string.contains(FB_NAME);
    }

    @Override
    protected NativePlatform createNativePlatform() {
        return new EPDPlatform();
    }

    @Override
    protected int getMajorVersion() {
        return 1;
    }

    @Override
    protected int getMinorVersion() {
        return 0;
    }

    public String toString() {
        return MessageFormat.format("{0}[majorVersion={1} minorVersion={2} matches=\"{3} in {4}\"]", this.getClass().getName(), this.getMajorVersion(), this.getMinorVersion(), FB_NAME, FB_FILE);
    }
}

