/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.EPDFrameBuffer;
import com.sun.glass.ui.monocle.Framebuffer;
import com.sun.glass.ui.monocle.FramebufferY8;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.text.MessageFormat;

class EPDScreen
implements NativeScreen {
    private static final String FB_PATH_KEY = "monocle.screen.fb";
    private static final String FB_PATH_DEFAULT = "/dev/fb0";
    private static final int DPI = 167;
    private static final float SCALE = 1.0f;
    private final PlatformLogger logger = Logging.getJavaFXLogger();
    private final String fbPath;
    private final EPDFrameBuffer fbDevice;
    private final ByteBuffer fbMapping;
    private final FileChannel fbChannel;
    private final Framebuffer pixels;
    private final int width;
    private final int height;
    private final int bitDepth;
    private boolean isShutdown;

    EPDScreen() {
        ByteBuffer byteBuffer;
        String string;
        this.fbPath = string = AccessController.doPrivileged(() -> System.getProperty(FB_PATH_KEY, FB_PATH_DEFAULT));
        try {
            this.fbDevice = new EPDFrameBuffer(this.fbPath);
            this.fbDevice.init();
            this.width = this.fbDevice.getWidth();
            this.height = this.fbDevice.getHeight();
            this.bitDepth = this.fbDevice.getBitDepth();
            this.logger.fine("Native screen geometry: {0} px x {1} px x {2} bpp", new Object[]{this.width, this.height, this.bitDepth});
            byteBuffer = null;
            if (this.bitDepth == 32) {
                byteBuffer = this.fbDevice.getMappedBuffer();
            }
            if (byteBuffer != null) {
                this.fbMapping = byteBuffer;
                this.fbChannel = null;
            } else {
                Path path = FileSystems.getDefault().getPath(this.fbPath, new String[0]);
                this.fbChannel = FileChannel.open(path, StandardOpenOption.WRITE);
                this.fbMapping = null;
            }
        }
        catch (IOException iOException) {
            String string2 = MessageFormat.format("Failed opening frame buffer: {0}", this.fbPath);
            this.logger.severe(string2, (Throwable)iOException);
            throw new IllegalStateException(string2, iOException);
        }
        byteBuffer = this.fbMapping != null ? this.fbMapping : this.fbDevice.getOffscreenBuffer();
        byteBuffer.order(ByteOrder.nativeOrder());
        this.pixels = new FramebufferY8(byteBuffer, this.width, this.height, this.bitDepth, true);
        this.clearScreen();
    }

    private void close() {
        try {
            if (this.fbChannel != null) {
                this.fbChannel.close();
            }
        }
        catch (IOException iOException) {
            this.logger.severe("Failed closing frame buffer channel", (Throwable)iOException);
        }
        finally {
            if (this.fbMapping != null) {
                this.fbDevice.releaseMappedBuffer(this.fbMapping);
            }
            this.fbDevice.close();
        }
    }

    private void writeBuffer() {
        if (this.fbChannel != null) {
            try {
                this.fbChannel.position(this.fbDevice.getByteOffset());
                this.pixels.write(this.fbChannel);
            }
            catch (IOException iOException) {
                this.logger.severe("Failed writing to frame buffer channel", (Throwable)iOException);
            }
        }
    }

    private void clearScreen() {
        this.pixels.clearBufferContents();
        this.writeBuffer();
        this.fbDevice.clear();
    }

    @Override
    public int getDepth() {
        return this.bitDepth;
    }

    @Override
    public int getNativeFormat() {
        return 1;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDPI() {
        return 167;
    }

    @Override
    public long getNativeHandle() {
        return this.fbDevice.getNativeHandle();
    }

    @Override
    public synchronized void shutdown() {
        this.close();
        this.isShutdown = true;
    }

    @Override
    public synchronized void uploadPixels(Buffer buffer, int n, int n2, int n3, int n4, float f) {
        this.pixels.composePixels(buffer, n, n2, n3, n4, f);
    }

    @Override
    public synchronized void swapBuffers() {
        if (!this.isShutdown && this.pixels.hasReceivedData()) {
            this.writeBuffer();
            this.fbDevice.sync();
            this.pixels.reset();
        }
    }

    @Override
    public synchronized ByteBuffer getScreenCapture() {
        return this.pixels.getBuffer().asReadOnlyBuffer();
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    public String toString() {
        return MessageFormat.format("{0}[width={1} height={2} depth={3} DPI={4} scale={5,number,0.0#}]", this.getClass().getName(), this.getWidth(), this.getHeight(), this.getDepth(), this.getDPI(), Float.valueOf(this.getScale()));
    }
}

