/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;

class EPDSettings {
    private static final String BITS_PER_PIXEL = "monocle.epd.bitsPerPixel";
    private static final String ROTATE = "monocle.epd.rotate";
    private static final String Y8_INVERTED = "monocle.epd.Y8Inverted";
    private static final String NO_WAIT = "monocle.epd.noWait";
    private static final String WAVEFORM_MODE = "monocle.epd.waveformMode";
    private static final String FLAG_ENABLE_INVERSION = "monocle.epd.enableInversion";
    private static final String FLAG_FORCE_MONOCHROME = "monocle.epd.forceMonochrome";
    private static final String FLAG_USE_DITHERING_Y1 = "monocle.epd.useDitheringY1";
    private static final String FLAG_USE_DITHERING_Y4 = "monocle.epd.useDitheringY4";
    private static final String FIX_WIDTH_Y8UR = "monocle.epd.fixWidthY8UR";
    private static final String[] EPD_PROPERTIES = new String[]{"monocle.epd.bitsPerPixel", "monocle.epd.rotate", "monocle.epd.Y8Inverted", "monocle.epd.noWait", "monocle.epd.waveformMode", "monocle.epd.enableInversion", "monocle.epd.forceMonochrome", "monocle.epd.useDitheringY1", "monocle.epd.useDitheringY4", "monocle.epd.fixWidthY8UR"};
    private static final int BITS_PER_PIXEL_DEFAULT = 32;
    private static final int ROTATE_DEFAULT = 0;
    private static final int WAVEFORM_MODE_DEFAULT = 257;
    private static final int[] BITS_PER_PIXEL_PERMITTED = new int[]{8, 16, 32};
    private static final int[] ROTATIONS_PERMITTED = new int[]{0, 1, 2, 3};
    private static final int[] WAVEFORM_MODES_PERMITTED = new int[]{1, 2, 3, 4, 257};
    private final PlatformLogger logger = Logging.getJavaFXLogger();
    private final boolean y8inverted;
    private final boolean flagEnableInversion;
    private final boolean flagForceMonochrome;
    private final boolean flagUseDitheringY1;
    private final boolean flagUseDitheringY4;
    private final boolean fixWidthY8UR;
    final int bitsPerPixel;
    final int rotate;
    final boolean noWait;
    final int waveformMode;
    final int grayscale;
    final int flags;
    final boolean getWidthVisible;

    static EPDSettings newInstance() {
        return AccessController.doPrivileged(() -> new EPDSettings());
    }

    private EPDSettings() {
        if (this.logger.isLoggable(PlatformLogger.Level.FINE)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : EPD_PROPERTIES) {
                String string2 = System.getProperty(string);
                if (string2 == null) continue;
                hashMap.put(string, string2);
            }
            this.logger.fine("EPD system properties: {0}", new Object[]{hashMap});
        }
        this.bitsPerPixel = this.getInteger(BITS_PER_PIXEL, 32, BITS_PER_PIXEL_PERMITTED);
        this.rotate = this.getInteger(ROTATE, 0, ROTATIONS_PERMITTED);
        this.noWait = Boolean.getBoolean(NO_WAIT);
        this.waveformMode = this.getInteger(WAVEFORM_MODE, 257, WAVEFORM_MODES_PERMITTED);
        this.y8inverted = Boolean.getBoolean(Y8_INVERTED);
        this.grayscale = this.bitsPerPixel == 8 ? (this.y8inverted ? 2 : 1) : 0;
        this.flagEnableInversion = Boolean.getBoolean(FLAG_ENABLE_INVERSION);
        this.flagForceMonochrome = Boolean.getBoolean(FLAG_FORCE_MONOCHROME);
        this.flagUseDitheringY1 = Boolean.getBoolean(FLAG_USE_DITHERING_Y1);
        this.flagUseDitheringY4 = Boolean.getBoolean(FLAG_USE_DITHERING_Y4);
        this.flags = (this.flagEnableInversion ? 1 : 0) | (this.flagForceMonochrome ? 2 : 0) | (this.flagUseDitheringY1 ? 8192 : 0) | (this.flagUseDitheringY4 ? 16384 : 0);
        this.fixWidthY8UR = Boolean.getBoolean(FIX_WIDTH_Y8UR);
        this.getWidthVisible = this.fixWidthY8UR && this.grayscale == 1 && this.rotate == 0;
    }

    private int getInteger(String string, int n, int ... nArray) {
        int n2 = Integer.getInteger(string, n);
        boolean bl = false;
        for (int i = 0; i < nArray.length && !bl; ++i) {
            bl = n2 == nArray[i];
        }
        if (!bl) {
            this.logger.severe("Value of {0}={1} not in {2}; using default ({3})", new Object[]{string, n2, Arrays.toString(nArray), n});
            n2 = n;
        }
        return n2;
    }

    public String toString() {
        return MessageFormat.format("{0}[bitsPerPixel={1} rotate={2} noWait={3} waveformMode={4} grayscale={5} flags=0x{6} getWidthVisible={7}]", this.getClass().getName(), this.bitsPerPixel, this.rotate, this.noWait, this.waveformMode, this.grayscale, Integer.toHexString(this.flags), this.getWidthVisible);
    }
}

