/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.Framebuffer;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.WritableByteChannel;
import java.text.MessageFormat;

class FramebufferY8
extends Framebuffer {
    private static final int BITS_TO_BYTES = 3;
    private final PlatformLogger logger = Logging.getJavaFXLogger();
    private final ByteBuffer bb;
    private final int width;
    private final int height;
    private final int bitDepth;
    private final int byteDepth;
    private ByteBuffer lineByteBuffer;
    private Buffer linePixelBuffer;

    FramebufferY8(ByteBuffer byteBuffer, int n, int n2, int n3, boolean bl) {
        super(byteBuffer, n, n2, n3, bl);
        this.bb = byteBuffer;
        this.width = n;
        this.height = n2;
        this.bitDepth = n3;
        this.byteDepth = n3 >>> 3;
        if (this.byteDepth != 4 && this.byteDepth != 2 && this.byteDepth != 1) {
            String string = MessageFormat.format("Unsupported color depth: {0} bpp", this.bitDepth);
            this.logger.severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    private void copyNextPixel(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        int n = intBuffer.get();
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = (int)(0.2126f * (float)n2 + 0.7152f * (float)n3 + 0.0722f * (float)n4);
        byteBuffer.put((byte)n5);
    }

    private void copyNextPixel(IntBuffer intBuffer, ShortBuffer shortBuffer) {
        int n = intBuffer.get();
        int n2 = n >> 8 & 0xF800;
        int n3 = n >> 5 & 0x7E0;
        int n4 = n >> 3 & 0x1F;
        int n5 = n2 | n3 | n4;
        shortBuffer.put((short)n5);
    }

    @Override
    void write(WritableByteChannel writableByteChannel) throws IOException {
        this.bb.clear();
        switch (this.byteDepth) {
            case 1: {
                if (this.lineByteBuffer == null) {
                    this.lineByteBuffer = ByteBuffer.allocate(this.width * 1);
                    this.lineByteBuffer.order(ByteOrder.nativeOrder());
                    this.linePixelBuffer = this.lineByteBuffer.duplicate();
                }
                IntBuffer intBuffer = this.bb.asIntBuffer();
                ByteBuffer byteBuffer = (ByteBuffer)this.linePixelBuffer;
                for (int i = 0; i < this.height; ++i) {
                    byteBuffer.clear();
                    for (int j = 0; j < this.width; ++j) {
                        this.copyNextPixel(intBuffer, byteBuffer);
                    }
                    this.lineByteBuffer.clear();
                    writableByteChannel.write(this.lineByteBuffer);
                }
                break;
            }
            case 2: {
                if (this.lineByteBuffer == null) {
                    this.lineByteBuffer = ByteBuffer.allocate(this.width * 2);
                    this.lineByteBuffer.order(ByteOrder.nativeOrder());
                    this.linePixelBuffer = this.lineByteBuffer.asShortBuffer();
                }
                IntBuffer intBuffer = this.bb.asIntBuffer();
                ShortBuffer shortBuffer = (ShortBuffer)this.linePixelBuffer;
                for (int i = 0; i < this.height; ++i) {
                    shortBuffer.clear();
                    for (int j = 0; j < this.width; ++j) {
                        this.copyNextPixel(intBuffer, shortBuffer);
                    }
                    this.lineByteBuffer.clear();
                    writableByteChannel.write(this.lineByteBuffer);
                }
                break;
            }
            case 4: {
                writableByteChannel.write(this.bb);
                break;
            }
            default: {
                String string = MessageFormat.format("byteDepth={0}", this.byteDepth);
                this.logger.severe(string);
                throw new IllegalStateException(string);
            }
        }
    }

    @Override
    void copyToBuffer(ByteBuffer byteBuffer) {
        this.bb.clear();
        switch (this.byteDepth) {
            case 1: {
                if (this.lineByteBuffer == null) {
                    this.lineByteBuffer = ByteBuffer.allocate(this.width * 1);
                    this.lineByteBuffer.order(ByteOrder.nativeOrder());
                    this.linePixelBuffer = this.lineByteBuffer.duplicate();
                }
                IntBuffer intBuffer = this.bb.asIntBuffer();
                ByteBuffer byteBuffer2 = (ByteBuffer)this.linePixelBuffer;
                for (int i = 0; i < this.height; ++i) {
                    byteBuffer2.clear();
                    for (int j = 0; j < this.width; ++j) {
                        this.copyNextPixel(intBuffer, byteBuffer2);
                    }
                    this.lineByteBuffer.clear();
                    byteBuffer.put(this.lineByteBuffer);
                }
                break;
            }
            case 2: {
                if (this.lineByteBuffer == null) {
                    this.lineByteBuffer = ByteBuffer.allocate(this.width * 2);
                    this.lineByteBuffer.order(ByteOrder.nativeOrder());
                    this.linePixelBuffer = this.lineByteBuffer.asShortBuffer();
                }
                IntBuffer intBuffer = this.bb.asIntBuffer();
                ShortBuffer shortBuffer = (ShortBuffer)this.linePixelBuffer;
                for (int i = 0; i < this.height; ++i) {
                    shortBuffer.clear();
                    for (int j = 0; j < this.width; ++j) {
                        this.copyNextPixel(intBuffer, shortBuffer);
                    }
                    this.lineByteBuffer.clear();
                    byteBuffer.put(this.lineByteBuffer);
                }
                break;
            }
            case 4: {
                byteBuffer.put(this.bb);
                break;
            }
            default: {
                String string = MessageFormat.format("byteDepth={0}", this.byteDepth);
                this.logger.severe(string);
                throw new IllegalStateException(string);
            }
        }
    }

    public String toString() {
        return MessageFormat.format("{0}[width={1} height={2} depth={3} bb={4}]", this.getClass().getName(), this.width, this.height, this.bitDepth, this.bb);
    }
}

