/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;

class MonocleRobot
extends GlassRobot {
    MonocleRobot() {
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void keyPress(KeyCode keyCode) {
        Application.checkEventThread();
        KeyState keyState = new KeyState();
        KeyInput.getInstance().getState(keyState);
        keyState.pressKey(keyCode.getCode());
        KeyInput.getInstance().setState(keyState);
    }

    @Override
    public void keyRelease(KeyCode keyCode) {
        Application.checkEventThread();
        KeyState keyState = new KeyState();
        KeyInput.getInstance().getState(keyState);
        keyState.releaseKey(keyCode.getCode());
        KeyInput.getInstance().setState(keyState);
    }

    @Override
    public void mouseMove(double d, double d2) {
        Application.checkEventThread();
        MouseState mouseState = new MouseState();
        MouseInput.getInstance().getState(mouseState);
        mouseState.setX((int)d);
        mouseState.setY((int)d2);
        MouseInput.getInstance().setState(mouseState, false);
    }

    private static MouseState convertToMouseState(boolean bl, MouseState mouseState, MouseButton ... mouseButtonArray) {
        block7: for (MouseButton mouseButton : mouseButtonArray) {
            switch (mouseButton) {
                case PRIMARY: {
                    if (bl) {
                        mouseState.pressButton(212);
                        continue block7;
                    }
                    mouseState.releaseButton(212);
                    continue block7;
                }
                case SECONDARY: {
                    if (bl) {
                        mouseState.pressButton(213);
                        continue block7;
                    }
                    mouseState.releaseButton(213);
                    continue block7;
                }
                case MIDDLE: {
                    if (bl) {
                        mouseState.pressButton(214);
                        continue block7;
                    }
                    mouseState.releaseButton(214);
                    continue block7;
                }
                case BACK: {
                    if (bl) {
                        mouseState.pressButton(215);
                        continue block7;
                    }
                    mouseState.releaseButton(215);
                    continue block7;
                }
                case FORWARD: {
                    if (bl) {
                        mouseState.pressButton(216);
                        continue block7;
                    }
                    mouseState.releaseButton(216);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("MouseButton: " + mouseButton + " not supported by Monocle Robot");
                }
            }
        }
        return mouseState;
    }

    @Override
    public void mousePress(MouseButton ... mouseButtonArray) {
        Application.checkEventThread();
        MouseState mouseState = new MouseState();
        MouseInput.getInstance().getState(mouseState);
        MouseInput.getInstance().setState(MonocleRobot.convertToMouseState(true, mouseState, mouseButtonArray), false);
    }

    @Override
    public void mouseRelease(MouseButton ... mouseButtonArray) {
        Application.checkEventThread();
        MouseState mouseState = new MouseState();
        MouseInput.getInstance().getState(mouseState);
        MouseInput.getInstance().setState(MonocleRobot.convertToMouseState(false, mouseState, mouseButtonArray), false);
    }

    @Override
    public void mouseWheel(int n) {
        Application.checkEventThread();
        MouseState mouseState = new MouseState();
        MouseInput mouseInput = MouseInput.getInstance();
        mouseInput.getState(mouseState);
        int n2 = n < 0 ? -1 : 1;
        for (int i = 0; i < Math.abs(n); ++i) {
            mouseState.setWheel(n2);
            mouseInput.setState(mouseState, false);
            mouseState.setWheel(0);
            mouseInput.setState(mouseState, false);
        }
    }

    @Override
    public double getMouseX() {
        Application.checkEventThread();
        MouseState mouseState = new MouseState();
        MouseInput.getInstance().getState(mouseState);
        return mouseState.getX();
    }

    @Override
    public double getMouseY() {
        Application.checkEventThread();
        MouseState mouseState = new MouseState();
        MouseInput.getInstance().getState(mouseState);
        return mouseState.getY();
    }

    @Override
    public Color getPixelColor(double d, double d2) {
        Application.checkEventThread();
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        int n = nativeScreen.getDepth() >>> 3;
        int n2 = nativeScreen.getWidth();
        int n3 = nativeScreen.getHeight();
        if (d < 0.0 || d > (double)n2 || d2 < 0.0 || d2 > (double)n3) {
            return GlassRobot.convertFromIntArgb(0);
        }
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            ByteBuffer byteBuffer = nativeScreen.getScreenCapture();
            if (n == 2) {
                ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                short s = shortBuffer.get((int)(d2 * (double)n2) + (int)d);
                int n4 = (s & 0xF800) >> 11 << 3;
                int n5 = (s & 0x7E0) >> 5 << 2;
                int n6 = (s & 0x1F) << 3;
                int n7 = 0xFF000000 | n4 << 16 | n5 << 8 | n6;
                return GlassRobot.convertFromIntArgb(n7);
            }
            if (n >= 4) {
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                return GlassRobot.convertFromIntArgb(intBuffer.get((int)(d2 * (double)n2) + (int)d));
            }
            throw new RuntimeException("Unknown bit depth: " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getScreenCapture(int n, int n2, int n3, int n4, int[] nArray, boolean bl) {
        Application.checkEventThread();
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        int n5 = nativeScreen.getWidth();
        int n6 = nativeScreen.getHeight();
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            IntBuffer intBuffer = nativeScreen.getScreenCapture().asIntBuffer();
            if (n == 0 && n2 == 0 && n3 == n5 && n4 == n6) {
                System.arraycopy(intBuffer.array(), 0, nArray, 0, intBuffer.array().length);
                return;
            }
            int n7 = Math.min(n2 + n4, n6);
            int n8 = Math.min(n + n3, n5);
            for (int i = n2; i < n7; ++i) {
                for (int j = n; j < n8; ++j) {
                    nArray[(i - n2) * (n8 - n) + (j - n)] = intBuffer.get(i * n5 + j);
                }
            }
        }
    }
}

