/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Timer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class MonocleTimer
extends Timer {
    private static final String THREAD_NAME = "Monocle Timer";
    private static ScheduledThreadPoolExecutor scheduler;
    private ScheduledFuture<?> task;

    MonocleTimer(Runnable runnable) {
        super(runnable);
    }

    static int getMinPeriod_impl() {
        return 0;
    }

    static int getMaxPeriod_impl() {
        return 1000000;
    }

    @Override
    protected long _start(Runnable runnable2, int n) {
        if (scheduler == null) {
            scheduler = new ScheduledThreadPoolExecutor(1, runnable -> {
                Thread thread = new Thread(runnable, THREAD_NAME);
                thread.setDaemon(true);
                return thread;
            });
        }
        this.task = scheduler.scheduleAtFixedRate(runnable2, 0L, n, TimeUnit.MILLISECONDS);
        return 1L;
    }

    @Override
    protected long _start(Runnable runnable) {
        throw new RuntimeException("vsync timer not supported");
    }

    @Override
    protected void _stop(long l) {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
    }

    @Override
    protected void _pause(long l) {
    }

    @Override
    protected void _resume(long l) {
    }
}

