/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.monocle.MonocleCursor;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;

final class MonocleWindow
extends Window {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_MINIMIZED = 1;
    private static final int STATE_MAXIMIZED = 2;
    private static final int STATE_FULLSCREEN = 3;
    private int id;
    private int state;
    private int cachedX;
    private int cachedY;
    private int cachedW;
    private int cachedH;
    private int minW;
    private int minH;
    private int maxW = -1;
    private int maxH = -1;
    private float cachedAlpha = 1.0f;

    MonocleWindow(Window window, Screen screen, int n) {
        super(window, screen, n);
    }

    @Override
    protected void _toFront(long l) {
        MonocleWindowManager.getInstance().toFront(this);
    }

    @Override
    protected void _toBack(long l) {
        MonocleWindowManager.getInstance().toBack(this);
    }

    @Override
    protected void _setBounds(long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float f, float f2) {
        int n7 = n3 > 0 ? n3 : (n5 > 0 ? n5 : this.getWidth());
        int n8 = n4 > 0 ? n4 : (n6 > 0 ? n6 : this.getHeight());
        if (!bl) {
            n = this.getX();
        }
        if (!bl2) {
            n2 = this.getY();
        }
        if (this.maxW >= 0) {
            n7 = Math.min(n7, this.maxW);
        }
        if (this.maxH >= 0) {
            n8 = Math.min(n8, this.maxH);
        }
        n7 = Math.max(n7, this.minW);
        n8 = Math.max(n8, this.minH);
        this.notifyResizeAndMove(n, n2, n7, n8);
    }

    private void notifyResizeAndMove(int n, int n2, int n3, int n4) {
        MonocleView monocleView = (MonocleView)this.getView();
        boolean bl = false;
        if (this.getWidth() != n3 || this.getHeight() != n4) {
            this.notifyResize(511, n3, n4);
            if (monocleView != null) {
                monocleView.notifyResize(n3, n4);
                bl = true;
            }
        }
        if (this.getX() != n || this.getY() != n2) {
            this.notifyMove(n, n2);
            if (monocleView != null) {
                bl = true;
            }
        }
        if (bl) {
            monocleView.notifyRepaint();
        }
    }

    @Override
    protected long _createWindow(long l, long l2, int n) {
        this.id = MonocleWindowManager.getInstance().addWindow(this);
        return this.id;
    }

    @Override
    protected boolean _close(long l) {
        return MonocleWindowManager.getInstance().closeWindow(this);
    }

    @Override
    protected boolean _setView(long l, View view) {
        boolean bl = true;
        if (view != null) {
            ((MonocleView)view).notifyResize(this.getWidth(), this.getHeight());
        }
        return bl;
    }

    @Override
    public long getNativeWindow() {
        return this.id;
    }

    @Override
    protected boolean _setMenubar(long l, long l2) {
        return true;
    }

    @Override
    protected boolean _minimize(long l, boolean bl) {
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (bl && this.state != 1) {
            this.state = 1;
            this.cachedX = n;
            this.cachedY = n2;
            this.cachedW = n3;
            this.cachedH = n4;
            MonocleWindow.remove(this);
            this.notifyResize(531, n3, n4);
        } else if (!bl && this.state == 1) {
            this.state = 0;
            n = this.cachedX;
            n2 = this.cachedY;
            n3 = this.cachedW;
            n4 = this.cachedH;
            MonocleWindow.add(this);
            this.notifyResize(533, n3, n4);
        }
        return true;
    }

    @Override
    protected boolean _maximize(long l, boolean bl, boolean bl2) {
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (bl && !bl2) {
            if (this.state == 0) {
                this.cachedX = n;
                this.cachedY = n2;
                this.cachedW = n3;
                this.cachedH = n4;
            }
            if (this.maxW >= 0) {
                n3 = this.maxW;
                n = Math.min(n, nativeScreen.getWidth() - n3);
            } else {
                n = 0;
                n3 = nativeScreen.getWidth();
            }
            if (this.maxH >= 0) {
                n4 = this.maxH;
                n2 = Math.min(n2, nativeScreen.getHeight() - n4);
            } else {
                n2 = 0;
                n4 = nativeScreen.getHeight();
            }
            this.state = 2;
        } else if (!bl && bl2) {
            n = this.cachedX;
            n2 = this.cachedY;
            n3 = this.cachedW;
            n4 = this.cachedH;
            this.state = 0;
        }
        this.notifyResizeAndMove(n, n2, n3, n4);
        return true;
    }

    @Override
    protected void notifyMoveToAnotherScreen(Screen screen) {
        super.notifyMoveToAnotherScreen(screen);
    }

    void setFullScreen(boolean bl) {
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (bl) {
            if (this.state == 0) {
                this.cachedX = n;
                this.cachedY = n2;
                this.cachedW = n3;
                this.cachedH = n4;
            }
            n = 0;
            n2 = 0;
            n3 = nativeScreen.getWidth();
            n4 = nativeScreen.getHeight();
            MonocleView monocleView = (MonocleView)this.getView();
            if (monocleView != null) {
                monocleView.notifyView(431);
            }
            this.state = 3;
        } else {
            n = this.cachedX;
            n2 = this.cachedY;
            n3 = this.cachedW;
            n4 = this.cachedH;
            MonocleView monocleView = (MonocleView)this.getView();
            if (monocleView != null) {
                monocleView.notifyView(432);
            }
            this.state = 0;
        }
        this.notifyResizeAndMove(n, n2, n3, n4);
    }

    @Override
    protected boolean _setVisible(long l, boolean bl) {
        if (bl) {
            this.setAlpha(this.cachedAlpha);
        } else {
            this.cachedAlpha = this.getAlpha();
            this.setAlpha(0.0f);
        }
        return true;
    }

    @Override
    protected boolean _setResizable(long l, boolean bl) {
        return true;
    }

    @Override
    protected boolean _requestFocus(long l, int n) {
        return MonocleWindowManager.getInstance().requestFocus(this);
    }

    @Override
    protected void _setFocusable(long l, boolean bl) {
    }

    @Override
    protected boolean _setTitle(long l, String string) {
        return true;
    }

    @Override
    protected void _setLevel(long l, int n) {
    }

    @Override
    protected void _setAlpha(long l, float f) {
    }

    @Override
    protected boolean _setBackground(long l, float f, float f2, float f3) {
        return true;
    }

    @Override
    protected void _setEnabled(long l, boolean bl) {
        if (!bl && this == MonocleWindowManager.getInstance().getFocusedWindow()) {
            MonocleView monocleView = (MonocleView)this.getView();
            try {
                monocleView.notifyMouse(226, 211, 0, 0, 0, 0, 0, false, false);
            }
            catch (RuntimeException runtimeException) {
                Application.reportException(runtimeException);
            }
        }
    }

    @Override
    protected boolean _setMinimumSize(long l, int n, int n2) {
        this.minW = n;
        this.minH = n2;
        return true;
    }

    @Override
    protected boolean _setMaximumSize(long l, int n, int n2) {
        this.maxW = n;
        this.maxH = n2;
        return true;
    }

    @Override
    protected void _setIcon(long l, Pixels pixels) {
    }

    @Override
    protected boolean _grabFocus(long l) {
        return MonocleWindowManager.getInstance().grabFocus(this);
    }

    @Override
    protected void _ungrabFocus(long l) {
        MonocleWindowManager.getInstance().ungrabFocus(this);
    }

    @Override
    protected void _enterModal(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void _enterModalWithWindow(long l, long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void _exitModal(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void notifyClose() {
        super.notifyClose();
        this.close();
    }

    @Override
    protected void notifyDestroy() {
        super.notifyDestroy();
        MonocleWindowManager.getInstance().repaintAll();
    }

    @Override
    protected void notifyFocus(int n) {
        super.notifyFocus(n);
    }

    protected void _notifyFocusUngrab() {
        this.notifyFocusUngrab();
    }

    void _notifyFocusDisabled() {
        this.notifyFocusDisabled();
    }

    @Override
    protected void _setCursor(long l, Cursor cursor) {
        ((MonocleCursor)cursor).applyCursor();
    }

    @Override
    protected void _requestInput(long l, String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void _releaseInput(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

