/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AcceleratedScreen;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.X;
import com.sun.glass.ui.monocle.X11WarpingCursor;
import java.security.AccessController;

class X11AcceleratedScreen
extends AcceleratedScreen {
    private static X xLib = X.getX();
    private X.XDisplay nativeDisplay;

    X11AcceleratedScreen(int[] nArray) throws GLException {
        super(nArray);
    }

    @Override
    protected long platformGetNativeDisplay() {
        if (this.nativeDisplay == null) {
            boolean bl = AccessController.doPrivileged(() -> Boolean.getBoolean("monocle.maliSignedStruct"));
            X.XDisplay xDisplay = new X.XDisplay(xLib.XOpenDisplay(null));
            if (bl) {
                long l = 0x7000000L;
                this.nativeDisplay = new X.XDisplay(ls.mmap(l, xDisplay.sizeof(), 3L, 34L, -1L, 0L));
                ls.memcpy(this.nativeDisplay.p, xDisplay.p, xDisplay.sizeof());
            } else {
                this.nativeDisplay = xDisplay;
            }
        }
        return this.nativeDisplay.p;
    }

    @Override
    protected long platformGetNativeWindow() {
        return NativePlatformFactory.getNativePlatform().getScreen().getNativeHandle();
    }

    @Override
    public boolean swapBuffers() {
        xLib.XLockDisplay(this.nativeDisplay.p);
        super.swapBuffers();
        NativeCursor nativeCursor = NativePlatformFactory.getNativePlatform().getCursor();
        if (nativeCursor instanceof X11WarpingCursor) {
            ((X11WarpingCursor)nativeCursor).warp();
        }
        xLib.XUnlockDisplay(this.nativeDisplay.p);
        return true;
    }
}

