/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AcceleratedScreen;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.LinuxInputDeviceRegistry;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.NullCursor;
import com.sun.glass.ui.monocle.X11AcceleratedScreen;
import com.sun.glass.ui.monocle.X11Cursor;
import com.sun.glass.ui.monocle.X11InputDeviceRegistry;
import com.sun.glass.ui.monocle.X11Screen;
import com.sun.glass.ui.monocle.X11WarpingCursor;
import java.security.AccessController;

class X11Platform
extends NativePlatform {
    private final boolean x11Input;

    X11Platform() {
        LinuxSystem.getLinuxSystem().loadLibrary();
        this.x11Input = AccessController.doPrivileged(() -> Boolean.getBoolean("x11.input"));
    }

    @Override
    protected InputDeviceRegistry createInputDeviceRegistry() {
        if (this.x11Input) {
            return new X11InputDeviceRegistry();
        }
        return new LinuxInputDeviceRegistry(false);
    }

    @Override
    protected NativeCursor createCursor() {
        if (useCursor) {
            X11Cursor x11Cursor = this.x11Input ? new X11Cursor() : new X11WarpingCursor();
            return this.logSelectedCursor(x11Cursor);
        }
        return this.logSelectedCursor(new NullCursor());
    }

    @Override
    protected NativeScreen createScreen() {
        return new X11Screen(this.x11Input);
    }

    @Override
    public synchronized AcceleratedScreen getAcceleratedScreen(int[] nArray) throws GLException {
        if (this.accScreen == null) {
            this.accScreen = new X11AcceleratedScreen(nArray);
        }
        return this.accScreen;
    }
}

