/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.InstantComparator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.Holder;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.Paths;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.jgit.util.sha1.SHA1;

public abstract class WorkingTreeIterator
extends AbstractTreeIterator {
    private static final int MAX_EXCEPTION_TEXT_SIZE = 10240;
    protected static final Entry[] EOF = new Entry[0];
    static final int BUFFER_SIZE = 2048;
    private static final long MAXIMUM_FILE_SIZE_TO_READ_FULLY = 65536L;
    private final IteratorState state;
    private byte[] contentId;
    private int contentIdFromPtr;
    private Entry[] entries;
    private int entryCnt;
    private int ptr;
    private IgnoreNode ignoreNode;
    private Holder<String> cleanFilterCommandHolder;
    private Holder<CoreConfig.EolStreamType> eolStreamTypeHolder;
    protected Repository repository;
    private long canonLen = -1L;
    private int contentIdOffset;
    private final InstantComparator timestampComparator = new InstantComparator();
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] hblob = Constants.encodedTypeString(3);
    private static final Comparator<Entry> ENTRY_CMP = (a, b) -> Paths.compare(a.encodedName, 0, a.encodedNameLen, a.getMode().getBits(), b.encodedName, 0, b.encodedNameLen, b.getMode().getBits());

    protected WorkingTreeIterator(WorkingTreeOptions options) {
        this.state = new IteratorState(options);
    }

    protected WorkingTreeIterator(String prefix, WorkingTreeOptions options) {
        super(prefix);
        this.state = new IteratorState(options);
    }

    protected WorkingTreeIterator(WorkingTreeIterator p) {
        super(p);
        this.state = p.state;
        this.repository = p.repository;
    }

    protected void initRootIterator(Repository repo) {
        this.repository = repo;
        Entry entry = this.ignoreNode instanceof PerDirectoryIgnoreNode ? ((PerDirectoryIgnoreNode)this.ignoreNode).entry : null;
        this.ignoreNode = new RootIgnoreNode(entry, repo);
    }

    public void setDirCacheIterator(TreeWalk walk, int treeId) {
        this.state.walk = walk;
        this.state.dirCacheTree = treeId;
    }

    protected DirCacheIterator getDirCacheIterator() {
        if (this.state.dirCacheTree >= 0 && this.state.walk != null) {
            return this.state.walk.getTree(this.state.dirCacheTree, DirCacheIterator.class);
        }
        return null;
    }

    public void setWalkIgnoredDirectories(boolean includeIgnored) {
        this.state.walkIgnored = includeIgnored;
    }

    public boolean walksIgnoredDirectories() {
        return this.state.walkIgnored;
    }

    @Override
    public boolean hasId() {
        if (this.contentIdFromPtr == this.ptr) {
            return true;
        }
        return (this.mode & 0xF000) == 32768;
    }

    @Override
    public byte[] idBuffer() {
        if (this.contentIdFromPtr == this.ptr) {
            return this.contentId;
        }
        if (this.state.walk != null) {
            DirCacheIterator i = this.state.walk.getTree(this.state.dirCacheTree, DirCacheIterator.class);
            if (i != null) {
                DirCacheEntry ent = i.getDirCacheEntry();
                if (ent != null && this.compareMetadata(ent) == MetadataDiff.EQUAL && (ent.getFileMode().getBits() & 0xF000) != 57344) {
                    this.contentIdOffset = i.idOffset();
                    this.contentIdFromPtr = this.ptr;
                    this.contentId = i.idBuffer();
                    return this.contentId;
                }
                this.contentIdOffset = 0;
            } else {
                this.contentIdOffset = 0;
            }
        }
        switch (this.mode & 0xF000) {
            case 32768: 
            case 40960: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idBufferBlob(this.entries[this.ptr]);
                return this.contentId;
            }
            case 57344: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idSubmodule(this.entries[this.ptr]);
                return this.contentId;
            }
        }
        return zeroid;
    }

    @Override
    public boolean isWorkTree() {
        return true;
    }

    protected byte[] idSubmodule(Entry e) {
        File directory;
        if (this.repository == null) {
            return zeroid;
        }
        try {
            directory = this.repository.getWorkTree();
        }
        catch (NoWorkTreeException nwte) {
            return zeroid;
        }
        return this.idSubmodule(directory, e);
    }

    protected byte[] idSubmodule(File directory, Entry e) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Repository submoduleRepo = SubmoduleWalk.getSubmoduleRepository(directory, e.getName(), this.repository != null ? this.repository.getFS() : FS.DETECTED);){
                if (submoduleRepo == null) {
                    return zeroid;
                }
                ObjectId head = submoduleRepo.resolve("HEAD");
                if (head == null) {
                    return zeroid;
                }
                byte[] id = new byte[20];
                head.copyRawTo(id, 0);
                return id;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            return zeroid;
        }
    }

    private byte[] idBufferBlob(Entry e) {
        byte[] byArray;
        InputStream is = e.openInputStream();
        if (is == null) {
            return zeroid;
        }
        try {
            this.state.initializeReadBuffer();
            long len = e.getLength();
            InputStream filteredIs = this.possiblyFilteredInputStream(e, is, len);
            byArray = this.computeHash(filteredIs, this.canonLen);
        }
        catch (Throwable throwable) {
            try {
                WorkingTreeIterator.safeClose(is);
                throw throwable;
            }
            catch (IOException err) {
                return zeroid;
            }
        }
        WorkingTreeIterator.safeClose(is);
        return byArray;
    }

    private InputStream possiblyFilteredInputStream(Entry e, InputStream is, long len) throws IOException {
        if (this.getCleanFilterCommand() == null && this.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP) == CoreConfig.EolStreamType.DIRECT) {
            this.canonLen = len;
            return is;
        }
        if (len <= 65536L) {
            ByteBuffer rawbuf = IO.readWholeStream(is, (int)len);
            rawbuf = this.filterClean(rawbuf.array(), rawbuf.limit());
            this.canonLen = rawbuf.limit();
            return new ByteArrayInputStream(rawbuf.array(), 0, (int)this.canonLen);
        }
        if (this.getCleanFilterCommand() == null && WorkingTreeIterator.isBinary(e)) {
            this.canonLen = len;
            return is;
        }
        InputStream lenIs = this.filterClean(e.openInputStream());
        try {
            this.canonLen = WorkingTreeIterator.computeLength(lenIs);
        }
        finally {
            WorkingTreeIterator.safeClose(lenIs);
        }
        return this.filterClean(is);
    }

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isBinary(Entry entry) throws IOException {
        InputStream in = entry.openInputStream();
        try {
            boolean bl = RawText.isBinary(in);
            return bl;
        }
        finally {
            WorkingTreeIterator.safeClose(in);
        }
    }

    private ByteBuffer filterClean(byte[] src, int n) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(src);
        try {
            ByteBuffer byteBuffer = IO.readWholeStream(this.filterClean(in), n);
            return byteBuffer;
        }
        finally {
            WorkingTreeIterator.safeClose(in);
        }
    }

    private InputStream filterClean(InputStream in) throws IOException {
        in = EolStreamTypeUtil.wrapInputStream(in, this.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP));
        String filterCommand = this.getCleanFilterCommand();
        if (filterCommand != null) {
            FS.ExecutionResult result;
            if (FilterCommandRegistry.isRegistered(filterCommand)) {
                TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
                FilterCommand command = FilterCommandRegistry.createFilterCommand(filterCommand, this.repository, in, buffer);
                while (command.run() != -1) {
                }
                return buffer.openInputStreamWithAutoDestroy();
            }
            FS fs = this.repository.getFS();
            ProcessBuilder filterProcessBuilder = fs.runInShell(filterCommand, new String[0]);
            filterProcessBuilder.directory(this.repository.getWorkTree());
            filterProcessBuilder.environment().put("GIT_DIR", this.repository.getDirectory().getAbsolutePath());
            try {
                result = fs.execute(filterProcessBuilder, in);
            }
            catch (IOException | InterruptedException e) {
                throw new IOException(new FilterFailedException(e, filterCommand, this.getEntryPathString()));
            }
            int rc = result.getRc();
            if (rc != 0) {
                throw new IOException(new FilterFailedException(rc, filterCommand, this.getEntryPathString(), result.getStdout().toByteArray(10240), result.getStderr().toString(10240)));
            }
            return result.getStdout().openInputStreamWithAutoDestroy();
        }
        return in;
    }

    public WorkingTreeOptions getOptions() {
        return this.state.options;
    }

    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public int idOffset() {
        return this.contentIdOffset;
    }

    @Override
    public void reset() {
        if (!this.first()) {
            this.ptr = 0;
            if (!this.eof()) {
                this.parseEntry();
            }
        }
    }

    @Override
    public boolean first() {
        return this.ptr == 0;
    }

    @Override
    public boolean eof() {
        return this.ptr == this.entryCnt;
    }

    @Override
    public void next(int delta) throws CorruptObjectException {
        this.ptr += delta;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    @Override
    public void back(int delta) throws CorruptObjectException {
        this.ptr -= delta;
        this.parseEntry();
    }

    private void parseEntry() {
        Entry e = this.entries[this.ptr];
        this.mode = e.getMode().getBits();
        int nameLen = e.encodedNameLen;
        this.ensurePathCapacity(this.pathOffset + nameLen, this.pathOffset);
        System.arraycopy(e.encodedName, 0, this.path, this.pathOffset, nameLen);
        this.pathLen = this.pathOffset + nameLen;
        this.canonLen = -1L;
        this.cleanFilterCommandHolder = null;
        this.eolStreamTypeHolder = null;
    }

    public long getEntryLength() {
        return this.current().getLength();
    }

    public long getEntryContentLength() throws IOException {
        if (this.canonLen == -1L) {
            long rawLen = this.getEntryLength();
            if (rawLen == 0L) {
                this.canonLen = 0L;
            }
            InputStream is = this.current().openInputStream();
            try {
                this.possiblyFilteredInputStream(this.current(), is, this.current().getLength());
            }
            finally {
                WorkingTreeIterator.safeClose(is);
            }
        }
        return this.canonLen;
    }

    @Deprecated
    public long getEntryLastModified() {
        return this.current().getLastModified();
    }

    public Instant getEntryLastModifiedInstant() {
        return this.current().getLastModifiedInstant();
    }

    public InputStream openEntryStream() throws IOException {
        InputStream rawis = this.current().openInputStream();
        if (this.getCleanFilterCommand() == null && this.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP) == CoreConfig.EolStreamType.DIRECT) {
            return rawis;
        }
        return this.filterClean(rawis);
    }

    public boolean isEntryIgnored() throws IOException {
        return this.isEntryIgnored(this.pathLen);
    }

    protected boolean isEntryIgnored(int pLen) throws IOException {
        return this.isEntryIgnored(pLen, this.mode);
    }

    private boolean isEntryIgnored(int pLen, int fileMode) throws IOException {
        Boolean ignored;
        int pOff = this.pathOffset > 0 ? this.pathOffset - 1 : this.pathOffset;
        String pathRel = TreeWalk.pathOf(this.path, pOff, pLen);
        String parentRel = WorkingTreeIterator.getParentPath(pathRel);
        if (this.isDirectoryIgnored(parentRel)) {
            return true;
        }
        IgnoreNode rules = this.getIgnoreNode();
        Boolean bl = ignored = rules != null ? rules.checkIgnored(pathRel, FileMode.TREE.equals(fileMode)) : null;
        if (ignored != null) {
            return ignored;
        }
        return this.parent instanceof WorkingTreeIterator && ((WorkingTreeIterator)this.parent).isEntryIgnored(pLen, fileMode);
    }

    private IgnoreNode getIgnoreNode() throws IOException {
        if (this.ignoreNode instanceof PerDirectoryIgnoreNode) {
            this.ignoreNode = ((PerDirectoryIgnoreNode)this.ignoreNode).load();
        }
        return this.ignoreNode;
    }

    public AttributesNode getEntryAttributesNode() throws IOException {
        if (this.attributesNode instanceof PerDirectoryAttributesNode) {
            this.attributesNode = ((PerDirectoryAttributesNode)this.attributesNode).load();
        }
        return this.attributesNode;
    }

    protected void init(Entry[] list) {
        this.entries = list;
        CharsetEncoder nameEncoder = this.state.nameEncoder;
        int i = 0;
        int o = 0;
        while (i < this.entries.length) {
            String name;
            Entry e = this.entries[i];
            if (!(e == null || ".".equals(name = e.getName()) || "..".equals(name) || ".git".equals(name))) {
                if (".gitignore".equals(name)) {
                    this.ignoreNode = new PerDirectoryIgnoreNode(String.valueOf(TreeWalk.pathOf(this.path, 0, this.pathOffset)) + ".gitignore", e);
                }
                if (".gitattributes".equals(name)) {
                    this.attributesNode = new PerDirectoryAttributesNode(e);
                }
                if (i != o) {
                    this.entries[o] = e;
                }
                e.encodeName(nameEncoder);
                ++o;
            }
            ++i;
        }
        this.entryCnt = o;
        Arrays.sort(this.entries, 0, this.entryCnt, ENTRY_CMP);
        this.contentIdFromPtr = -1;
        this.ptr = 0;
        if (!this.eof()) {
            this.parseEntry();
        } else if (this.pathLen == 0) {
            this.pathLen = this.pathOffset;
        }
    }

    protected Entry current() {
        return this.entries[this.ptr];
    }

    public boolean isModeDifferent(int rawMode) {
        int modeDiff = this.getEntryRawMode() ^ rawMode;
        if (modeDiff == 0) {
            return false;
        }
        if (this.getOptions().getSymLinks() == CoreConfig.SymLinks.FALSE && FileMode.SYMLINK.equals(rawMode)) {
            return false;
        }
        if (!this.state.options.isFileMode()) {
            modeDiff &= ~FileMode.EXECUTABLE_FILE.getBits();
        }
        return modeDiff != 0;
    }

    public MetadataDiff compareMetadata(DirCacheEntry entry) {
        Instant fileLastModified;
        if (entry.isAssumeValid()) {
            return MetadataDiff.EQUAL;
        }
        if (entry.isUpdateNeeded()) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        if (this.isModeDifferent(entry.getRawMode())) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        int type = this.mode & 0xF000;
        if (type == 16384 || type == 57344) {
            return MetadataDiff.EQUAL;
        }
        if (!entry.isSmudged() && entry.getLength() != (int)this.getEntryLength()) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        Instant cacheLastModified = entry.getLastModifiedInstant();
        if (this.timestampComparator.compare(cacheLastModified, fileLastModified = this.getEntryLastModifiedInstant(), this.getOptions().getCheckStat() == CoreConfig.CheckStat.MINIMAL) != 0) {
            return MetadataDiff.DIFFER_BY_TIMESTAMP;
        }
        if (entry.isSmudged()) {
            return MetadataDiff.SMUDGED;
        }
        return MetadataDiff.EQUAL;
    }

    public boolean isModified(DirCacheEntry entry, boolean forceContentCheck, ObjectReader reader) throws IOException {
        if (entry == null) {
            return !FileMode.MISSING.equals(this.getEntryFileMode());
        }
        MetadataDiff diff = this.compareMetadata(entry);
        switch (diff) {
            case DIFFER_BY_TIMESTAMP: {
                if (forceContentCheck) {
                    return this.contentCheck(entry, reader);
                }
                return true;
            }
            case SMUDGED: {
                return this.contentCheck(entry, reader);
            }
            case EQUAL: {
                if (this.mode == FileMode.SYMLINK.getBits()) {
                    return this.contentCheck(entry, reader);
                }
                return false;
            }
            case DIFFER_BY_METADATA: {
                if (this.mode == FileMode.TREE.getBits() && entry.getFileMode().equals(FileMode.GITLINK)) {
                    byte[] idBuffer = this.idBuffer();
                    int idOffset = this.idOffset();
                    if (entry.getObjectId().compareTo(idBuffer, idOffset) == 0) {
                        return true;
                    }
                    if (ObjectId.zeroId().compareTo(idBuffer, idOffset) == 0) {
                        Path p = this.repository.getWorkTree().toPath().resolve(entry.getPathString());
                        return FileUtils.hasFiles(p);
                    }
                    return false;
                }
                if (this.mode == FileMode.SYMLINK.getBits()) {
                    return this.contentCheck(entry, reader);
                }
                return true;
            }
        }
        throw new IllegalStateException(MessageFormat.format(JGitText.get().unexpectedCompareResult, diff.name()));
    }

    public FileMode getIndexFileMode(DirCacheIterator indexIter) {
        FileMode wtMode = this.getEntryFileMode();
        if (indexIter == null) {
            return wtMode;
        }
        FileMode iMode = indexIter.getEntryFileMode();
        if (iMode == FileMode.SYMLINK && this.getOptions().getSymLinks() == CoreConfig.SymLinks.FALSE && (wtMode == FileMode.REGULAR_FILE || wtMode == FileMode.EXECUTABLE_FILE)) {
            return iMode;
        }
        if (this.getOptions().isFileMode() && iMode != FileMode.GITLINK && iMode != FileMode.TREE) {
            return wtMode;
        }
        if (!this.getOptions().isFileMode()) {
            if (FileMode.REGULAR_FILE == wtMode && FileMode.EXECUTABLE_FILE == iMode) {
                return iMode;
            }
            if (FileMode.EXECUTABLE_FILE == wtMode && FileMode.REGULAR_FILE == iMode) {
                return iMode;
            }
        }
        if (FileMode.GITLINK == iMode && FileMode.TREE == wtMode && !this.getOptions().isDirNoGitLinks()) {
            return iMode;
        }
        if (FileMode.TREE == iMode && FileMode.GITLINK == wtMode) {
            return iMode;
        }
        return wtMode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contentCheck(DirCacheEntry entry, ObjectReader reader) throws IOException {
        if (this.getEntryObjectId().equals(entry.getObjectId())) {
            entry.setLength((int)this.getEntryLength());
            return false;
        }
        if (this.mode == FileMode.SYMLINK.getBits()) {
            if (!new File(this.readSymlinkTarget(this.current())).equals(new File(WorkingTreeIterator.readContentAsNormalizedString(entry, reader)))) return true;
            return false;
        }
        if (this.getCleanFilterCommand() == null) return true;
        if ((this.mode & 0xF000) != 32768) return true;
        Entry fsEntry = this.current();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = fsEntry.openInputStream();){
            long fsLength = fsEntry.getLength();
            byte[] hash = this.computeHash(is, fsLength);
            ObjectId fsEntryObjectId = ObjectId.fromRaw(hash, this.idOffset());
            if (!fsEntryObjectId.equals(entry.getObjectId())) return true;
            this.contentId = hash;
            entry.setLength((int)fsLength);
            return false;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private static String readContentAsNormalizedString(DirCacheEntry entry, ObjectReader reader) throws MissingObjectException, IOException {
        ObjectLoader open = reader.open(entry.getObjectId());
        byte[] cachedBytes = open.getCachedBytes();
        return FS.detect().normalize(RawParseUtils.decode(cachedBytes));
    }

    protected String readSymlinkTarget(Entry entry) throws IOException {
        if (!entry.getMode().equals(FileMode.SYMLINK)) {
            throw new NotLinkException(entry.getName());
        }
        long length = entry.getLength();
        byte[] content = new byte[(int)length];
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream is = entry.openInputStream();){
            int bytesRead = IO.readFully(is, content, 0);
            return FS.detect().normalize(RawParseUtils.decode(content, 0, bytesRead));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static long computeLength(InputStream in) throws IOException {
        long n;
        long length = 0L;
        while ((n = in.skip(0x100000L)) > 0L) {
            length += n;
        }
        return length;
    }

    private byte[] computeHash(InputStream in, long length) throws IOException {
        int r;
        SHA1 contentDigest = SHA1.newInstance();
        byte[] contentReadBuffer = this.state.contentReadBuffer;
        contentDigest.update(hblob);
        contentDigest.update((byte)32);
        long sz = length;
        if (sz == 0L) {
            contentDigest.update((byte)48);
        } else {
            int bufn;
            int p = bufn = contentReadBuffer.length;
            do {
                contentReadBuffer[--p] = digits[(int)(sz % 10L)];
            } while ((sz /= 10L) > 0L);
            contentDigest.update(contentReadBuffer, p, bufn - p);
        }
        contentDigest.update((byte)0);
        while ((r = in.read(contentReadBuffer)) > 0) {
            contentDigest.update(contentReadBuffer, 0, r);
            sz += (long)r;
        }
        if (sz != length) {
            return zeroid;
        }
        return contentDigest.digest();
    }

    public String getCleanFilterCommand() throws IOException {
        if (this.cleanFilterCommandHolder == null) {
            String cmd = null;
            if (this.state.walk != null) {
                cmd = this.state.walk.getFilterCommand("clean");
            }
            this.cleanFilterCommandHolder = new Holder<Object>(cmd);
        }
        return this.cleanFilterCommandHolder.get();
    }

    public CoreConfig.EolStreamType getEolStreamType() throws IOException {
        return this.getEolStreamType(null);
    }

    private CoreConfig.EolStreamType getEolStreamType(TreeWalk.OperationType opType) throws IOException {
        if (this.eolStreamTypeHolder == null) {
            CoreConfig.EolStreamType type = null;
            if (this.state.walk != null) {
                TreeWalk.OperationType operationType;
                type = this.state.walk.getEolStreamType(opType);
                TreeWalk.OperationType operationType2 = operationType = opType != null ? opType : this.state.walk.getOperationType();
                if (TreeWalk.OperationType.CHECKIN_OP.equals((Object)operationType) && CoreConfig.EolStreamType.AUTO_LF.equals((Object)type) && this.hasCrLfInIndex(this.getDirCacheIterator())) {
                    type = CoreConfig.EolStreamType.DIRECT;
                }
            } else {
                switch (this.getOptions().getAutoCRLF()) {
                    case FALSE: {
                        type = CoreConfig.EolStreamType.DIRECT;
                        break;
                    }
                    case TRUE: 
                    case INPUT: {
                        type = CoreConfig.EolStreamType.AUTO_LF;
                    }
                }
            }
            this.eolStreamTypeHolder = new Holder<CoreConfig.EolStreamType>(type);
        }
        return this.eolStreamTypeHolder.get();
    }

    /*
     * Exception decompiling
     */
    private boolean hasCrLfInIndex(DirCacheIterator dirCache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isDirectoryIgnored(String pathRel) throws IOException {
        int pOff = this.pathOffset > 0 ? this.pathOffset - 1 : this.pathOffset;
        String base = TreeWalk.pathOf(this.path, 0, pOff);
        String pathAbs = WorkingTreeIterator.concatPath(base, pathRel);
        return this.isDirectoryIgnored(pathRel, pathAbs);
    }

    private boolean isDirectoryIgnored(String pathRel, String pathAbs) throws IOException {
        assert (pathRel.length() == 0 || pathRel.charAt(0) != '/' && pathRel.charAt(pathRel.length() - 1) != '/');
        assert (pathAbs.length() == 0 || pathAbs.charAt(0) != '/' && pathAbs.charAt(pathAbs.length() - 1) != '/');
        assert (pathAbs.endsWith(pathRel));
        Boolean ignored = this.state.directoryToIgnored.get(pathAbs);
        if (ignored != null) {
            return ignored;
        }
        String parentRel = WorkingTreeIterator.getParentPath(pathRel);
        if (parentRel != null && this.isDirectoryIgnored(parentRel)) {
            this.state.directoryToIgnored.put(pathAbs, Boolean.TRUE);
            return true;
        }
        IgnoreNode node = this.getIgnoreNode();
        String p = pathRel;
        while (node != null && !"".equals(p)) {
            ignored = node.checkIgnored(p, true);
            if (ignored != null) {
                this.state.directoryToIgnored.put(pathAbs, ignored);
                return ignored;
            }
            p = WorkingTreeIterator.getParentPath(p);
        }
        if (!(this.parent instanceof WorkingTreeIterator)) {
            this.state.directoryToIgnored.put(pathAbs, Boolean.FALSE);
            return false;
        }
        WorkingTreeIterator wtParent = (WorkingTreeIterator)this.parent;
        String parentRelPath = WorkingTreeIterator.concatPath(TreeWalk.pathOf(this.path, wtParent.pathOffset, this.pathOffset - 1), pathRel);
        assert (WorkingTreeIterator.concatPath(TreeWalk.pathOf(wtParent.path, 0, Math.max(0, wtParent.pathOffset - 1)), parentRelPath).equals(pathAbs));
        return wtParent.isDirectoryIgnored(parentRelPath, pathAbs);
    }

    private static String getParentPath(String path) {
        int slashIndex = path.lastIndexOf(47, path.length() - 2);
        if (slashIndex > 0) {
            return path.substring(path.charAt(0) == '/' ? 1 : 0, slashIndex);
        }
        return path.length() > 0 ? "" : null;
    }

    private static String concatPath(String p1, String p2) {
        return String.valueOf(p1) + (p1.length() > 0 && p2.length() > 0 ? "/" : "") + p2;
    }

    public static abstract class Entry {
        byte[] encodedName;
        int encodedNameLen;

        void encodeName(CharsetEncoder enc) {
            ByteBuffer b;
            try {
                b = enc.encode(CharBuffer.wrap(this.getName()));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(MessageFormat.format(JGitText.get().unencodeableFile, this.getName()), e);
            }
            this.encodedNameLen = b.limit();
            if (b.hasArray() && b.arrayOffset() == 0) {
                this.encodedName = b.array();
            } else {
                this.encodedName = new byte[this.encodedNameLen];
                b.get(this.encodedName);
            }
        }

        public String toString() {
            return String.valueOf(this.getMode().toString()) + " " + this.getName();
        }

        public abstract FileMode getMode();

        public abstract long getLength();

        @Deprecated
        public abstract long getLastModified();

        public abstract Instant getLastModifiedInstant();

        public abstract String getName();

        public abstract InputStream openInputStream() throws IOException;
    }

    private static class IgnoreNodeWithParent
    extends IgnoreNode {
        private final IgnoreNode parent;

        IgnoreNodeWithParent(IgnoreNode parent) {
            this.parent = parent;
        }

        @Override
        public Boolean checkIgnored(String path, boolean isDirectory) {
            Boolean result = super.checkIgnored(path, isDirectory);
            if (result == null && this.parent != null) {
                return this.parent.checkIgnored(path, isDirectory);
            }
            return result;
        }
    }

    private static final class IteratorState {
        final WorkingTreeOptions options;
        final CharsetEncoder nameEncoder;
        byte[] contentReadBuffer;
        TreeWalk walk;
        int dirCacheTree = -1;
        boolean walkIgnored = false;
        final Map<String, Boolean> directoryToIgnored = new HashMap<String, Boolean>();

        IteratorState(WorkingTreeOptions options) {
            this.options = options;
            this.nameEncoder = StandardCharsets.UTF_8.newEncoder();
        }

        void initializeReadBuffer() {
            if (this.contentReadBuffer == null) {
                this.contentReadBuffer = new byte[2048];
            }
        }
    }

    public static enum MetadataDiff {
        EQUAL,
        DIFFER_BY_METADATA,
        SMUDGED,
        DIFFER_BY_TIMESTAMP;

    }

    private static class PerDirectoryAttributesNode
    extends AttributesNode {
        final Entry entry;

        PerDirectoryAttributesNode(Entry entry) {
            super(Collections.emptyList());
            this.entry = entry;
        }

        AttributesNode load() throws IOException {
            AttributesNode r = new AttributesNode();
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream in = this.entry.openInputStream();){
                r.parse(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }

    private static class PerDirectoryIgnoreNode
    extends IgnoreNode {
        protected final Entry entry;
        private final String name;

        PerDirectoryIgnoreNode(String name, Entry entry) {
            super(Collections.emptyList());
            this.name = name;
            this.entry = entry;
        }

        IgnoreNode load() throws IOException {
            return this.load(null);
        }

        IgnoreNode load(IgnoreNode parent) throws IOException {
            IgnoreNodeWithParent r = new IgnoreNodeWithParent(parent);
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream in = this.entry.openInputStream();){
                r.parse(this.name, in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return r.getRules().isEmpty() && parent == null ? null : r;
        }
    }

    private static class RootIgnoreNode
    extends PerDirectoryIgnoreNode {
        final Repository repository;

        RootIgnoreNode(Entry entry, Repository repository) {
            super(entry != null ? entry.getName() : null, entry);
            this.repository = repository;
        }

        @Override
        IgnoreNode load(IgnoreNode parent) throws IOException {
            IgnoreNode r;
            IgnoreNodeWithParent parentNode;
            IgnoreNode coreExclude = new IgnoreNodeWithParent(parent);
            FS fs = this.repository.getFS();
            Path path = this.repository.getConfig().getPath("core", null, "excludesfile", fs, null, null);
            if (path != null) {
                RootIgnoreNode.loadRulesFromFile(coreExclude, path.toFile());
            }
            if (coreExclude.getRules().isEmpty()) {
                coreExclude = parent;
            }
            IgnoreNodeWithParent infoExclude = new IgnoreNodeWithParent(coreExclude);
            File exclude = fs.resolve(this.repository.getDirectory(), "info/exclude");
            RootIgnoreNode.loadRulesFromFile(infoExclude, exclude);
            if (infoExclude.getRules().isEmpty()) {
                infoExclude = null;
            }
            IgnoreNodeWithParent ignoreNodeWithParent = parentNode = infoExclude != null ? infoExclude : coreExclude;
            if (this.entry != null) {
                r = super.load(parentNode);
                if (r == null) {
                    return null;
                }
            } else {
                return parentNode;
            }
            return r.getRules().isEmpty() ? parentNode : r;
        }

        private static void loadRulesFromFile(IgnoreNode r, File exclude) throws FileNotFoundException, IOException {
            if (FS.DETECTED.exists(exclude)) {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream in = new FileInputStream(exclude);){
                    r.parse(exclude.getAbsolutePath(), in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

