/*
 * Decompiled with CFR 0.152.
 */
package org.openl.commons.web.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.util.StringTool;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebTool {
    private WebTool() {
    }

    public static String listRequestParams(ServletRequest request) {
        return WebTool.listRequestParams(request.getParameterMap(), null);
    }

    public static String listRequestParams(ServletRequest request, String[] exceptParams) {
        return WebTool.listRequestParams(request.getParameterMap(), exceptParams);
    }

    public static String listRequestParams(Map<String, String[]> paramsMap, String[] exceptParams) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String[]> entry : paramsMap.entrySet()) {
            String paramName = entry.getKey();
            if (ArrayUtils.contains((Object[])exceptParams, (Object)paramName)) continue;
            if (buf.length() != 0) {
                buf.append('&');
            }
            String[] paramValues = entry.getValue();
            buf.append(paramName).append('=').append(StringTool.encodeURL((String)paramValues[0]));
        }
        return buf.toString();
    }

    public static boolean isLocalRequest(ServletRequest request) {
        String remote = request.getRemoteAddr();
        boolean b = WebTool.isLoopbackAddress(remote);
        return b;
    }

    public static boolean isLoopbackAddress(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByName(ip);
            return addr != null && addr.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            Logger log = LoggerFactory.getLogger(WebTool.class);
            log.info("Cannot check '{}'.", (Object)ip, (Object)e);
            return false;
        }
    }

    public static void setContentDisposition(HttpServletResponse response, String fileName) {
        response.setHeader("Content-Disposition", WebTool.getContentDispositionValue(fileName));
    }

    public static String getContentDispositionValue(String fileName) {
        String encodedFileName = StringTool.encodeURL((String)fileName);
        return "attachment; filename=" + encodedFileName + "; filename*=UTF-8''" + encodedFileName;
    }
}

