/*
 * Decompiled with CFR 0.152.
 */
package org.openl.commons.web.jsf;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.validator.ValidatorException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openl.util.StringTool;
import org.openl.util.StringUtils;

public abstract class FacesUtils {
    public static SelectItem[] createSelectItems(Collection<String> values) {
        SelectItem[] items = new SelectItem[values.size()];
        int index = 0;
        for (String value : values) {
            items[index++] = new SelectItem((Object)value);
        }
        return items;
    }

    public static SelectItem[] createSelectItems(String[] values) {
        SelectItem[] items = new SelectItem[values.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new SelectItem((Object)values[i]);
        }
        return items;
    }

    public static SelectItem[] createSelectItems(String[] values, String[] labels) {
        SelectItem[] items = new SelectItem[values.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new SelectItem((Object)values[i], labels[i]);
        }
        return items;
    }

    public static FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public static ValueExpression createValueExpression(String expressionString) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        ValueExpression valueExpression = context.getApplication().getExpressionFactory().createValueExpression(elContext, expressionString, Object.class);
        return valueExpression;
    }

    public static MethodExpression createMethodExpression(String expressionString) {
        return FacesUtils.createMethodExpression(expressionString, null);
    }

    public static MethodExpression createMethodExpression(String expressionString, Class<?>[] paramTypes) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        MethodExpression methodExpression = context.getApplication().getExpressionFactory().createMethodExpression(elContext, expressionString, null, (Class[])(paramTypes == null ? new Class[]{} : paramTypes));
        return methodExpression;
    }

    public static Object getValueExpressionValue(String expressionString) {
        ValueExpression valueExpression = FacesUtils.createValueExpression(expressionString);
        return valueExpression.getValue(FacesUtils.getELContext());
    }

    public static Object getBackingBean(String beanName) {
        return FacesUtils.getValueExpressionValue("#{" + beanName + "}");
    }

    public static Object getValueExpressionValue(UIComponent component, String componentParam) {
        ValueExpression valueExpression = component.getValueExpression(componentParam);
        if (valueExpression != null) {
            return valueExpression.getValue(FacesUtils.getELContext());
        }
        return null;
    }

    public static String getValueExpressionString(UIComponent component, String componentParam) {
        ValueExpression valueExpression = component.getValueExpression(componentParam);
        if (valueExpression != null) {
            return valueExpression.getExpressionString();
        }
        return null;
    }

    public static Object invokeMethodExpression(String expressionString) {
        return FacesUtils.invokeMethodExpression(expressionString, null, null);
    }

    public static Object invokeMethodExpression(String expressionString, Object[] params, Class<?>[] paramTypes) {
        MethodExpression methodExpression = FacesUtils.createMethodExpression(expressionString, paramTypes);
        return methodExpression.invoke(FacesUtils.getELContext(), params == null ? new Object[]{} : params);
    }

    public static ELContext getELContext() {
        ELContext elContext = FacesUtils.getFacesContext().getELContext();
        return elContext;
    }

    public static Map<String, Object> getRequestMap() {
        return FacesUtils.getExternalContext().getRequestMap();
    }

    public static String getRequestParameter(String parameterName) {
        return FacesUtils.getRequestParameterMap().get(parameterName);
    }

    public static int getRequestIntParameter(String name, int defaultValue) {
        String value = FacesUtils.getRequestParameter(name);
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Map<String, String> getRequestParameterMap() {
        return FacesUtils.getExternalContext().getRequestParameterMap();
    }

    public static ServletContext getServletContext() {
        return (ServletContext)FacesUtils.getExternalContext().getContext();
    }

    public static Map<String, Object> getSessionMap() {
        return FacesUtils.getExternalContext().getSessionMap();
    }

    public static Object getSessionParam(String name) {
        return FacesUtils.getSessionMap().get(name);
    }

    public static void removeSessionParam(String name) {
        FacesUtils.getSessionMap().remove(name);
    }

    public static ExternalContext getExternalContext() {
        return FacesUtils.getFacesContext().getExternalContext();
    }

    public static ServletRequest getRequest() {
        return (ServletRequest)FacesUtils.getExternalContext().getRequest();
    }

    public static ServletResponse getResponse() {
        return (ServletResponse)FacesUtils.getExternalContext().getResponse();
    }

    public static HttpSession getSession(boolean create) {
        return (HttpSession)FacesUtils.getExternalContext().getSession(create);
    }

    public static HttpSession getSession() {
        return FacesUtils.getSession(false);
    }

    public static String getContextPath() {
        return FacesUtils.getExternalContext().getRequestContextPath();
    }

    public static Cookie[] getCookies() {
        return ((HttpServletRequest)FacesUtils.getRequest()).getCookies();
    }

    public static void addCookie(Cookie cookie) {
        ((HttpServletResponse)FacesUtils.getResponse()).addCookie(cookie);
    }

    public static void addCookie(String name, String value, int age) {
        Cookie cookie = new Cookie(name, StringTool.encodeURL((String)value));
        String contextPath = ((HttpServletRequest)FacesUtils.getRequest()).getContextPath();
        if (!StringUtils.isEmpty((CharSequence)contextPath)) {
            cookie.setPath(contextPath);
        } else {
            cookie.setPath("/");
        }
        cookie.setMaxAge(age);
        FacesUtils.addCookie(cookie);
    }

    public static void redirect(String page) throws IOException {
        FacesContext.getCurrentInstance().getExternalContext().redirect(page);
    }

    public static void redirectToRoot() throws IOException {
        FacesUtils.redirect(FacesUtils.getContextPath() + "/");
    }

    public static void addMessage(String summary, FacesMessage.Severity severity) {
        FacesUtils.addMessage(summary, null, severity);
    }

    public static void addMessage(String summary, String detail, FacesMessage.Severity severity) {
        FacesUtils.addMessage(null, summary, detail, severity);
    }

    public static void addMessage(String clientId, String summary, String detail, FacesMessage.Severity severity) {
        FacesUtils.getFacesContext().addMessage(clientId, new FacesMessage(severity, summary, detail));
    }

    public static void addInfoMessage(String summary) {
        FacesUtils.addInfoMessage(summary, null);
    }

    public static void addInfoMessage(String summary, String detail) {
        FacesUtils.addMessage(summary, detail, FacesMessage.SEVERITY_INFO);
    }

    public static void addErrorMessage(String summary) {
        FacesUtils.addErrorMessage(summary, null);
    }

    public static void addErrorMessage(String summary, String detail) {
        FacesUtils.addMessage(summary, detail, FacesMessage.SEVERITY_ERROR);
    }

    public static void addWarnMessage(String summary) {
        FacesUtils.addWarnMessage(summary, null);
    }

    public static void addWarnMessage(String summary, String detail) {
        FacesUtils.addMessage(summary, detail, FacesMessage.SEVERITY_WARN);
    }

    public static FacesMessage createErrorMessage(String summary) {
        return FacesUtils.createErrorMessage(summary, null);
    }

    public static FacesMessage createErrorMessage(String summary, String detail) {
        return new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail);
    }

    public static FacesMessage createWarnMessage(String summary) {
        return FacesUtils.createWarnMessage(summary, null);
    }

    public static FacesMessage createWarnMessage(String summary, String detail) {
        return new FacesMessage(FacesMessage.SEVERITY_WARN, summary, detail);
    }

    public static FacesMessage createInfoMessage(String summary) {
        return FacesUtils.createInfoMessage(summary, null);
    }

    public static FacesMessage createInfoMessage(String summary, String detail) {
        return new FacesMessage(FacesMessage.SEVERITY_INFO, summary, detail);
    }

    public static void throwValidationError(String message) {
        throw new ValidatorException(new FacesMessage(message));
    }

    public static void validate(boolean condition, String message) {
        if (!condition) {
            FacesUtils.throwValidationError(message);
        }
    }

    public static void validateAndAddErrorMessage(boolean condition, String message) {
        if (!condition) {
            FacesUtils.addErrorMessage(message);
            FacesUtils.throwValidationError(message);
        }
    }
}

