/*
 * Decompiled with CFR 0.152.
 */
package org.openl.commons.web.jsf.facelets.fn;

import com.sdicons.json.mapper.JSONMapper;
import com.sdicons.json.mapper.MapperException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.commons.web.util.WebTool;
import org.openl.util.StringTool;
import org.openl.util.StringUtils;

public final class JSFFunctions {
    private JSFFunctions() {
    }

    public static String concat(String str1, String str2) {
        return str1 + str2;
    }

    public static String joinAll(Object[] values, String separator) {
        return StringUtils.join((Object[])values, (String)separator);
    }

    public static boolean contains(Map<?, ?> map, Object key) {
        return map != null && map.containsKey(key);
    }

    public static boolean hasGlobalMessages() {
        return FacesUtils.getFacesContext().getMessages(null).hasNext();
    }

    public static Date currentDate() {
        return new Date();
    }

    public static String currentHour() {
        return JSFFunctions.formatCurrentDate("kk");
    }

    public static String currentMinute() {
        return JSFFunctions.formatCurrentDate("mm");
    }

    public static String currentYear() {
        return JSFFunctions.formatCurrentDate("yyyy");
    }

    private static String formatCurrentDate(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(new Date());
    }

    public static boolean isLocalRequest() {
        return WebTool.isLocalRequest(FacesUtils.getRequest());
    }

    public static Set<?> mapEntrySet(Map<?, ?> map) {
        return map != null ? map.entrySet() : Collections.EMPTY_SET;
    }

    public static String unescape(String string) {
        return StringEscapeUtils.unescapeHtml4((String)string);
    }

    public static String encodeURL(String url) {
        return StringTool.encodeURL((String)url);
    }

    public static String getSystemProp(String name) {
        return System.getProperty(name);
    }

    public static boolean isSystemProp(String name) {
        return JSFFunctions.getSystemProp(name) != null;
    }

    public static String toJSON(Object value) throws MapperException {
        return JSONMapper.toJSON((Object)value).render(true);
    }

    public static String escapeJS(String value) {
        return StringEscapeUtils.escapeEcmaScript((String)value);
    }

    public static String toJSText(String str) {
        return str == null ? null : str.replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'");
    }
}

