/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.excel.builder;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.openl.rules.excel.builder.export.DataTableExporter;
import org.openl.rules.excel.builder.export.DatatypeTableExporter;
import org.openl.rules.excel.builder.export.EnvironmentTableExporter;
import org.openl.rules.excel.builder.export.SpreadsheetResultTableExporter;
import org.openl.rules.excel.builder.template.ExcelTemplateUtils;
import org.openl.rules.excel.builder.template.SpreadsheetTableStyle;
import org.openl.rules.excel.builder.template.TableStyle;
import org.openl.rules.model.scaffolding.DatatypeModel;
import org.openl.rules.model.scaffolding.ProjectModel;
import org.openl.rules.model.scaffolding.SpreadsheetModel;
import org.openl.rules.model.scaffolding.StepModel;
import org.openl.rules.model.scaffolding.data.DataModel;
import org.openl.rules.model.scaffolding.environment.EnvironmentModel;
import org.openl.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelFileBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelFileBuilder.class);

    private ExcelFileBuilder() {
    }

    public static void generateProject(ProjectModel projectModel) {
        String projectName = projectModel.getName();
        String fileName = projectName + ".xlsx";
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            ExcelFileBuilder.writeProject(projectModel, fos);
        }
        catch (IOException e) {
            LOGGER.error("Error on saving the file occurred.", (Throwable)e);
        }
    }

    public static void generateProject(ProjectModel projectModel, OutputStream outputStream) {
        ExcelFileBuilder.writeProject(projectModel, outputStream);
    }

    public static void generateDataTypes(Set<DatatypeModel> datatypeModels, OutputStream outputStream) {
        ExcelFileBuilder.writeDataTypes(datatypeModels, outputStream);
    }

    public static void generateDataTables(List<DataModel> dataModels, OutputStream outputStream) {
        ExcelFileBuilder.writeDataTables(dataModels, outputStream);
    }

    public static void generateSpreadsheets(List<SpreadsheetModel> spreadsheetModels, OutputStream outputStream) {
        ExcelFileBuilder.writeSpreadsheets(spreadsheetModels, outputStream);
    }

    public static void generateAlgorithmsModule(List<SpreadsheetModel> spreadsheetModels, List<DataModel> dataModels, OutputStream outputStream, EnvironmentModel model) {
        ExcelFileBuilder.writeAlgorithmsModule(spreadsheetModels, dataModels, outputStream, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDataTypes(Set<DatatypeModel> datatypeModels, OutputStream outputStream) {
        SXSSFWorkbook tempWorkbook = null;
        try (SXSSFWorkbook workbook = tempWorkbook = ExcelTemplateUtils.getTemplate();){
            Map<String, TableStyle> stylesMap = ExcelTemplateUtils.extractTemplateInfo((Workbook)workbook);
            SXSSFSheet dtSheet = workbook.createSheet("Datatypes");
            TableStyle datatypeStyles = stylesMap.get("Datatypes");
            DatatypeTableExporter datatypeTableExporter = new DatatypeTableExporter();
            datatypeTableExporter.setTableStyle(datatypeStyles);
            datatypeTableExporter.export(datatypeModels, (Sheet)dtSheet);
            dtSheet.validateMergedRegions();
            ExcelFileBuilder.autoSizeSheets(workbook);
            workbook.write(outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error on generating DataTypes workbook occurred.", (Throwable)e);
        }
        finally {
            if (tempWorkbook != null) {
                tempWorkbook.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDataTables(List<DataModel> dataModels, OutputStream outputStream) {
        SXSSFWorkbook tempWorkbook = null;
        try (SXSSFWorkbook workbook = tempWorkbook = ExcelTemplateUtils.getTemplate();){
            Map<String, TableStyle> stylesMap = ExcelTemplateUtils.extractTemplateInfo((Workbook)workbook);
            SXSSFSheet dtSheet = workbook.createSheet("Data Table");
            TableStyle datatypeStyles = stylesMap.get("Data Table");
            DataTableExporter dataTableExporter = new DataTableExporter();
            dataTableExporter.setTableStyle(datatypeStyles);
            dataTableExporter.export(dataModels, (Sheet)dtSheet);
            dtSheet.validateMergedRegions();
            ExcelFileBuilder.autoSizeSheets(workbook);
            workbook.write(outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error on generating Data tables workbook occurred.", (Throwable)e);
        }
        finally {
            if (tempWorkbook != null) {
                tempWorkbook.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSpreadsheets(List<SpreadsheetModel> spreadsheetModels, OutputStream outputStream) {
        SXSSFWorkbook tempWorkbook = null;
        try (SXSSFWorkbook workbook = tempWorkbook = ExcelTemplateUtils.getTemplate();){
            Map<String, TableStyle> stylesMap = ExcelTemplateUtils.extractTemplateInfo((Workbook)workbook);
            TableStyle sprStyles = stylesMap.get("SpreadsheetResults");
            ExcelFileBuilder.writeSpreadsheets(spreadsheetModels, workbook, sprStyles);
            ExcelFileBuilder.autoSizeSheets(workbook);
            workbook.write(outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error on generating Spreadsheet workbook occurred.", (Throwable)e);
        }
        finally {
            if (tempWorkbook != null) {
                tempWorkbook.dispose();
            }
        }
    }

    private static void writeSpreadsheets(List<SpreadsheetModel> spreadsheetModels, SXSSFWorkbook workbook, TableStyle tableStyle) {
        SXSSFSheet sprSheet = workbook.createSheet("SpreadsheetResults");
        SpreadsheetResultTableExporter sprTableExporter = new SpreadsheetResultTableExporter();
        Set<String> reservedWords = spreadsheetModels.stream().map(SpreadsheetModel::getSteps).flatMap(Collection::stream).map(StepModel::getName).collect(Collectors.toSet());
        ExcelFileBuilder.editTextIfNeeded((SpreadsheetTableStyle)tableStyle, reservedWords);
        sprTableExporter.setTableStyle(tableStyle);
        sprTableExporter.export(spreadsheetModels, (Sheet)sprSheet);
        sprSheet.validateMergedRegions();
    }

    private static void editTextIfNeeded(SpreadsheetTableStyle tableStyle, Set<String> reservedWords) {
        String defaultValueHeader = tableStyle.getValueHeaderText();
        if (defaultValueHeader == null) {
            return;
        }
        String valueHeaderText = ExcelFileBuilder.makeName(defaultValueHeader, reservedWords);
        if (!defaultValueHeader.equals(valueHeaderText)) {
            tableStyle.setValueHeaderText(valueHeaderText);
        }
    }

    private static String makeName(String text, Set<String> reservedWords) {
        if (CollectionUtils.isNotEmpty(reservedWords) && reservedWords.contains(text)) {
            text = text + "1";
            return ExcelFileBuilder.makeName(text, reservedWords);
        }
        return text;
    }

    private static void writeDataTables(List<DataModel> dataModels, SXSSFWorkbook workbook, TableStyle tableStyle) {
        SXSSFSheet dataTableSheet = workbook.createSheet("Data Table");
        DataTableExporter dtExporter = new DataTableExporter();
        dtExporter.setTableStyle(tableStyle);
        dtExporter.export(dataModels, (Sheet)dataTableSheet);
        dataTableSheet.validateMergedRegions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAlgorithmsModule(List<SpreadsheetModel> spreadsheetModels, List<DataModel> dataModels, OutputStream outputStream, EnvironmentModel environmentModel) {
        SXSSFWorkbook tempWorkbook = null;
        try (SXSSFWorkbook workbook = tempWorkbook = ExcelTemplateUtils.getTemplate();){
            Map<String, TableStyle> stylesMap = ExcelTemplateUtils.extractTemplateInfo((Workbook)workbook);
            TableStyle sprStyle = stylesMap.get("SpreadsheetResults");
            TableStyle envStyle = stylesMap.get("Environment");
            TableStyle dataTableStyle = stylesMap.get("Data Table");
            ExcelFileBuilder.writeSpreadsheets(spreadsheetModels, workbook, sprStyle);
            ExcelFileBuilder.writeEnvironment(environmentModel, workbook, envStyle);
            ExcelFileBuilder.writeDataTables(dataModels, workbook, dataTableStyle);
            ExcelFileBuilder.autoSizeSheets(workbook);
            workbook.write(outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error on generating Spreadsheet workbook occurred.", (Throwable)e);
        }
        finally {
            if (tempWorkbook != null) {
                tempWorkbook.dispose();
            }
        }
    }

    private static void writeEnvironment(EnvironmentModel environmentModel, SXSSFWorkbook workbook, TableStyle style) {
        if (environmentModel == null) {
            return;
        }
        SXSSFSheet envSheet = workbook.createSheet("Environment");
        EnvironmentTableExporter environmentTableExporter = new EnvironmentTableExporter();
        environmentTableExporter.setTableStyle(style);
        environmentTableExporter.export(Collections.singletonList(environmentModel), (Sheet)envSheet);
        envSheet.validateMergedRegions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProject(ProjectModel projectModel, OutputStream fos) {
        SXSSFWorkbook tempWorkbook = null;
        try (SXSSFWorkbook workbook = tempWorkbook = ExcelTemplateUtils.getTemplate();){
            Map<String, TableStyle> stylesMap = ExcelTemplateUtils.extractTemplateInfo((Workbook)workbook);
            SXSSFSheet dtSheet = workbook.createSheet("Datatypes");
            SXSSFSheet sprSheet = workbook.createSheet("SpreadsheetResults");
            SXSSFSheet dataSheet = workbook.createSheet("Data Table");
            TableStyle datatypeStyles = stylesMap.get("Datatypes");
            TableStyle sprStyles = stylesMap.get("SpreadsheetResults");
            TableStyle dataStyles = stylesMap.get("Data Table");
            DatatypeTableExporter datatypeTableExporter = new DatatypeTableExporter();
            datatypeTableExporter.setTableStyle(datatypeStyles);
            SpreadsheetResultTableExporter sprTableExporter = new SpreadsheetResultTableExporter();
            sprTableExporter.setTableStyle(sprStyles);
            DataTableExporter dataTableExporter = new DataTableExporter();
            dataTableExporter.setTableStyle(dataStyles);
            datatypeTableExporter.export(projectModel.getDatatypeModels(), (Sheet)dtSheet);
            sprTableExporter.export(projectModel.getSpreadsheetResultModels(), (Sheet)sprSheet);
            dataTableExporter.export(projectModel.getDataModels(), (Sheet)dataSheet);
            dtSheet.validateMergedRegions();
            sprSheet.validateMergedRegions();
            dataSheet.validateMergedRegions();
            ExcelFileBuilder.autoSizeSheets(workbook);
            workbook.write(fos);
        }
        catch (IOException e) {
            LOGGER.error("Error on generating workbook occurred.", (Throwable)e);
        }
        finally {
            if (tempWorkbook != null) {
                tempWorkbook.dispose();
            }
        }
    }

    private static void autoSizeSheets(SXSSFWorkbook workbook) {
        int numberOfSheets = workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            SXSSFSheet sheet = workbook.getSheetAt(i);
            sheet.trackAllColumnsForAutoSizing();
            ExcelFileBuilder.autoSizeColumns(sheet);
        }
    }

    private static void autoSizeColumns(SXSSFSheet sheet) {
        SXSSFRow row = sheet.getRow(sheet.getLastRowNum());
        if (row == null) {
            return;
        }
        int lastColumn = row.getLastCellNum();
        for (int i = 1; i < lastColumn; ++i) {
            sheet.autoSizeColumn(i, true);
        }
    }
}

