/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.excel.builder.export;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openl.rules.excel.builder.CellRangeSettings;
import org.openl.rules.excel.builder.export.AbstractOpenlTableExporter;
import org.openl.rules.excel.builder.export.Cursor;
import org.openl.rules.excel.builder.export.DefaultValueCellWriter;
import org.openl.rules.excel.builder.template.DataTableStyle;
import org.openl.rules.excel.builder.template.TableStyle;
import org.openl.rules.model.scaffolding.FieldModel;
import org.openl.rules.model.scaffolding.Model;
import org.openl.rules.model.scaffolding.data.DataModel;
import org.openl.rules.table.xls.PoiExcelHelper;
import org.openl.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableExporter
extends AbstractOpenlTableExporter<DataModel> {
    public static final String DATA_SHEET = "Data Table";
    public static final String DATA_TYPE_NAME = "{returnType}";
    public static final String DATA_TABLE_NAME = "{table.name}";
    public static final int ROWS_COUNT = 3;
    public static final String KEYWORD = "this";
    private final Logger LOGGER = LoggerFactory.getLogger(DataTableExporter.class);

    @Override
    protected void exportTables(Collection<DataModel> models, Sheet sheet) {
        Cursor endPosition = null;
        TableStyle style = this.getTableStyle();
        for (DataModel model : models) {
            this.LOGGER.debug("exporting data table with name {}", (Object)model.getName());
            Cursor startPosition = this.nextFreePosition(endPosition);
            endPosition = this.exportTable(model, startPosition, style, sheet);
        }
    }

    @Override
    protected Cursor exportTable(DataModel model, Cursor startPosition, TableStyle defaultStyle, Sheet sheet) {
        DataTableStyle style = (DataTableStyle)defaultStyle;
        RichTextString dataTableHeaderTemplate = style.getHeaderTemplate();
        CellRangeSettings headerSettings = style.getHeaderSizeSettings();
        CellStyle subheaderStyle = style.getSubheaderStyle();
        Font tableNameFont = style.getTableNameFont();
        Font typeFont = style.getTypeFont();
        CellStyle headerStyle = style.getHeaderStyle();
        CellStyle dateStyle = style.getDateStyle();
        CellStyle dateTimeStyle = style.getDateTimeStyle();
        String type = model.getType();
        String dataHeaderText = dataTableHeaderTemplate.getString().replace(DATA_TYPE_NAME, type);
        dataHeaderText = dataHeaderText.replace(DATA_TABLE_NAME, model.getName());
        List fields = model.getDatatypeModel().getFields();
        int width = CollectionUtils.isEmpty((Collection)fields) ? 0 : fields.size() - 1;
        this.addMergedHeader(sheet, startPosition, headerStyle, new CellRangeSettings(headerSettings.getHeight(), width));
        Cell topLeftCell = PoiExcelHelper.getOrCreateCell((int)startPosition.getColumn(), (int)startPosition.getRow(), (Sheet)sheet);
        XSSFRichTextString dtHeader = new XSSFRichTextString(dataHeaderText);
        int typeStart = dataHeaderText.indexOf(type);
        int typeEnd = typeStart + type.length();
        dtHeader.applyFont(typeStart, typeEnd, typeFont);
        dtHeader.applyFont(typeEnd + 1, dataHeaderText.length() - 1, tableNameFont);
        topLeftCell.setCellValue((RichTextString)dtHeader);
        Cursor endPosition = startPosition = startPosition.moveDown(headerSettings.getHeight());
        if (CollectionUtils.isNotEmpty((Collection)fields)) {
            for (FieldModel fm : fields) {
                String fieldName = fm.getName();
                String formattedName = fieldName.equals(KEYWORD) ? "result" : this.formatName(fieldName);
                Cursor next = endPosition.moveDown(1);
                Cell subheaderCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
                subheaderCell.setCellValue(fieldName);
                subheaderCell.setCellStyle(subheaderStyle);
                next = next.moveDown(1);
                Cell columnHeaderCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
                columnHeaderCell.setCellValue(formattedName);
                columnHeaderCell.setCellStyle(style.getColumnHeaderStyle());
                next = next.moveDown(1);
                Cell rowCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
                DefaultValueCellWriter.writeDefaultValueToCell((Model)model, fm, rowCell, dateStyle, dateTimeStyle);
                CellStyle styleAfterWrite = rowCell.getCellStyle();
                if (styleAfterWrite.getDataFormat() == 0) {
                    rowCell.setCellStyle(style.getRowStyle().getValueStyle());
                }
                endPosition = next.moveUp(3).moveRight(1);
            }
        }
        endPosition = width > 0 ? endPosition.moveDown(3).moveLeft(width + 1) : endPosition.moveDown(3).setColumn(1);
        return new Cursor(endPosition.getColumn(), endPosition.getRow());
    }

    private String formatName(String fieldName) {
        return StringUtils.join((Iterable)Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)fieldName)).map(StringUtils::capitalize).collect(Collectors.toList()), (char)' ');
    }

    @Override
    protected String getExcelSheetName() {
        return DATA_SHEET;
    }
}

