/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.excel.builder.export;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.openl.rules.excel.builder.CellRangeSettings;
import org.openl.rules.excel.builder.export.AbstractOpenlTableExporter;
import org.openl.rules.excel.builder.export.Cursor;
import org.openl.rules.excel.builder.template.SpreadsheetTableStyleImpl;
import org.openl.rules.excel.builder.template.TableStyle;
import org.openl.rules.model.scaffolding.SpreadsheetModel;
import org.openl.rules.model.scaffolding.StepModel;
import org.openl.rules.table.xls.PoiExcelHelper;

public class SpreadsheetResultTableExporter
extends AbstractOpenlTableExporter<SpreadsheetModel> {
    public static final String SPR_RESULT_SHEET = "SpreadsheetResults";
    public static final String SPREADSHEET_RESULT_NAME_TEMPLATE = "\\{spr.name}";
    public static final String SPREADSHEET_RESULT_RETURN_TYPE = "\\{spr.return.type}";
    public static final String SPREADSHEET_RESULT_SIGNATURE = "\\{spr.signature}";
    public static final String SPREADSHEET_RESULT_STEP_NAME = "\\{spr.field.name}";
    public static final String SPREADSHEET_RESULT_STEP_VALUE = "\\{spr.field.value}";

    @Override
    protected void exportTables(Collection<SpreadsheetModel> models, Sheet sheet) {
        Cursor endPosition = null;
        TableStyle style = this.getTableStyle();
        for (SpreadsheetModel model : models) {
            Cursor startPosition = this.nextFreePosition(endPosition);
            endPosition = this.exportTable(model, startPosition, style, sheet);
        }
    }

    @Override
    protected Cursor exportTable(SpreadsheetModel model, Cursor startPosition, TableStyle defaultStyle, Sheet sheet) {
        SpreadsheetTableStyleImpl style = (SpreadsheetTableStyleImpl)defaultStyle;
        CellStyle headerStyle = style.getHeaderStyle();
        RichTextString tableHeaderText = style.getHeaderTemplate();
        CellRangeSettings headerSettings = style.getHeaderSizeSettings();
        CellStyle stepHeaderStyle = style.getHeaderRowStyle().getNameStyle();
        String stepHeaderText = style.getStepHeaderText();
        CellStyle valueHeaderStyle = style.getHeaderRowStyle().getValueStyle();
        String valueHeaderText = style.getValueHeaderText();
        String sprHeaderText = tableHeaderText.getString().replaceAll(SPREADSHEET_RESULT_RETURN_TYPE, model.getType());
        sprHeaderText = sprHeaderText.replaceAll(SPREADSHEET_RESULT_NAME_TEMPLATE, model.getName());
        String parameters = model.getParameters().stream().map(x -> x.getType().getSimpleName() + " " + x.getFormattedName()).collect(Collectors.joining(", "));
        sprHeaderText = sprHeaderText.replaceAll(SPREADSHEET_RESULT_SIGNATURE, parameters);
        this.addMergedHeader(sheet, startPosition, headerStyle, headerSettings);
        Cell topLeftCell = PoiExcelHelper.getOrCreateCell((int)startPosition.getColumn(), (int)startPosition.getRow(), (Sheet)sheet);
        topLeftCell.setCellValue(sprHeaderText);
        startPosition = startPosition.moveDown(headerSettings.getHeight() + 1);
        Cell stepHeaderCell = PoiExcelHelper.getOrCreateCell((int)startPosition.getColumn(), (int)startPosition.getRow(), (Sheet)sheet);
        stepHeaderCell.setCellValue(stepHeaderText);
        stepHeaderCell.setCellStyle(stepHeaderStyle);
        startPosition = startPosition.moveRight(1);
        Cell valueHeaderCell = PoiExcelHelper.getOrCreateCell((int)startPosition.getColumn(), (int)startPosition.getRow(), (Sheet)sheet);
        valueHeaderCell.setCellValue(valueHeaderText);
        valueHeaderCell.setCellStyle(valueHeaderStyle);
        Cursor endPosition = startPosition = startPosition.moveLeft(1);
        Iterator iterator = model.getSteps().iterator();
        while (iterator.hasNext()) {
            StepModel step = (StepModel)iterator.next();
            boolean lastRow = false;
            if (!iterator.hasNext()) {
                lastRow = true;
            }
            Cursor next = endPosition.moveDown(1);
            Cell stepNameCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
            stepNameCell.setCellValue(step.getName());
            stepNameCell.setCellStyle(lastRow ? style.getLastRowStyle().getNameStyle() : style.getRowStyle().getNameStyle());
            next = next.moveRight(1);
            Cell stepValueCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
            stepValueCell.setCellStyle(lastRow ? style.getLastRowStyle().getValueStyle() : style.getRowStyle().getValueStyle());
            stepValueCell.setCellValue(step.getValue());
            endPosition = next.moveLeft(1);
        }
        return new Cursor(endPosition.getColumn(), endPosition.getRow());
    }

    @Override
    protected String getExcelSheetName() {
        return SPR_RESULT_SHEET;
    }
}

