/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.excel.builder.export;

import java.util.Objects;

public class Cursor {
    private final int column;
    private final int row;

    public Cursor(int column, int row) {
        this.column = column;
        this.row = row;
    }

    public Cursor moveLeft(int x) {
        return new Cursor(this.column - x, this.row);
    }

    public Cursor moveRight(int x) {
        return new Cursor(this.column + x, this.row);
    }

    public Cursor moveDown(int y) {
        return new Cursor(this.column, this.row + y);
    }

    public Cursor moveUp(int y) {
        return new Cursor(this.column, this.row - y);
    }

    public Cursor setColumn(int x) {
        return new Cursor(x, this.row);
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cursor cursor = (Cursor)o;
        return this.column == cursor.column && this.row == cursor.row;
    }

    public int hashCode() {
        return Objects.hash(this.column, this.row);
    }
}

