/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.excel.builder.export;

import java.util.Collection;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openl.rules.excel.builder.CellRangeSettings;
import org.openl.rules.excel.builder.export.AbstractOpenlTableExporter;
import org.openl.rules.excel.builder.export.Cursor;
import org.openl.rules.excel.builder.export.DefaultValueCellWriter;
import org.openl.rules.excel.builder.template.DataTypeTableStyle;
import org.openl.rules.excel.builder.template.TableStyle;
import org.openl.rules.model.scaffolding.DatatypeModel;
import org.openl.rules.model.scaffolding.FieldModel;
import org.openl.rules.model.scaffolding.Model;
import org.openl.rules.table.xls.PoiExcelHelper;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeTableExporter
extends AbstractOpenlTableExporter<DatatypeModel> {
    private final Logger LOGGER = LoggerFactory.getLogger(DatatypeTableExporter.class);
    public static final String DATATYPES_SHEET = "Datatypes";
    public static final String DATATYPE_NAME = "\\{datatype.name}";

    @Override
    protected void exportTables(Collection<DatatypeModel> models, Sheet sheet) {
        Cursor endPosition = null;
        TableStyle style = this.getTableStyle();
        for (DatatypeModel model : models) {
            this.LOGGER.debug("Writing data type with name {}", (Object)model.getName());
            Cursor startPosition = this.nextFreePosition(endPosition);
            endPosition = this.exportTable(model, startPosition, style, sheet);
        }
    }

    @Override
    protected Cursor exportTable(DatatypeModel model, Cursor startPosition, TableStyle defaultStyle, Sheet sheet) {
        DataTypeTableStyle style = (DataTypeTableStyle)defaultStyle;
        RichTextString headerTemplate = style.getHeaderTemplate();
        CellRangeSettings headerSettings = style.getHeaderSizeSettings();
        CellStyle headerStyle = style.getHeaderStyle();
        CellStyle dateStyle = style.getDateStyle();
        CellStyle dateTimeStyle = style.getDateTimeStyle();
        Object dtHeaderText = headerTemplate.getString().replaceAll(DATATYPE_NAME, model.getName());
        if (StringUtils.isNotBlank((CharSequence)model.getParent())) {
            dtHeaderText = (String)dtHeaderText + " extends " + model.getParent();
        }
        this.addMergedHeader(sheet, startPosition, headerStyle, headerSettings);
        Cell topLeftCell = PoiExcelHelper.getOrCreateCell((int)startPosition.getColumn(), (int)startPosition.getRow(), (Sheet)sheet);
        XSSFRichTextString dtHeader = new XSSFRichTextString((String)dtHeaderText);
        dtHeader.applyFont(style.getHeaderFont());
        topLeftCell.setCellValue((RichTextString)dtHeader);
        Cursor endPosition = startPosition = startPosition.moveDown(headerSettings.getHeight());
        Iterator iterator = model.getFields().iterator();
        while (iterator.hasNext()) {
            boolean lastRow = false;
            FieldModel field = (FieldModel)iterator.next();
            if (!iterator.hasNext()) {
                lastRow = true;
            }
            Cursor next = endPosition.moveDown(1);
            Cell typeCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
            String type = field.getType();
            typeCell.setCellValue(type);
            typeCell.setCellStyle(lastRow ? style.getLastRowStyle().getTypeStyle() : style.getRowStyle().getTypeStyle());
            next = next.moveRight(1);
            Cell nameCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
            nameCell.setCellValue(field.getName());
            nameCell.setCellStyle(lastRow ? style.getLastRowStyle().getNameStyle() : style.getRowStyle().getNameStyle());
            next = next.moveRight(1);
            Cell valueCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
            DefaultValueCellWriter.writeDefaultValueToCell((Model)model, field, valueCell, dateStyle, dateTimeStyle);
            CellStyle styleAfterWrite = valueCell.getCellStyle();
            if (styleAfterWrite.getDataFormat() == 0) {
                valueCell.setCellStyle(lastRow ? style.getLastRowStyle().getValueStyle() : style.getRowStyle().getValueStyle());
            }
            endPosition = next.moveLeft(2);
        }
        return new Cursor(endPosition.getColumn(), endPosition.getRow());
    }

    @Override
    protected String getExcelSheetName() {
        return DATATYPES_SHEET;
    }
}

