/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.excel.builder.export;

import java.util.Collection;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.openl.rules.excel.builder.CellRangeSettings;
import org.openl.rules.excel.builder.OpenlTableWriter;
import org.openl.rules.excel.builder.export.Cursor;
import org.openl.rules.excel.builder.template.TableStyle;
import org.openl.rules.model.scaffolding.Model;
import org.openl.rules.table.xls.PoiExcelHelper;

public abstract class AbstractOpenlTableExporter<T extends Model>
implements OpenlTableWriter<T> {
    public static final Cursor TOP_LEFT_POSITION = new Cursor(1, 2);
    public static final int DEFAULT_MARGIN = 3;
    public static final String DEFAULT_STRING_VALUE = "_DEFAULT_";
    private TableStyle tableStyle;

    @Override
    public Sheet export(Collection<T> models, Sheet sheet) {
        if (models == null || models.isEmpty()) {
            return null;
        }
        this.exportTables(models, sheet);
        return sheet;
    }

    protected void exportTables(Collection<T> models, Sheet sheet) {
        Cursor startPosition = this.getStartPosition();
        for (Model table : models) {
            Cursor endPosition = this.exportTable(table, startPosition, this.getTableStyle(), sheet);
            startPosition = startPosition.equals(endPosition) ? startPosition : this.nextFreePosition(endPosition);
        }
    }

    public void addMergedHeader(Sheet sheet, Cursor cursor, CellStyle style, CellRangeSettings cellRangeSettings) {
        CellRangeAddress mergedRegion = new CellRangeAddress(cursor.getRow(), cursor.getRow() + cellRangeSettings.getHeight(), cursor.getColumn(), cursor.getColumn() + cellRangeSettings.getWidth());
        if (cellRangeSettings.getHeight() > 0 || cellRangeSettings.getWidth() > 0) {
            sheet.addMergedRegionUnsafe(mergedRegion);
        }
        for (int i = mergedRegion.getFirstRow(); i <= mergedRegion.getLastRow(); ++i) {
            for (int j = mergedRegion.getFirstColumn(); j <= mergedRegion.getLastColumn(); ++j) {
                Cell sheetCell = PoiExcelHelper.getOrCreateCell((int)j, (int)i, (Sheet)sheet);
                sheetCell.setCellStyle(style);
            }
        }
    }

    protected abstract Cursor exportTable(T var1, Cursor var2, TableStyle var3, Sheet var4);

    protected abstract String getExcelSheetName();

    protected Cursor getStartPosition() {
        return TOP_LEFT_POSITION;
    }

    protected Cursor nextFreePosition(Cursor endPosition) {
        if (endPosition == null) {
            return TOP_LEFT_POSITION;
        }
        return new Cursor(endPosition.getColumn(), endPosition.getRow() + 3);
    }

    public TableStyle getTableStyle() {
        return this.tableStyle;
    }

    public void setTableStyle(TableStyle tableStyle) {
        this.tableStyle = tableStyle;
    }
}

