/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.excel.builder.export;

import java.util.Collection;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.openl.rules.excel.builder.CellRangeSettings;
import org.openl.rules.excel.builder.export.AbstractOpenlTableExporter;
import org.openl.rules.excel.builder.export.Cursor;
import org.openl.rules.excel.builder.template.EnvironmentTableStyleImpl;
import org.openl.rules.excel.builder.template.TableStyle;
import org.openl.rules.model.scaffolding.environment.EnvironmentModel;
import org.openl.rules.table.xls.PoiExcelHelper;

public class EnvironmentTableExporter
extends AbstractOpenlTableExporter<EnvironmentModel> {
    public static final String ENV_SHEET = "Environment";
    public static final String IMPORT = "import";
    public static final String DEPENDENCY = "dependency";

    @Override
    protected void exportTables(Collection<EnvironmentModel> models, Sheet sheet) {
        Cursor endPosition = null;
        TableStyle style = this.getTableStyle();
        for (EnvironmentModel model : models) {
            Cursor startPosition = this.nextFreePosition(endPosition);
            endPosition = this.exportTable(model, startPosition, style, sheet);
        }
    }

    @Override
    protected Cursor exportTable(EnvironmentModel model, Cursor startPosition, TableStyle tableStyle, Sheet sheet) {
        EnvironmentTableStyleImpl style = (EnvironmentTableStyleImpl)tableStyle;
        RichTextString headerText = style.getHeaderTemplate();
        CellRangeSettings headerSizeSettings = style.getHeaderSizeSettings();
        this.addMergedHeader(sheet, startPosition, style.getHeaderStyle(), headerSizeSettings);
        Cell topLeftCell = PoiExcelHelper.getOrCreateCell((int)startPosition.getColumn(), (int)startPosition.getRow(), (Sheet)sheet);
        topLeftCell.setCellValue(headerText);
        Cursor endPosition = startPosition = startPosition.moveDown(headerSizeSettings.getHeight());
        Iterator<String> dpdIterator = model.getDependencies().iterator();
        Iterator<String> importIterator = model.getImports().iterator();
        endPosition = this.writeData(sheet, style, endPosition, dpdIterator, DEPENDENCY);
        endPosition = endPosition.moveRight(1);
        endPosition = this.writeData(sheet, style, endPosition, importIterator, IMPORT);
        return new Cursor(endPosition.getColumn(), endPosition.getRow());
    }

    private Cursor writeData(Sheet sheet, EnvironmentTableStyleImpl style, Cursor endPosition, Iterator<String> importIterator, String anImport) {
        while (importIterator.hasNext()) {
            boolean lastRow = false;
            String dpd = importIterator.next();
            if (!importIterator.hasNext()) {
                lastRow = true;
            }
            Cursor next = endPosition.moveDown(1);
            Cell nameCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
            nameCell.setCellValue(anImport);
            nameCell.setCellStyle(lastRow ? style.getLastRowStyle().getNameStyle() : style.getRowStyle().getNameStyle());
            next = next.moveRight(1);
            Cell valueCell = PoiExcelHelper.getOrCreateCell((int)next.getColumn(), (int)next.getRow(), (Sheet)sheet);
            valueCell.setCellValue(dpd);
            valueCell.setCellStyle(lastRow ? style.getLastRowStyle().getValueStyle() : style.getRowStyle().getValueStyle());
            endPosition = next.moveLeft(1);
        }
        return endPosition.moveLeft(1);
    }

    @Override
    protected String getExcelSheetName() {
        return ENV_SHEET;
    }
}

