/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.excel.builder.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.rules.excel.builder.CellRangeSettings;
import org.openl.rules.excel.builder.template.DataTableStyleImpl;
import org.openl.rules.excel.builder.template.DataTypeTableStyleImpl;
import org.openl.rules.excel.builder.template.EnvironmentTableStyleImpl;
import org.openl.rules.excel.builder.template.SpreadsheetTableStyleImpl;
import org.openl.rules.excel.builder.template.TableStyle;
import org.openl.rules.excel.builder.template.row.DataTypeTableRowStyleImpl;
import org.openl.rules.excel.builder.template.row.NameValueRowStyle;
import org.openl.rules.excel.builder.template.row.NameValueRowStyleImpl;
import org.openl.rules.excel.builder.template.row.SpreadsheetTableRowStyleImpl;
import org.openl.rules.table.xls.PoiExcelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelTemplateUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelTemplateUtils.class);
    public static final byte LEFT_MARGIN = 1;
    public static final byte TOP_MARGIN = 2;
    public static final String DATATYPE_DEFINITION = "{datatype.name}";
    public static final String DATA_TABLE_NAME = "{table.name}";
    public static final String DATA_TABLE_TYPE = "{returnType}";
    public static final short DATE_TIME_FORMAT = (short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy h:mm");
    public static final short DATE_FORMAT = (short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy");

    private ExcelTemplateUtils() {
    }

    public static SXSSFWorkbook getTemplate() throws IOException {
        ClassLoader classLoader = ExcelTemplateUtils.class.getClassLoader();
        XSSFWorkbook template = new XSSFWorkbook(classLoader.getResourceAsStream("template.xlsx"));
        int sheets = template.getNumberOfSheets();
        for (int i = 0; i < sheets; ++i) {
            template.removeSheetAt(0);
        }
        return new SXSSFWorkbook(template);
    }

    public static Map<String, TableStyle> extractTemplateInfo(Workbook targetWorkbook) {
        HashMap<String, TableStyle> templateStyles = new HashMap<String, TableStyle>();
        ClassLoader classLoader = ExcelTemplateUtils.class.getClassLoader();
        try (OPCPackage fs = OPCPackage.open((InputStream)Objects.requireNonNull(classLoader.getResourceAsStream("template.xlsx"), "Template wasn't found."));){
            XSSFWorkbook wb = new XSSFWorkbook(fs);
            XSSFSheet dataTypeSheet = wb.getSheet("Datatypes");
            if (dataTypeSheet == null) {
                logger.error("Datatype sheet template wasn't found.");
            }
            TableStyle dataTypeStyle = ExcelTemplateUtils.extractDatatypeStyle((Sheet)dataTypeSheet, targetWorkbook);
            templateStyles.put("Datatypes", dataTypeStyle);
            XSSFSheet sprResultSheet = wb.getSheet("SpreadsheetResults");
            if (sprResultSheet == null) {
                logger.error("SpreadSheetResults sheet template wasn't found.");
            }
            TableStyle spreadSheetStyle = ExcelTemplateUtils.extractSpreadSheetResultStyle((Sheet)sprResultSheet, targetWorkbook);
            templateStyles.put("SpreadsheetResults", spreadSheetStyle);
            XSSFSheet environmentSheet = wb.getSheet("Environment");
            if (environmentSheet == null) {
                logger.error("Environment sheet template wasn't found.");
            }
            TableStyle envStyle = ExcelTemplateUtils.extractEnvStyle((Sheet)environmentSheet, targetWorkbook);
            templateStyles.put("Environment", envStyle);
            XSSFSheet dataSheet = wb.getSheet("Data Table");
            if (dataSheet == null) {
                logger.error("Data table template wasn't found.");
            }
            TableStyle dataStyle = ExcelTemplateUtils.extractDataTableStyle((Sheet)dataSheet, targetWorkbook);
            templateStyles.put("Data Table", dataStyle);
        }
        catch (InvalidFormatException e) {
            logger.error("Invalid format exception occurred.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("There was a problem with reading the template file.", (Throwable)e);
        }
        return templateStyles;
    }

    private static TableStyle extractSpreadSheetResultStyle(Sheet sprResultSheet, Workbook targetWorkbook) {
        Cell sprResultHeader = ExcelTemplateUtils.extractTableHeader(sprResultSheet);
        CellStyle targetTableHeaderStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, sprResultHeader);
        RichTextString sprTableHeaderText = sprResultHeader.getRichStringCellValue();
        CellRangeAddress headerRegion = sprResultSheet.getMergedRegion(0);
        CellRangeSettings headerSettings = new CellRangeSettings(headerRegion);
        Row sprColumnHeaders = sprResultSheet.getRow(3);
        Cell sprStepHeader = sprColumnHeaders.getCell(1);
        Cell sprValueHeader = sprColumnHeaders.getCell(2);
        CellStyle targetStepHeaderStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, sprStepHeader);
        CellStyle targetValueHeaderStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, sprValueHeader);
        String stepHeader = sprStepHeader.getStringCellValue();
        String valueHeader = sprValueHeader.getStringCellValue();
        SpreadsheetTableRowStyleImpl headerRowStyle = new SpreadsheetTableRowStyleImpl(targetStepHeaderStyle, targetValueHeaderStyle);
        Row sprFieldRow = sprResultSheet.getRow(4);
        Cell sprFieldName = sprFieldRow.getCell(1);
        CellStyle targetFieldStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, sprFieldName);
        Cell sprFieldValue = sprFieldRow.getCell(2);
        CellStyle targetValueStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, sprFieldValue);
        SpreadsheetTableRowStyleImpl rowStyle = new SpreadsheetTableRowStyleImpl(targetFieldStyle, targetValueStyle);
        CellStyle dateStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, sprFieldValue);
        dateStyle.setDataFormat(DATE_FORMAT);
        CellStyle dateTimeStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, sprFieldValue);
        dateTimeStyle.setDataFormat(DATE_TIME_FORMAT);
        Row lastSprRow = sprResultSheet.getRow(5);
        Cell lastFieldName = lastSprRow.getCell(1);
        CellStyle targetLastFieldStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, lastFieldName);
        Cell lastFieldValue = lastSprRow.getCell(2);
        CellStyle targetLastValueStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, lastFieldValue);
        SpreadsheetTableRowStyleImpl lastRowStyle = new SpreadsheetTableRowStyleImpl(targetLastFieldStyle, targetLastValueStyle);
        return new SpreadsheetTableStyleImpl(sprTableHeaderText, targetTableHeaderStyle, headerSettings, headerRowStyle, stepHeader, valueHeader, rowStyle, lastRowStyle, dateStyle, dateTimeStyle);
    }

    private static TableStyle extractDatatypeStyle(Sheet dataTypeSheet, Workbook targetWorkbook) {
        Cell datatypeHeaderCell = ExcelTemplateUtils.extractTableHeader(dataTypeSheet);
        CellRangeAddress headerRegion = dataTypeSheet.getMergedRegion(0);
        CellRangeSettings headerSettings = new CellRangeSettings(headerRegion);
        CellStyle targetHeaderStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, datatypeHeaderCell);
        RichTextString headerValueString = datatypeHeaderCell.getRichStringCellValue();
        String headerText = headerValueString.getString();
        int start = headerText.indexOf(DATATYPE_DEFINITION);
        XSSFFont datatypeFont = ((XSSFRichTextString)headerValueString).getFontAtIndex(start);
        Font targetFont = ExcelTemplateUtils.copyFont(targetWorkbook, (Font)datatypeFont);
        Row datatypeFieldRow = dataTypeSheet.getRow(3);
        Cell dtFieldClass = datatypeFieldRow.getCell(1);
        CellStyle targetClassStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, dtFieldClass);
        Cell dtFieldName = datatypeFieldRow.getCell(2);
        CellStyle targetNameStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, dtFieldName);
        Cell datatypeDefaultValueCell = datatypeFieldRow.getCell(3);
        CellStyle dvStyle = datatypeDefaultValueCell.getCellStyle();
        CellStyle targetDefaultValueStyle = ExcelTemplateUtils.copyStyle(targetWorkbook, dvStyle);
        CellStyle dateStyle = ExcelTemplateUtils.copyStyle(targetWorkbook, dvStyle);
        dateStyle.setDataFormat(DATE_FORMAT);
        CellStyle dateTimeStyle = ExcelTemplateUtils.copyStyle(targetWorkbook, dvStyle);
        dateTimeStyle.setDataFormat(DATE_TIME_FORMAT);
        DataTypeTableRowStyleImpl rowStyle = new DataTypeTableRowStyleImpl(targetClassStyle, targetNameStyle, targetDefaultValueStyle);
        Row lastDataTypeRow = dataTypeSheet.getRow(4);
        Cell dtLastFieldClassStyle = lastDataTypeRow.getCell(1);
        CellStyle targetLastClassStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, dtLastFieldClassStyle);
        Cell dtLastFieldNameStyle = lastDataTypeRow.getCell(2);
        CellStyle targetLastFieldNameStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, dtLastFieldNameStyle);
        Cell dtLastDefaultValueCell = lastDataTypeRow.getCell(3);
        CellStyle targetLastDefaultValueStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, dtLastDefaultValueCell);
        DataTypeTableRowStyleImpl lastRowStyle = new DataTypeTableRowStyleImpl(targetLastClassStyle, targetLastFieldNameStyle, targetLastDefaultValueStyle);
        return new DataTypeTableStyleImpl(headerValueString, targetHeaderStyle, headerSettings, rowStyle, dateStyle, dateTimeStyle, lastRowStyle, targetFont);
    }

    private static Font copyFont(Workbook targetWorkbook, Font sourceFont) {
        Font targetFont = targetWorkbook.createFont();
        targetFont.setBold(sourceFont.getBold());
        targetFont.setFontHeight(sourceFont.getFontHeight());
        targetFont.setColor(sourceFont.getColor());
        targetFont.setFontName(sourceFont.getFontName());
        targetFont.setItalic(sourceFont.getItalic());
        return targetFont;
    }

    private static TableStyle extractEnvStyle(Sheet envSheet, Workbook targetWorkbook) {
        Cell envHeaderCell = ExcelTemplateUtils.extractTableHeader(envSheet);
        CellStyle targetTableHeaderStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, envHeaderCell);
        RichTextString envHeaderText = envHeaderCell.getRichStringCellValue();
        CellRangeAddress headerRegion = envSheet.getMergedRegion(0);
        CellRangeSettings headerSettings = new CellRangeSettings(headerRegion);
        Row regularRow = envSheet.getRow(3);
        NameValueRowStyle regularRowStyle = ExcelTemplateUtils.extractRowStyle(targetWorkbook, regularRow);
        Row lastRow = envSheet.getRow(4);
        NameValueRowStyle lastRowStyle = ExcelTemplateUtils.extractRowStyle(targetWorkbook, lastRow);
        return new EnvironmentTableStyleImpl(envHeaderText, targetTableHeaderStyle, headerSettings, regularRowStyle, lastRowStyle);
    }

    private static TableStyle extractDataTableStyle(Sheet dataSheet, Workbook targetWorkbook) {
        Cell dataTableHeader = ExcelTemplateUtils.extractTableHeader(dataSheet);
        CellStyle targetHeaderStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, dataTableHeader);
        CellRangeAddress headerRegion = dataSheet.getMergedRegion(0);
        CellRangeSettings headerSettings = new CellRangeSettings(headerRegion);
        XSSFRichTextString headerText = (XSSFRichTextString)dataTableHeader.getRichStringCellValue();
        String headerTextString = headerText.getString();
        XSSFFont sourceTypeFont = headerText.getFontAtIndex(headerTextString.indexOf(DATA_TABLE_TYPE));
        XSSFFont sourceTableNameFont = headerText.getFontAtIndex(headerTextString.indexOf(DATA_TABLE_NAME));
        Font typeFont = ExcelTemplateUtils.copyFont(targetWorkbook, (Font)sourceTypeFont);
        Font tableNameFont = ExcelTemplateUtils.copyFont(targetWorkbook, (Font)sourceTableNameFont);
        Row subheaderRow = dataSheet.getRow(3);
        Cell subheaderCell = subheaderRow.getCell(1);
        CellStyle targetSubheaderStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, subheaderCell);
        Row columnHeaderRow = dataSheet.getRow(4);
        Cell columnHeaderCell = columnHeaderRow.getCell(1);
        CellStyle columnHeaderStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, columnHeaderCell);
        Row valueRow = dataSheet.getRow(5);
        Cell valueCell = valueRow.getCell(1);
        CellStyle valueCellStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, valueCell);
        CellStyle dateFieldStyle = ExcelTemplateUtils.copyStyle(targetWorkbook, valueCellStyle);
        dateFieldStyle.setDataFormat(DATE_FORMAT);
        CellStyle dateTimeFieldStyle = ExcelTemplateUtils.copyStyle(targetWorkbook, valueCellStyle);
        dateFieldStyle.setDataFormat(DATE_TIME_FORMAT);
        return new DataTableStyleImpl((RichTextString)headerText, targetHeaderStyle, headerSettings, typeFont, tableNameFont, targetSubheaderStyle, columnHeaderStyle, new NameValueRowStyleImpl(valueCellStyle, valueCellStyle), dateFieldStyle, dateTimeFieldStyle);
    }

    private static NameValueRowStyle extractRowStyle(Workbook targetWorkbook, Row regularRow) {
        Cell regularNameCell = regularRow.getCell(1);
        CellStyle targetNameStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, regularNameCell);
        Cell regularValueCell = regularRow.getCell(2);
        CellStyle targetValueStyle = ExcelTemplateUtils.copyCellStyle(targetWorkbook, regularValueCell);
        return new NameValueRowStyleImpl(targetNameStyle, targetValueStyle);
    }

    private static CellStyle copyCellStyle(Workbook targetWorkbook, Cell sourceCell) {
        CellStyle classStyle = sourceCell.getCellStyle();
        return ExcelTemplateUtils.copyStyle(targetWorkbook, classStyle);
    }

    private static Cell extractTableHeader(Sheet dataTypeSheet) {
        Row datatypeHeaderRow = dataTypeSheet.getRow(2);
        return datatypeHeaderRow.getCell(1);
    }

    private static CellStyle copyStyle(Workbook targetWorkbook, CellStyle style) {
        CellStyle targetFieldStyle = PoiExcelHelper.createCellStyle((Workbook)targetWorkbook);
        targetFieldStyle.cloneStyleFrom(style);
        return targetFieldStyle;
    }
}

