/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.model.scaffolding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openl.rules.model.scaffolding.DatatypeModel;
import org.openl.rules.model.scaffolding.MethodModel;
import org.openl.rules.model.scaffolding.SpreadsheetModel;
import org.openl.rules.model.scaffolding.data.DataModel;

public class ProjectModel {
    private String name;
    private boolean isRuntimeContextProvided;
    private boolean variationsProvided;
    private Set<DatatypeModel> datatypeModels = new HashSet<DatatypeModel>();
    private List<SpreadsheetModel> spreadsheetModels;
    private List<DataModel> dataModels = new ArrayList<DataModel>();
    private Set<String> includeMethodFilter;
    private List<SpreadsheetModel> notOpenLModels = new ArrayList<SpreadsheetModel>();

    public ProjectModel() {
    }

    public ProjectModel(String name, boolean isRuntimeContextProvided, boolean variationsProvided, Set<DatatypeModel> datatypeModels, List<DataModel> dataModels, List<SpreadsheetModel> spreadsheetModels, List<SpreadsheetModel> modelsForInterface) {
        this.name = name;
        this.isRuntimeContextProvided = isRuntimeContextProvided;
        this.variationsProvided = variationsProvided;
        this.datatypeModels = datatypeModels;
        this.dataModels = dataModels;
        this.spreadsheetModels = Optional.ofNullable(spreadsheetModels).orElseGet(Collections::emptyList);
        this.notOpenLModels = modelsForInterface;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<DatatypeModel> getDatatypeModels() {
        return this.datatypeModels;
    }

    public List<SpreadsheetModel> getSpreadsheetResultModels() {
        return this.spreadsheetModels;
    }

    public boolean isRuntimeContextProvided() {
        return this.isRuntimeContextProvided;
    }

    public boolean areVariationsProvided() {
        return this.variationsProvided;
    }

    public List<SpreadsheetModel> getNotOpenLModels() {
        return this.notOpenLModels;
    }

    public List<DataModel> getDataModels() {
        return this.dataModels;
    }

    public Set<String> getIncludeMethodFilter() {
        if (this.includeMethodFilter == null) {
            this.includeMethodFilter = Stream.concat(this.spreadsheetModels.stream(), this.dataModels.stream()).filter(MethodModel::isInclude).map(MethodModel::getMethodFilterPattern).collect(Collectors.toSet());
        }
        return this.includeMethodFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectModel that = (ProjectModel)o;
        if (this.isRuntimeContextProvided != that.isRuntimeContextProvided) {
            return false;
        }
        if (this.variationsProvided != that.variationsProvided) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.datatypeModels, that.datatypeModels)) {
            return false;
        }
        if (!Objects.equals(this.dataModels, that.dataModels)) {
            return false;
        }
        if (!Objects.equals(this.spreadsheetModels, that.spreadsheetModels)) {
            return false;
        }
        return Objects.equals(this.notOpenLModels, that.notOpenLModels);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.isRuntimeContextProvided ? 1 : 0);
        result = 31 * result + (this.variationsProvided ? 1 : 0);
        result = 31 * result + (this.datatypeModels != null ? this.datatypeModels.hashCode() : 0);
        result = 31 * result + (this.dataModels != null ? this.dataModels.hashCode() : 0);
        result = 31 * result + (this.spreadsheetModels != null ? this.spreadsheetModels.hashCode() : 0);
        result = 31 * result + (this.notOpenLModels != null ? this.notOpenLModels.hashCode() : 0);
        return result;
    }
}

