/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.model.scaffolding;

import java.util.Objects;

public class TypeInfo {
    private String javaName;
    private final String simpleName;
    private Type type;
    private int dimension;
    private final boolean reference;

    public TypeInfo(Class<?> javaName) {
        this(javaName, javaName.isPrimitive() ? Type.PRIMITIVE : Type.OBJECT);
    }

    public TypeInfo(Class<?> javaName, Type type) {
        this(javaName.getName(), javaName.getSimpleName(), type);
    }

    public TypeInfo(String javaName, String simpleName, Type type) {
        this.javaName = javaName;
        this.simpleName = simpleName;
        this.type = type;
        this.reference = false;
    }

    public TypeInfo(String javaName, String simpleName, boolean reference, int dimension) {
        this.javaName = javaName;
        this.simpleName = simpleName;
        this.reference = reference;
        this.dimension = dimension;
    }

    public TypeInfo(String javaName, String simpleName, Type type, int dimension, boolean reference) {
        this.javaName = javaName;
        this.simpleName = simpleName;
        this.type = type;
        this.dimension = dimension;
        this.reference = reference;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isReference() {
        return this.reference;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)o;
        return this.type == typeInfo.type && Objects.equals(this.javaName, typeInfo.javaName) && Objects.equals(this.simpleName, typeInfo.simpleName) && Objects.equals(this.dimension, typeInfo.dimension) && Objects.equals(this.reference, typeInfo.reference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.javaName, this.simpleName, this.type, this.dimension, this.reference});
    }

    public static enum Type {
        RUNTIMECONTEXT,
        SPREADSHEET,
        DATATYPE,
        OBJECT,
        PRIMITIVE;

    }
}

