/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.openapi.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;

public class JavaClassFile {
    private final String javaNameWithPackage;
    private final String path;
    private final byte[] byteCode;

    public JavaClassFile(String javaNameWithPackage, byte[] byteCode) {
        this.javaNameWithPackage = Objects.requireNonNull(javaNameWithPackage, "Java Interface name is null.");
        this.path = javaNameWithPackage.replace('.', '/') + ".class";
        this.byteCode = byteCode;
    }

    public String getJavaNameWithPackage() {
        return this.javaNameWithPackage;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getByteCode() {
        return this.byteCode;
    }

    public InputStream toInputStream() {
        return Optional.ofNullable(this.byteCode).map(ByteArrayInputStream::new).orElse(null);
    }

    public boolean isEmpty() {
        return this.byteCode != null && this.byteCode.length > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaClassFile that = (JavaClassFile)o;
        return Objects.equals(this.javaNameWithPackage, that.javaNameWithPackage);
    }

    public int hashCode() {
        return Objects.hash(this.javaNameWithPackage);
    }

    public String toString() {
        return this.javaNameWithPackage;
    }
}

