/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.openapi.impl;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.openl.gen.AnnotationDescriptionBuilder;
import org.openl.gen.InterfaceByteCodeBuilder;
import org.openl.gen.InterfaceImplBuilder;
import org.openl.gen.MethodDescriptionBuilder;
import org.openl.gen.MethodParameterBuilder;
import org.openl.gen.TypeDescription;
import org.openl.rules.model.scaffolding.InputParameter;
import org.openl.rules.model.scaffolding.MethodModel;
import org.openl.rules.model.scaffolding.PathInfo;
import org.openl.rules.model.scaffolding.ProjectModel;
import org.openl.rules.model.scaffolding.TypeInfo;
import org.openl.rules.openapi.impl.GroovyScriptFile;
import org.openl.rules.openapi.impl.OpenAPIGeneratedClasses;
import org.openl.rules.openapi.impl.OpenAPITypeUtils;
import org.openl.rules.ruleservice.core.annotations.Name;
import org.openl.rules.ruleservice.core.annotations.NoTypeConversion;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethod;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethodHandler;
import org.openl.rules.ruleservice.core.interceptors.RulesType;
import org.openl.util.StringUtils;

public class OpenAPIJavaClassGenerator {
    private static final String DEFAULT_JSON_TYPE = "application/json";
    private static final String DEFAULT_SIMPLE_TYPE = "text/plain";
    private static final Class<?> DEFAULT_DATATYPE_CLASS = Object.class;
    public static final String VALUE = "value";
    public static final String DEFAULT_OPEN_API_PATH = "org.openl.generated.services";
    public static final String DEFAULT_RUNTIME_CTX_PARAM_NAME = "runtimeContext";
    private final ProjectModel projectModel;

    public OpenAPIJavaClassGenerator(ProjectModel projectModel) {
        this.projectModel = projectModel;
    }

    private boolean generateDecision(MethodModel method) {
        TypeInfo typeInfo;
        if (!method.isInclude()) {
            return false;
        }
        for (InputParameter inputParameter : method.getParameters()) {
            if (inputParameter.getType().getType() != TypeInfo.Type.SPREADSHEET && inputParameter.getType().getType() != TypeInfo.Type.SPREADSHEET_ARRAY) continue;
            return true;
        }
        PathInfo pathInfo = method.getPathInfo();
        StringBuilder sb = new StringBuilder("/" + pathInfo.getFormattedPath());
        List parameters = method.getParameters();
        parameters.stream().filter(p -> p.getIn() == InputParameter.In.PATH).map(InputParameter::getFormattedName).forEach(name -> sb.append("/{").append((String)name).append('}'));
        if (!pathInfo.getOriginalPath().contentEquals(sb)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)pathInfo.getProduces()) && ((typeInfo = pathInfo.getReturnType()).isReference() || typeInfo.getDimension() > 0 ? !DEFAULT_JSON_TYPE.equals(pathInfo.getProduces()) : !DEFAULT_SIMPLE_TYPE.equals(pathInfo.getProduces()))) {
            return true;
        }
        boolean requestBodyIsPresented = parameters.stream().map(InputParameter::getIn).anyMatch(Objects::isNull);
        boolean otherParamsArePresented = parameters.stream().map(InputParameter::getIn).anyMatch(Objects::nonNull);
        if (requestBodyIsPresented && otherParamsArePresented) {
            return true;
        }
        if (parameters.stream().map(InputParameter::getIn).filter(Objects::nonNull).anyMatch(in -> !InputParameter.In.PATH.equals(in))) {
            return true;
        }
        if (parameters.stream().anyMatch(p -> !p.getFormattedName().equalsIgnoreCase(p.getOriginalName()))) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)pathInfo.getConsumes())) {
            if (this.projectModel.isRuntimeContextProvided()) {
                if (!DEFAULT_JSON_TYPE.equals(pathInfo.getConsumes())) {
                    return true;
                }
                if (!parameters.isEmpty() && pathInfo.getRuntimeContextParameter() != null && !DEFAULT_RUNTIME_CTX_PARAM_NAME.equals(pathInfo.getRuntimeContextParameter().getFormattedName())) {
                    return true;
                }
            } else if (parameters.isEmpty() ? !DEFAULT_SIMPLE_TYPE.equals(pathInfo.getConsumes()) : (parameters.size() == 1 ? (((InputParameter)parameters.get(0)).getType().isReference() || ((InputParameter)parameters.get(0)).getType().getDimension() > 0 ? !DEFAULT_JSON_TYPE.equals(pathInfo.getConsumes()) : !DEFAULT_SIMPLE_TYPE.equals(pathInfo.getConsumes())) : !DEFAULT_JSON_TYPE.equals(pathInfo.getConsumes()))) {
                return true;
            }
        }
        switch (pathInfo.getOperation()) {
            case GET: {
                if (this.projectModel.isRuntimeContextProvided()) {
                    return true;
                }
                if (parameters.size() > 3) {
                    return true;
                }
                if (parameters.stream().allMatch(p -> p.getType().getType() == TypeInfo.Type.PRIMITIVE)) break;
                return true;
            }
            case POST: {
                if (this.projectModel.isRuntimeContextProvided()) break;
                if (parameters.isEmpty()) {
                    return true;
                }
                if (parameters.size() > 3 || !parameters.stream().allMatch(p -> p.getType().getType() == TypeInfo.Type.PRIMITIVE)) break;
                return true;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    public OpenAPIGeneratedClasses generate() {
        String interfaceName = "org.openl.generated.services.Service";
        InterfaceByteCodeBuilder interfaceBuilder = InterfaceByteCodeBuilder.create((String)interfaceName);
        Stream.concat(this.projectModel.getSpreadsheetResultModels().stream(), this.projectModel.getDataModels().stream()).filter(this::generateDecision).map(method -> this.visitInterfaceMethod((MethodModel)method, false).build()).forEach(arg_0 -> ((InterfaceByteCodeBuilder)interfaceBuilder).addAbstractMethod(arg_0));
        OpenAPIGeneratedClasses.Builder builder = OpenAPIGeneratedClasses.Builder.initialize();
        for (MethodModel extraMethod : this.projectModel.getNotOpenLModels()) {
            InterfaceImplBuilder extraMethodBuilder = new InterfaceImplBuilder(ServiceExtraMethodHandler.class, DEFAULT_OPEN_API_PATH);
            GroovyScriptFile groovyScriptFile = new GroovyScriptFile(extraMethodBuilder.getScriptName(), extraMethodBuilder.scriptText());
            builder.addGroovyCommonScript(groovyScriptFile);
            MethodDescriptionBuilder methodDesc = this.visitInterfaceMethod(extraMethod, true);
            methodDesc.addAnnotation(AnnotationDescriptionBuilder.create(ServiceExtraMethod.class).withProperty(VALUE, new TypeDescription(groovyScriptFile.getNameWithPackage())).build());
            interfaceBuilder.addAbstractMethod(methodDesc.build());
        }
        if (!interfaceBuilder.isEmpty()) {
            builder.setGroovyScriptFile(new GroovyScriptFile(interfaceName, interfaceBuilder.buildGroovy().generatedText()));
        }
        return builder.build();
    }

    private MethodDescriptionBuilder visitInterfaceMethod(MethodModel sprModel, boolean extraMethod) {
        PathInfo pathInfo = sprModel.getPathInfo();
        TypeInfo returnTypeInfo = pathInfo.getReturnType();
        MethodDescriptionBuilder methodBuilder = MethodDescriptionBuilder.create((String)pathInfo.getFormattedPath(), (String)OpenAPIJavaClassGenerator.resolveType(returnTypeInfo));
        InputParameter runtimeCtxParam = sprModel.getPathInfo().getRuntimeContextParameter();
        if (runtimeCtxParam != null) {
            MethodParameterBuilder ctxBuilder = MethodParameterBuilder.create((String)runtimeCtxParam.getType().getJavaName());
            String paramName = runtimeCtxParam.getFormattedName();
            if (sprModel.getParameters().size() > 0 && !DEFAULT_RUNTIME_CTX_PARAM_NAME.equals(paramName)) {
                ctxBuilder.addAnnotation(AnnotationDescriptionBuilder.create(Name.class).withProperty(VALUE, (Object)paramName).build());
            }
            methodBuilder.addParameter(ctxBuilder.build());
        }
        for (InputParameter parameter : sprModel.getParameters()) {
            methodBuilder.addParameter(this.visitMethodParameter(parameter, extraMethod));
        }
        if (returnTypeInfo.getType() == TypeInfo.Type.DATATYPE) {
            methodBuilder.addAnnotation(AnnotationDescriptionBuilder.create(RulesType.class).withProperty(VALUE, (Object)OpenAPITypeUtils.removeArrayBrackets(returnTypeInfo.getSimpleName())).build());
        }
        this.writeWebServiceAnnotations(methodBuilder, pathInfo);
        return methodBuilder;
    }

    private TypeDescription visitMethodParameter(InputParameter parameter, boolean extraMethod) {
        String parameterName;
        TypeInfo paramType = parameter.getType();
        MethodParameterBuilder methodParamBuilder = MethodParameterBuilder.create((String)OpenAPIJavaClassGenerator.resolveType(paramType));
        if (paramType.getType() == TypeInfo.Type.DATATYPE) {
            methodParamBuilder.addAnnotation(AnnotationDescriptionBuilder.create(RulesType.class).withProperty(VALUE, (Object)OpenAPITypeUtils.removeArrayBrackets(paramType.getSimpleName())).build());
        } else if (paramType.getType() == TypeInfo.Type.SPREADSHEET || paramType.getType() == TypeInfo.Type.SPREADSHEET_ARRAY) {
            methodParamBuilder.addAnnotation(AnnotationDescriptionBuilder.create(NoTypeConversion.class).build());
        }
        String originalParameterName = parameter.getOriginalName();
        String formattedParameterName = parameter.getFormattedName();
        String string = parameterName = originalParameterName.equalsIgnoreCase(formattedParameterName) ? formattedParameterName : originalParameterName;
        if (extraMethod) {
            methodParamBuilder.addAnnotation(AnnotationDescriptionBuilder.create(Name.class).withProperty(VALUE, (Object)parameterName).build());
        }
        if (parameter.getIn() != null) {
            methodParamBuilder.addAnnotation(AnnotationDescriptionBuilder.create(this.chooseParamAnnotation(parameter.getIn())).withProperty(VALUE, (Object)parameterName).build());
        }
        return methodParamBuilder.build();
    }

    private void writeWebServiceAnnotations(MethodDescriptionBuilder methodBuilder, PathInfo pathInfo) {
        methodBuilder.addAnnotation(AnnotationDescriptionBuilder.create(this.chooseOperationAnnotation(pathInfo.getOperation())).build());
        methodBuilder.addAnnotation(AnnotationDescriptionBuilder.create(Path.class).withProperty(VALUE, (Object)pathInfo.getOriginalPath()).build());
        if (StringUtils.isNotBlank((CharSequence)pathInfo.getConsumes())) {
            methodBuilder.addAnnotation(AnnotationDescriptionBuilder.create(Consumes.class).withProperty(VALUE, (Object)pathInfo.getConsumes(), true).build());
        }
        if (StringUtils.isNotBlank((CharSequence)pathInfo.getProduces())) {
            methodBuilder.addAnnotation(AnnotationDescriptionBuilder.create(Produces.class).withProperty(VALUE, (Object)pathInfo.getProduces(), true).build());
        }
    }

    static String resolveType(TypeInfo typeInfo) {
        if (typeInfo.getType() == TypeInfo.Type.DATATYPE) {
            Class<?> type = DEFAULT_DATATYPE_CLASS;
            if (typeInfo.getDimension() > 0) {
                int[] dimensions = new int[typeInfo.getDimension()];
                type = Array.newInstance(type, dimensions).getClass();
            }
            return type.getName();
        }
        return typeInfo.getJavaName();
    }

    private Class<? extends Annotation> chooseOperationAnnotation(PathInfo.Operation operation) {
        switch (operation) {
            case GET: {
                return GET.class;
            }
            case POST: {
                return POST.class;
            }
            case PUT: {
                return PUT.class;
            }
            case DELETE: {
                return DELETE.class;
            }
            case PATCH: {
                return PATCH.class;
            }
            case HEAD: {
                return HEAD.class;
            }
            case OPTIONS: {
                return OPTIONS.class;
            }
        }
        throw new IllegalStateException("Unable to find operation annotation.");
    }

    private Class<? extends Annotation> chooseParamAnnotation(InputParameter.In in) {
        switch (in) {
            case PATH: {
                return PathParam.class;
            }
            case QUERY: {
                return QueryParam.class;
            }
            case COOKIE: {
                return CookieParam.class;
            }
            case HEADER: {
                return HeaderParam.class;
            }
        }
        throw new IllegalStateException("Unable to find param annotation.");
    }
}

