/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.openapi.impl;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.model.scaffolding.DatatypeModel;
import org.openl.rules.model.scaffolding.FieldModel;
import org.openl.rules.model.scaffolding.InputParameter;
import org.openl.rules.model.scaffolding.MethodModel;
import org.openl.rules.model.scaffolding.PathInfo;
import org.openl.rules.model.scaffolding.ProjectModel;
import org.openl.rules.model.scaffolding.SpreadsheetModel;
import org.openl.rules.model.scaffolding.StepModel;
import org.openl.rules.model.scaffolding.TypeInfo;
import org.openl.rules.model.scaffolding.data.DataModel;
import org.openl.rules.openapi.OpenAPIModelConverter;
import org.openl.rules.openapi.impl.OpenAPITypeUtils;
import org.openl.rules.openapi.impl.OpenLOpenAPIUtils;
import org.openl.rules.openapi.impl.OperationInfo;
import org.openl.rules.openapi.impl.PathType;
import org.openl.rules.openapi.impl.SpreadsheetParserModel;
import org.openl.rules.project.openapi.OpenAPIRefResolver;
import org.openl.rules.variation.ArgumentReplacementVariation;
import org.openl.rules.variation.ComplexVariation;
import org.openl.rules.variation.DeepCloningVariation;
import org.openl.rules.variation.JXPathVariation;
import org.openl.rules.variation.NoVariation;
import org.openl.rules.variation.Variation;
import org.openl.rules.variation.VariationsPack;
import org.openl.rules.variation.VariationsResult;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;

public class OpenAPIScaffoldingConverter
implements OpenAPIModelConverter {
    public static final String SPREADSHEET_RESULT = "SpreadsheetResult";
    public static final String SPR_RESULT_LINK = "#/components/schemas/SpreadsheetResult";
    public static final String RESULT = "Result";
    public static final Pattern PARAMETERS_BRACKETS_MATCHER = Pattern.compile("\\{.*?}");
    private static final Set<String> IGNORED_FIELDS = Set.copyOf(Collections.singletonList("@class"));
    public static final String SPREADSHEET_RESULT_CLASS_NAME = SpreadsheetResult.class.getName();
    public static final String GET_PREFIX = "get";
    public static final Set<String> VARIATIONS_SCHEMAS_NAME = Set.of(Variation.class.getSimpleName(), NoVariation.class.getSimpleName(), VariationsPack.class.getSimpleName(), ArgumentReplacementVariation.class.getSimpleName(), ComplexVariation.class.getSimpleName(), DeepCloningVariation.class.getSimpleName(), JXPathVariation.class.getSimpleName(), VariationsResult.class.getSimpleName());
    protected final Set<String> ignoredRefs = VARIATIONS_SCHEMAS_NAME.stream().map(s -> "#/components/schemas/" + s).collect(Collectors.toSet());

    @Override
    public ProjectModel extractProjectModel(String pathTo) {
        ParseOptions options = OpenLOpenAPIUtils.getParseOptions();
        OpenAPI openAPI = new OpenAPIV3Parser().read(pathTo, null, options);
        if (openAPI == null) {
            throw new IllegalStateException("Error creating the project, uploaded file has invalid structure.");
        }
        OpenAPIRefResolver openAPIRefResolver = new OpenAPIRefResolver(openAPI);
        String projectName = openAPI.getInfo().getTitle();
        Paths paths = openAPI.getPaths();
        boolean areVariationsProvided = OpenLOpenAPIUtils.checkVariations(openAPI, VARIATIONS_SCHEMAS_NAME);
        Map<String, Integer> allUsedSchemaRefs = OpenLOpenAPIUtils.getAllUsedSchemaRefs(paths, openAPIRefResolver);
        Map<String, Map<String, Integer>> pathsWithRequestsRefs = OpenLOpenAPIUtils.collectPathsWithParams(paths, openAPIRefResolver);
        if (areVariationsProvided) {
            Iterator<Map.Entry<String, Map<String, Integer>>> it = pathsWithRequestsRefs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Map<String, Integer>> pathEntry = it.next();
                Map<String, Integer> usedSchemas = pathEntry.getValue();
                if (!usedSchemas.keySet().stream().anyMatch(this.ignoredRefs::contains)) continue;
                it.remove();
                String refToIgnore = pathEntry.getKey();
                paths.keySet().remove(refToIgnore);
            }
        }
        Map<String, Integer> allUsedSchemaRefsInRequests = pathsWithRequestsRefs.values().stream().flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
        boolean isRuntimeContextProvided = allUsedSchemaRefsInRequests.keySet().stream().anyMatch("#/components/schemas/DefaultRulesRuntimeContext"::equals);
        Set<String> allUnusedRefs = OpenLOpenAPIUtils.getUnusedSchemaRefs(openAPI, allUsedSchemaRefs.keySet());
        Map<String, List<String>> childrenSchemas = OpenAPITypeUtils.getChildrenMap(openAPI);
        Set<String> parents = childrenSchemas.keySet();
        Set<String> childSet = childrenSchemas.values().stream().flatMap(Collection::stream).map(OpenAPITypeUtils::getSimpleName).collect(Collectors.toSet());
        Map<String, Set<String>> refsWithFields = OpenLOpenAPIUtils.getRefsInProperties(openAPI, openAPIRefResolver);
        if (areVariationsProvided) {
            refsWithFields.entrySet().removeIf(entry -> {
                String refKey = (String)entry.getKey();
                if (this.ignoredRefs.contains(refKey)) {
                    return true;
                }
                Set fieldRefs = (Set)entry.getValue();
                if (fieldRefs.stream().anyMatch(this.ignoredRefs::contains)) {
                    this.ignoredRefs.add(refKey);
                    return true;
                }
                return false;
            });
        }
        Set fieldsRefs = refsWithFields.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set<String> refsToExpand = allUsedSchemaRefsInRequests.entrySet().stream().filter(refWithCount -> {
            String ref = (String)refWithCount.getKey();
            Integer numberOfRefUsage = (Integer)refWithCount.getValue();
            boolean refIsParentOrField = !parents.contains(ref) && !fieldsRefs.contains(ref);
            boolean refIsNotChild = !childSet.contains(OpenAPITypeUtils.getSimpleName(ref));
            boolean refIsNotRuntimeContext = !ref.equals("#/components/schemas/DefaultRulesRuntimeContext");
            return refIsNotRuntimeContext && numberOfRefUsage.equals(1) && (!allUsedSchemaRefs.containsKey(ref) || ((Integer)allUsedSchemaRefs.get(ref)).equals(1)) && refIsParentOrField && refIsNotChild;
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
        Map<Pair<String, PathItem.HttpMethod>, Set<String>> refsByPathAndOperation = OpenLOpenAPIUtils.getAllUsedRefResponses(paths, openAPIRefResolver);
        Set<Pair<String, PathItem.HttpMethod>> primitiveReturnPathOperations = refsByPathAndOperation.entrySet().stream().filter(pathWithOperation -> ((Set)pathWithOperation.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
        Map<Pair, Set> operationsPathWithPotentialSpr = refsByPathAndOperation.entrySet().stream().filter(pathOperation -> {
            if (((Set)pathOperation.getValue()).isEmpty()) return false;
            if (!((Set)pathOperation.getValue()).stream().noneMatch(allUsedSchemaRefsInRequests::containsKey)) return false;
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set<Pair<String, PathItem.HttpMethod>> spreadsheetOperations = refsByPathAndOperation.keySet().stream().filter(pathWithOperation -> !operationsPathWithPotentialSpr.containsKey(pathWithOperation) && !primitiveReturnPathOperations.contains(pathWithOperation)).collect(Collectors.toSet());
        Set<String> spreadsheetResultRefs = operationsPathWithPotentialSpr.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        List<SpreadsheetParserModel> spreadsheetParserModels = this.extractSprModels(paths, openAPIRefResolver, operationsPathWithPotentialSpr.keySet(), primitiveReturnPathOperations, spreadsheetOperations, refsToExpand, childSet);
        HashSet<String> dataModelRefs = new HashSet<String>();
        List<DataModel> dataModels = this.extractDataModels(spreadsheetParserModels, openAPIRefResolver, openAPI, spreadsheetResultRefs, dataModelRefs);
        List linkedRefs = spreadsheetParserModels.stream().filter(SpreadsheetParserModel::isRefIsDataType).map(SpreadsheetParserModel::getReturnRef).collect(Collectors.toList());
        Set<String> datatypeRefs = allUsedSchemaRefs.keySet().stream().filter(x -> {
            boolean notSpreadsheetAndExpanded = !spreadsheetResultRefs.contains(x) && !refsToExpand.contains(x);
            boolean isIgnored = this.ignoredRefs.contains(x);
            boolean isNotReserved = !x.equals(SPR_RESULT_LINK);
            boolean notDatatype = linkedRefs.contains(x);
            if (isIgnored) {
                return false;
            }
            return isNotReserved && (notSpreadsheetAndExpanded || notDatatype);
        }).collect(Collectors.toSet());
        Set<String> refSpreadsheets = spreadsheetParserModels.stream().filter(x -> !x.isRefIsDataType() && x.getReturnRef() != null).map(SpreadsheetParserModel::getReturnRef).collect(Collectors.toSet());
        Set<String> allFieldsRefs = this.retrieveAllFieldsRefs(datatypeRefs, refsWithFields);
        Set<String> dtToAdd = allFieldsRefs.stream().filter(x -> {
            boolean isNotSpreadsheetResult = !SPR_RESULT_LINK.equals(x);
            boolean isNotPresentedInDataTypes = !datatypeRefs.contains(x);
            boolean ignoredRef = this.ignoredRefs.contains(x);
            return isNotSpreadsheetResult && isNotPresentedInDataTypes && !ignoredRef;
        }).collect(Collectors.toSet());
        spreadsheetParserModels.stream().filter(x -> dtToAdd.contains(x.getReturnRef())).forEach(x -> {
            SpreadsheetModel model = x.getModel();
            String type = OpenAPITypeUtils.getSimpleName(x.getReturnRef());
            model.setType(type);
            model.getPathInfo().setReturnType(new TypeInfo(type, type, TypeInfo.Type.DATATYPE));
            model.setSteps(this.makeSingleStep(type));
        });
        this.fillCallsInSteps(spreadsheetParserModels, datatypeRefs, dataModelRefs, dtToAdd);
        datatypeRefs.addAll(dtToAdd);
        refSpreadsheets.removeAll(dtToAdd);
        LinkedHashSet<DatatypeModel> dts = new LinkedHashSet<DatatypeModel>(this.extractDataTypeModels(openAPIRefResolver, openAPI, datatypeRefs));
        allUnusedRefs.removeAll(this.ignoredRefs);
        dts.addAll(this.extractDataTypeModels(openAPIRefResolver, openAPI, allUnusedRefs));
        HashSet usedInDataTypes = new HashSet();
        dts.forEach(dt -> {
            Set set = dt.getFields().stream().map(FieldModel::getType).collect(Collectors.toSet());
            if (!set.contains(dt.getName())) {
                dt.getFields().stream().filter(fieldModel -> !OpenAPITypeUtils.isSimpleType(fieldModel.getType())).map(fieldModel -> OpenAPITypeUtils.removeArrayBrackets(fieldModel.getType())).forEach(usedInDataTypes::add);
            }
        });
        List<String> notUsedDataTypeWithRefToSpreadsheet = dts.stream().filter(x -> !usedInDataTypes.contains(x.getName())).map(x -> Pair.of((Object)x.getName(), (Object)x.getFields())).filter(y -> ((List)y.getRight()).stream().anyMatch(field -> refSpreadsheets.contains("#/components/schemas/" + OpenAPITypeUtils.removeArrayBrackets(field.getType())))).map(Pair::getLeft).collect(Collectors.toList());
        dts.removeIf(x -> notUsedDataTypeWithRefToSpreadsheet.contains(x.getName()) || SPREADSHEET_RESULT.equals(x.getName()));
        this.createLostSpreadsheets(openAPIRefResolver, openAPI, spreadsheetParserModels, refSpreadsheets, notUsedDataTypeWithRefToSpreadsheet, pathsWithRequestsRefs, isRuntimeContextProvided);
        this.setCallsAndReturnTypeToLostSpreadsheet(spreadsheetParserModels, notUsedDataTypeWithRefToSpreadsheet);
        Set<String> dtNames = dts.stream().map(DatatypeModel::getName).collect(Collectors.toSet());
        this.checkTypes(spreadsheetParserModels, dtNames);
        Consumer<MethodModel> applyInclude = method -> method.setInclude(paths.get((Object)method.getPathInfo().getOriginalPath()) != null);
        List<MethodModel> spreadsheetModels = spreadsheetParserModels.stream().map(SpreadsheetParserModel::getModel).collect(Collectors.toList());
        spreadsheetModels.forEach(applyInclude);
        dataModels.forEach(applyInclude);
        Map<Boolean, List<SpreadsheetModel>> sprModelsDivided = spreadsheetModels.stream().collect(Collectors.partitioningBy(spreadsheetModel -> this.containsRuntimeContext((Map)pathsWithRequestsRefs.get(spreadsheetModel.getPathInfo().getOriginalPath()))));
        List<SpreadsheetModel> sprModelsWithRC = sprModelsDivided.get(Boolean.TRUE);
        dts.removeIf(dt -> dt.getName().equals("DefaultRulesRuntimeContext"));
        this.removeContextFromParams(sprModelsWithRC);
        return new ProjectModel(projectName, isRuntimeContextProvided, areVariationsProvided, dts, dataModels, isRuntimeContextProvided ? sprModelsWithRC : spreadsheetModels, isRuntimeContextProvided ? sprModelsDivided.get(Boolean.FALSE) : Collections.emptyList());
    }

    private Set<String> retrieveAllFieldsRefs(Set<String> datatypeRefs, Map<String, Set<String>> refsWithFields) {
        HashSet<String> allFieldsRefs = new HashSet<String>();
        LinkedList<String> queue = new LinkedList<String>(datatypeRefs);
        while (!queue.isEmpty()) {
            String dtRef = (String)queue.poll();
            refsWithFields.getOrDefault(dtRef, Collections.emptySet()).stream().filter(x -> !datatypeRefs.contains(x) && !allFieldsRefs.contains(x)).filter(allFieldsRefs::add).forEach(queue::add);
        }
        return allFieldsRefs;
    }

    private void checkTypes(List<SpreadsheetParserModel> parserModels, Set<String> dataTypeNames) {
        for (SpreadsheetParserModel parserModel : parserModels) {
            TypeInfo returnType;
            SpreadsheetModel model = parserModel.getModel();
            PathInfo pathInfo = model.getPathInfo();
            if (pathInfo != null && dataTypeNames.contains(OpenAPITypeUtils.removeArrayBrackets((returnType = pathInfo.getReturnType()).getSimpleName()))) {
                returnType.setType(TypeInfo.Type.DATATYPE);
            }
            List parameters = model.getParameters();
            for (InputParameter parameter : parameters) {
                TypeInfo type = parameter.getType();
                if (!dataTypeNames.contains(OpenAPITypeUtils.removeArrayBrackets(type.getSimpleName()))) continue;
                type.setType(TypeInfo.Type.DATATYPE);
            }
        }
    }

    private void setCallsAndReturnTypeToLostSpreadsheet(List<SpreadsheetParserModel> spreadsheetParserModels, List<String> notUsedDataTypeWithRefToSpreadsheet) {
        if (!notUsedDataTypeWithRefToSpreadsheet.isEmpty()) {
            for (SpreadsheetParserModel spreadsheetParserModel : spreadsheetParserModels) {
                SpreadsheetModel sprModel = spreadsheetParserModel.getModel();
                String returnType = OpenAPITypeUtils.removeArrayBrackets(sprModel.getType());
                if (notUsedDataTypeWithRefToSpreadsheet.contains(returnType)) {
                    PathInfo pathInfo = sprModel.getPathInfo();
                    TypeInfo pathReturnType = pathInfo.getReturnType();
                    int dimension = pathReturnType.getDimension();
                    if (dimension == 0) {
                        sprModel.setType(SPREADSHEET_RESULT);
                        pathInfo.setReturnType(new TypeInfo(SPREADSHEET_RESULT_CLASS_NAME, SPREADSHEET_RESULT, TypeInfo.Type.SPREADSHEET));
                    } else {
                        sprModel.setType(SPREADSHEET_RESULT + returnType + String.join((CharSequence)"", Collections.nCopies(dimension, "[]")));
                        pathReturnType.setJavaName(OpenAPITypeUtils.getSpreadsheetArrayClassName(dimension));
                        pathReturnType.setType(TypeInfo.Type.SPREADSHEET);
                    }
                }
                for (StepModel model : sprModel.getSteps()) {
                    String type = model.getType();
                    String simpleType = OpenAPITypeUtils.removeArrayBrackets(type);
                    if (!notUsedDataTypeWithRefToSpreadsheet.contains(simpleType)) continue;
                    String call = this.makeCall(type, "");
                    model.setValue((String)(type.endsWith("[]") ? this.makeArrayCall(type, simpleType, "") : "= " + call));
                }
            }
        }
    }

    private void createLostSpreadsheets(OpenAPIRefResolver openAPIRefResolver, OpenAPI openAPI, List<SpreadsheetParserModel> spreadsheetParserModels, Set<String> refSpreadsheets, List<String> notUsedDataTypeWithRefToSpreadsheet, Map<String, Map<String, Integer>> pathsWithRequestsRefs, boolean isRuntimeContextProvided) {
        for (String modelName : notUsedDataTypeWithRefToSpreadsheet) {
            Map properties;
            SpreadsheetParserModel lostModel = new SpreadsheetParserModel();
            SpreadsheetModel model = new SpreadsheetModel();
            model.setName(modelName);
            model.setType(SPREADSHEET_RESULT);
            model.setParameters(Collections.emptyList());
            Schema schema = OpenLOpenAPIUtils.getSchemas(openAPI).get(modelName);
            List<Object> steps = new ArrayList();
            if (schema != null && CollectionUtils.isNotEmpty((Map)(properties = schema.getProperties()))) {
                steps = properties.entrySet().stream().filter(propertyEntry -> !IGNORED_FIELDS.contains(propertyEntry.getKey())).map(propertyEntry -> this.createStep(openAPIRefResolver, spreadsheetParserModels, refSpreadsheets, modelName, (Map.Entry<String, Schema>)propertyEntry)).collect(Collectors.toList());
            }
            model.setSteps(steps);
            String originalPath = "/" + modelName;
            model.setPathInfo(new PathInfo(originalPath, modelName, PathInfo.Operation.POST, new TypeInfo(SPREADSHEET_RESULT_CLASS_NAME, SPREADSHEET_RESULT, TypeInfo.Type.SPREADSHEET)));
            lostModel.setModel(model);
            spreadsheetParserModels.add(lostModel);
            if (!isRuntimeContextProvided || pathsWithRequestsRefs.containsKey(originalPath)) continue;
            HashMap<String, Integer> mapWithRC = new HashMap<String, Integer>();
            mapWithRC.put("#/components/schemas/DefaultRulesRuntimeContext", 1);
            pathsWithRequestsRefs.put(originalPath, mapWithRC);
        }
    }

    private StepModel createStep(OpenAPIRefResolver openAPIRefResolver, List<SpreadsheetParserModel> spreadsheetParserModels, Set<String> refSpreadsheets, String modelName, Map.Entry<String, Schema> propertyEntry) {
        StepModel step = this.extractStep(openAPIRefResolver, propertyEntry);
        TypeInfo typeInfo = OpenAPITypeUtils.extractType(openAPIRefResolver, propertyEntry.getValue(), false);
        String stepType = typeInfo.getSimpleName();
        String type = OpenAPITypeUtils.removeArrayBrackets(stepType);
        String modelToCall = "";
        String value = "";
        if (!type.equals(modelName) && !refSpreadsheets.contains("#/components/schemas/" + type)) {
            return step;
        }
        if (type.equals(modelName)) {
            modelToCall = modelName;
        } else {
            Optional<Object> optionalModel = Optional.empty();
            for (SpreadsheetParserModel parserModel : spreadsheetParserModels) {
                int dimension = parserModel.getModel().getPathInfo().getReturnType().getDimension();
                String returnRef = parserModel.getReturnRef();
                if (returnRef == null || !returnRef.equals("#/components/schemas/" + type) || dimension != 0) continue;
                optionalModel = Optional.of(parserModel);
                break;
            }
            if (optionalModel.isPresent()) {
                SpreadsheetParserModel spreadsheetParserModel = (SpreadsheetParserModel)optionalModel.get();
                modelToCall = spreadsheetParserModel.getModel().getName();
                value = spreadsheetParserModel.getModel().getParameters().stream().map(InputParameter::getType).filter(t -> t.getType() != TypeInfo.Type.RUNTIMECONTEXT).map(OpenAPITypeUtils::getJavaDefaultValue).collect(Collectors.joining(", "));
            }
        }
        String call = this.makeCall(modelToCall, value);
        if (stepType.endsWith("[]")) {
            step.setValue(this.makeArrayCall(stepType, modelToCall, call));
        } else {
            step.setValue("= " + call);
        }
        return step;
    }

    private List<DataModel> extractDataModels(List<SpreadsheetParserModel> spreadsheetModels, OpenAPIRefResolver openAPIRefResolver, OpenAPI openAPI, Set<String> sprResultRefs, Set<String> dataModelsRefs) {
        List potentialDataModels = spreadsheetModels.stream().filter(x -> x.getModel().getPathInfo().getFormattedPath().startsWith(GET_PREFIX) && (CollectionUtils.isEmpty((Collection)x.getModel().getParameters()) || this.containsOnlyRuntimeContext(x.getModel().getParameters()))).collect(Collectors.toList());
        ArrayList<DataModel> dataModels = new ArrayList<DataModel>();
        for (SpreadsheetParserModel potentialDataModel : potentialDataModels) {
            boolean postAndRuntimeContext;
            TypeInfo returnType = potentialDataModel.getModel().getPathInfo().getReturnType();
            String type = OpenAPITypeUtils.removeArrayBrackets(returnType.getSimpleName());
            if (returnType.getDimension() == 0 || type.equals(SPREADSHEET_RESULT)) continue;
            PathInfo potentialDataTablePathInfo = potentialDataModel.getModel().getPathInfo();
            String operationMethod = potentialDataTablePathInfo.getOperation().name();
            List parameters = potentialDataModel.getModel().getParameters();
            boolean parametersNotEmpty = CollectionUtils.isNotEmpty((Collection)parameters);
            boolean getAndNoParams = parameters.isEmpty() && operationMethod.equals(PathItem.HttpMethod.GET.name());
            boolean bl = postAndRuntimeContext = parametersNotEmpty && operationMethod.equals(PathItem.HttpMethod.POST.name());
            if (!getAndNoParams && !postAndRuntimeContext) continue;
            String returnRef = potentialDataModel.getReturnRef();
            if (returnRef != null) {
                sprResultRefs.remove(returnRef);
                dataModelsRefs.add(returnRef);
            }
            spreadsheetModels.remove(potentialDataModel);
            String dataTableName = this.formatTableName(potentialDataModel.getModel().getName());
            potentialDataTablePathInfo.setFormattedPath(GET_PREFIX + dataTableName);
            boolean isSimpleType = OpenAPITypeUtils.isSimpleType(type);
            DataModel dataModel = new DataModel(dataTableName, type, potentialDataTablePathInfo, isSimpleType ? this.createSimpleModel(type) : this.createModelForDataTable(openAPIRefResolver, openAPI, type, OpenLOpenAPIUtils.getSchemas(openAPI).get(type)));
            TypeInfo.Type resultType = isSimpleType ? TypeInfo.Type.OBJECT : TypeInfo.Type.DATATYPE;
            dataModel.getPathInfo().getReturnType().setType(resultType);
            if (parametersNotEmpty) {
                dataModel.getPathInfo().setRuntimeContextParameter((InputParameter)parameters.iterator().next());
            }
            dataModels.add(dataModel);
        }
        return dataModels;
    }

    private void removeContextFromParams(List<SpreadsheetModel> sprModelsWithRC) {
        for (SpreadsheetModel spreadsheetModel : sprModelsWithRC) {
            spreadsheetModel.getParameters().stream().filter(p -> p.getType().getType() == TypeInfo.Type.RUNTIMECONTEXT).findFirst().ifPresent(context -> {
                spreadsheetModel.getParameters().remove(context);
                spreadsheetModel.getPathInfo().setRuntimeContextParameter(context);
            });
        }
    }

    private Set<String> fillCallsInSteps(List<SpreadsheetParserModel> models, Set<String> datatypeRefs, Set<String> dataModelRefs, Set<String> lostDt) {
        SpreadsheetModel spreadsheetModel;
        HashSet<String> calledRefs = new HashSet<String>();
        Set fixedDataTypes = Stream.concat(dataModelRefs.stream(), lostDt.stream()).collect(Collectors.toSet());
        HashSet<Pair> sprResultNames = new HashSet<Pair>();
        for (SpreadsheetParserModel model : models) {
            String returnRef = model.getReturnRef();
            if (returnRef == null || !model.isRefIsDataType() || !models.stream().anyMatch(x -> returnRef.equals(x.getReturnRef()) && !x.isRefIsDataType()) || fixedDataTypes.contains(returnRef)) continue;
            datatypeRefs.remove(returnRef);
        }
        Set datatypeNames = Stream.concat(datatypeRefs.stream(), fixedDataTypes.stream()).collect(Collectors.toSet()).stream().map(ref -> OpenAPITypeUtils.getSimpleName(ref).toLowerCase()).collect(Collectors.toSet());
        HashSet<String> reservedWords = new HashSet<String>(datatypeNames);
        HashMap spreadsheetWithParameterNames = new HashMap();
        for (SpreadsheetParserModel model : models) {
            boolean spreadsheetWithSameNameAndParametersExists;
            spreadsheetModel = model.getModel();
            Set parameterNames = spreadsheetModel.getParameters().stream().map(InputParameter::getFormattedName).collect(Collectors.toSet());
            String spreadsheetType = spreadsheetModel.getType();
            String returnRef = model.getReturnRef();
            String spreadsheetName = spreadsheetModel.getName();
            PathInfo pathInfo = spreadsheetModel.getPathInfo();
            String lowerCasedSpreadsheetName = spreadsheetName.toLowerCase();
            boolean bl = spreadsheetWithSameNameAndParametersExists = spreadsheetWithParameterNames.containsKey(lowerCasedSpreadsheetName) && ((Set)spreadsheetWithParameterNames.get(lowerCasedSpreadsheetName)).equals(parameterNames);
            if (spreadsheetWithSameNameAndParametersExists && returnRef == null) {
                String name = this.makeName(spreadsheetModel.getName(), reservedWords);
                spreadsheetModel.setName(name);
                pathInfo.setFormattedPath(name);
            } else if (returnRef != null && (SPREADSHEET_RESULT.equals(spreadsheetType) || !datatypeRefs.contains("#/components/schemas/" + OpenAPITypeUtils.removeArrayBrackets(spreadsheetType)))) {
                TypeInfo returnType = pathInfo.getReturnType();
                if (returnType.getDimension() == 0 && (datatypeNames.contains(lowerCasedSpreadsheetName) || spreadsheetWithSameNameAndParametersExists)) {
                    String modifiedName = this.findSpreadsheetName(returnRef, reservedWords);
                    spreadsheetModel.setName(modifiedName);
                    returnType.setJavaName(OpenAPITypeUtils.getSpreadsheetArrayClassName(returnType.getDimension()));
                    pathInfo.setFormattedPath(modifiedName);
                }
                sprResultNames.add(Pair.of((Object)returnType.getSimpleName(), (Object)spreadsheetModel.getName()));
            }
            spreadsheetWithParameterNames.put(spreadsheetModel.getName().toLowerCase(), parameterNames);
            reservedWords.add(spreadsheetModel.getName().toLowerCase());
        }
        for (SpreadsheetParserModel parserModel : models) {
            int dimension;
            spreadsheetModel = parserModel.getModel();
            String refType = parserModel.getReturnRef() != null ? OpenAPITypeUtils.getSimpleName(parserModel.getReturnRef()) : "";
            Optional<Pair> willBeCalled = sprResultNames.stream().filter(p -> ((String)p.getKey()).equals(refType) && !((String)p.getValue()).equals(spreadsheetModel.getName())).findAny();
            PathInfo existingPathInfo = spreadsheetModel.getPathInfo();
            if (willBeCalled.isPresent() && (dimension = existingPathInfo.getReturnType().getDimension()) > 0) {
                spreadsheetModel.setType(SPREADSHEET_RESULT + (String)willBeCalled.get().getValue() + String.join((CharSequence)"", Collections.nCopies(dimension, "[]")));
                existingPathInfo.getReturnType().setJavaName(OpenAPITypeUtils.getSpreadsheetArrayClassName(dimension));
            }
            for (StepModel step : spreadsheetModel.getSteps()) {
                Pair called;
                String calledType;
                String stepType = step.getType();
                boolean isArray = stepType.endsWith("[]");
                String type = OpenAPITypeUtils.removeArrayBrackets(step.getType());
                if (!sprResultNames.stream().anyMatch(x -> ((String)x.getKey()).equals(type))) continue;
                Optional<Object> foundSpr = Optional.empty();
                if (willBeCalled.isPresent() && type.equals(calledType = (String)(called = willBeCalled.get()).getKey())) {
                    foundSpr = models.stream().filter(x -> x.getModel().getName().equals(called.getRight())).findFirst();
                }
                if (Objects.equals(foundSpr, Optional.empty())) {
                    foundSpr = models.stream().filter(sprModel -> {
                        boolean typesAreTheSame = sprModel.getReturnRef() != null && type.equals(OpenAPITypeUtils.getSimpleName(sprModel.getReturnRef()));
                        boolean notItSelf = !sprModel.getModel().getName().equals(spreadsheetModel.getName());
                        boolean isSpreadsheetResult = sprModel.getModel().getType().equals(SPREADSHEET_RESULT);
                        return typesAreTheSame && notItSelf && isSpreadsheetResult;
                    }).findAny();
                }
                if (!foundSpr.isPresent()) continue;
                SpreadsheetParserModel calledSpr = (SpreadsheetParserModel)foundSpr.get();
                String calledRef = calledSpr.getReturnRef();
                calledRefs.add(calledRef);
                SpreadsheetModel calledModel = calledSpr.getModel();
                List parameters = calledModel.getParameters();
                String value = parameters.stream().map(InputParameter::getType).filter(t -> t.getType() != TypeInfo.Type.RUNTIMECONTEXT).map(OpenAPITypeUtils::getJavaDefaultValue).collect(Collectors.joining(", "));
                String calledName = calledModel.getName();
                String call = this.makeCall(calledName, value);
                step.setValue((String)(isArray ? this.makeArrayCall(stepType, calledName, call) : "= " + call));
            }
        }
        return calledRefs;
    }

    private String findSpreadsheetName(String returnRef, Set<String> reservedNames) {
        String nameCandidate = OpenAPITypeUtils.getSimpleName(returnRef);
        return this.makeName(nameCandidate, reservedNames);
    }

    private String makeName(String candidate, Set<String> reservedWords) {
        if (CollectionUtils.isNotEmpty(reservedWords) && reservedWords.contains(((String)candidate).toLowerCase())) {
            candidate = (String)candidate + "1";
            return this.makeName((String)candidate, reservedWords);
        }
        return candidate;
    }

    private String makeArrayCall(String stepType, String name, String call) {
        int dimension = this.calculateDimension(stepType);
        String openingBrackets = String.join((CharSequence)"", Collections.nCopies(dimension, "{"));
        String closingBrackets = String.join((CharSequence)"", Collections.nCopies(dimension, "}"));
        String arrayBrackets = String.join((CharSequence)"", Collections.nCopies(dimension, "[]"));
        return "= new SpreadsheetResult" + name + arrayBrackets + openingBrackets + call + closingBrackets;
    }

    private int calculateDimension(String stepType) {
        int count = 0;
        boolean brackets = false;
        for (int i = 0; i < stepType.length(); ++i) {
            char c = stepType.charAt(i);
            if (c == '[') {
                if (!brackets) {
                    ++count;
                }
                brackets = true;
                continue;
            }
            if (c != ']') continue;
            brackets = false;
        }
        return count;
    }

    public boolean containsRuntimeContext(Map<String, Integer> inputParametersEntry) {
        return inputParametersEntry != null && inputParametersEntry.containsKey("#/components/schemas/DefaultRulesRuntimeContext");
    }

    public boolean containsOnlyRuntimeContext(Collection<InputParameter> inputParameters) {
        return CollectionUtils.isNotEmpty(inputParameters) && inputParameters.size() == 1 && inputParameters.stream().anyMatch(x -> x.getType().getType() == TypeInfo.Type.RUNTIMECONTEXT);
    }

    private List<SpreadsheetParserModel> extractSprModels(Paths paths, OpenAPIRefResolver openAPIRefResolver, Set<Pair<String, PathItem.HttpMethod>> pathWithPotentialSprResult, Set<Pair<String, PathItem.HttpMethod>> pathsWithPrimitiveReturns, Set<Pair<String, PathItem.HttpMethod>> pathsWithSpreadsheets, Set<String> refsToExpand, Set<String> childSet) {
        ArrayList<SpreadsheetParserModel> spreadSheetModels = new ArrayList<SpreadsheetParserModel>();
        if (paths != null) {
            this.extractSpreadsheets(openAPIRefResolver, pathWithPotentialSprResult, refsToExpand, spreadSheetModels, paths, PathType.SPREADSHEET_RESULT_PATH, childSet);
            this.extractSpreadsheets(openAPIRefResolver, pathsWithPrimitiveReturns, refsToExpand, spreadSheetModels, paths, PathType.SIMPLE_RETURN_PATH, childSet);
            this.extractSpreadsheets(openAPIRefResolver, pathsWithSpreadsheets, refsToExpand, spreadSheetModels, paths, PathType.SPREADSHEET_PATH, childSet);
        }
        return spreadSheetModels;
    }

    private void extractSpreadsheets(OpenAPIRefResolver openAPIRefResolver, Set<Pair<String, PathItem.HttpMethod>> pathWithMethod, Set<String> refsToExpand, List<SpreadsheetParserModel> spreadSheetModels, Paths paths, PathType spreadsheetResultPath, Set<String> childSet) {
        Map pathWithOperationsMap = pathWithMethod.stream().collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
        for (Map.Entry pathWithOperations : pathWithOperationsMap.entrySet()) {
            String pathUrl = pathWithOperations.getKey();
            PathItem pathItem = (PathItem)paths.get((Object)pathUrl);
            if (pathItem == null) continue;
            List<SpreadsheetParserModel> spr = this.extractSpreadsheetModel(openAPIRefResolver, pathWithOperations.getValue(), pathItem, pathUrl, refsToExpand, spreadsheetResultPath, childSet);
            spreadSheetModels.addAll(spr);
        }
    }

    private List<SpreadsheetParserModel> extractSpreadsheetModel(OpenAPIRefResolver openAPIRefResolver, Set<PathItem.HttpMethod> methods, PathItem pathItem, String path, Set<String> refsToExpand, PathType pathType, Set<String> childSet) {
        ArrayList<SpreadsheetParserModel> spreadsheetParserModels = new ArrayList<SpreadsheetParserModel>();
        boolean multipleOperations = methods.size() > 1;
        Map<PathItem.HttpMethod, Operation> filteredMap = pathItem.readOperationsMap().entrySet().stream().filter(m -> methods.contains(m.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<PathItem.HttpMethod, Operation> operationEntry : filteredMap.entrySet()) {
            SpreadsheetParserModel spreadsheetParserModel = new SpreadsheetParserModel();
            SpreadsheetModel spr = new SpreadsheetModel();
            spreadsheetParserModel.setModel(spr);
            PathInfo pathInfo = this.generatePathInfo(path, operationEntry);
            spr.setPathInfo(pathInfo);
            Schema<?> responseSchema = OpenLOpenAPIUtils.getUsedSchemaInResponse(openAPIRefResolver, operationEntry.getValue());
            if (responseSchema == null) continue;
            TypeInfo typeInfo = OpenAPITypeUtils.extractType(openAPIRefResolver, responseSchema, false);
            if (PathType.SPREADSHEET_RESULT_PATH.equals((Object)pathType)) {
                typeInfo = new TypeInfo(SPREADSHEET_RESULT_CLASS_NAME, typeInfo.getSimpleName(), TypeInfo.Type.SPREADSHEET, typeInfo.getDimension(), typeInfo.isReference());
            }
            String usedSchemaInResponse = typeInfo.getSimpleName();
            pathInfo.setReturnType(typeInfo);
            boolean isChild = childSet.contains(usedSchemaInResponse);
            List<InputParameter> parameters = OpenLOpenAPIUtils.extractParameters(openAPIRefResolver, refsToExpand, pathItem, operationEntry);
            String normalizedPath = this.replaceBrackets(path);
            String formattedName = this.generateSpreadsheetName(normalizedPath, multipleOperations, operationEntry.getKey().name());
            spr.setName(formattedName);
            spr.setParameters(parameters);
            pathInfo.setFormattedPath(formattedName);
            List<StepModel> stepModels = this.getStepModels(typeInfo, openAPIRefResolver, pathType, spreadsheetParserModel, spr, responseSchema, isChild);
            spr.setSteps(stepModels);
            spreadsheetParserModels.add(spreadsheetParserModel);
        }
        return spreadsheetParserModels;
    }

    private String generateSpreadsheetName(String normalizedPath, boolean multipleOperations, String operationName) {
        Object potentialName = OpenLOpenAPIUtils.normalizeName(normalizedPath);
        if (multipleOperations) {
            potentialName = (String)potentialName + operationName;
        }
        return potentialName;
    }

    private PathInfo generatePathInfo(String path, Map.Entry<PathItem.HttpMethod, Operation> operationEntry) {
        PathInfo pathInfo = new PathInfo();
        OperationInfo operationInfo = this.getOperationInfo(operationEntry.getValue(), operationEntry.getKey());
        pathInfo.setOriginalPath(path);
        pathInfo.setOperation(Optional.ofNullable(operationInfo.getMethod()).map(String::toUpperCase).map(PathInfo.Operation::valueOf).orElseThrow(() -> new IllegalArgumentException("Invalid method operation")));
        pathInfo.setConsumes(operationInfo.getConsumes());
        pathInfo.setProduces(operationInfo.getProduces());
        return pathInfo;
    }

    private List<StepModel> getStepModels(TypeInfo typeInfo, OpenAPIRefResolver openAPIRefResolver, PathType pathType, SpreadsheetParserModel spreadsheetParserModel, SpreadsheetModel spr, Schema<?> usedSchemaInResponse, boolean isChild) {
        String nameOfSchema;
        List<Object> stepModels = new ArrayList();
        boolean isArray = typeInfo.getDimension() > 0;
        String simpleName = typeInfo.getSimpleName();
        String string = nameOfSchema = isArray ? OpenAPITypeUtils.removeArrayBrackets(simpleName) : simpleName;
        if (PathType.SPREADSHEET_RESULT_PATH == pathType) {
            Schema schema = OpenLOpenAPIUtils.resolve(openAPIRefResolver, usedSchemaInResponse, Schema::get$ref);
            boolean isArrayOrChild = isArray || isChild;
            spr.setType(isArrayOrChild ? simpleName : SPREADSHEET_RESULT);
            if (schema != null) {
                if (isArrayOrChild) {
                    stepModels = this.makeSingleStep(simpleName);
                } else {
                    Map properties = schema.getProperties();
                    if (CollectionUtils.isNotEmpty((Map)properties)) {
                        stepModels = properties.entrySet().stream().filter(x -> !IGNORED_FIELDS.contains(x.getKey())).map(p -> this.extractStep(openAPIRefResolver, (Map.Entry<String, Schema>)p)).collect(Collectors.toList());
                    }
                }
                boolean addToDataTypes = stepModels.stream().anyMatch(x -> OpenAPITypeUtils.removeArrayBrackets(x.getType()).equals(nameOfSchema));
                spreadsheetParserModel.setStoreInModels(addToDataTypes || isArrayOrChild);
            }
            spreadsheetParserModel.setReturnRef("#/components/schemas/" + nameOfSchema);
        } else {
            spr.setType(simpleName);
            stepModels = this.makeSingleStep(simpleName);
        }
        return stepModels;
    }

    private List<StepModel> makeSingleStep(String stepType) {
        return Collections.singletonList(new StepModel(RESULT, stepType, this.makeValue(stepType)));
    }

    private OperationInfo getOperationInfo(Operation operation, PathItem.HttpMethod method) {
        String consumes = null;
        String produces = null;
        if (operation != null) {
            Content content;
            RequestBody requestBody = operation.getRequestBody();
            if (requestBody != null && CollectionUtils.isNotEmpty((Map)(content = requestBody.getContent()))) {
                consumes = content.containsKey((Object)"application/json") ? "application/json" : (content.containsKey((Object)"text/plain") ? "text/plain" : (String)content.keySet().iterator().next());
            }
            ApiResponses responses = operation.getResponses();
            ApiResponse successResponse = (ApiResponse)responses.get((Object)"200");
            ApiResponse defaultResponse = responses.getDefault();
            Content c = null;
            if (successResponse != null) {
                c = successResponse.getContent();
            } else if (defaultResponse != null) {
                c = defaultResponse.getContent();
            } else if (CollectionUtils.isNotEmpty((Map)responses)) {
                ApiResponse firstResponse = (ApiResponse)responses.values().iterator().next();
                c = firstResponse.getContent();
            }
            if (CollectionUtils.isNotEmpty((Map)c)) {
                produces = c.containsKey((Object)"application/json") ? "application/json" : (c.containsKey((Object)"text/plain") ? "text/plain" : (String)c.keySet().iterator().next());
            }
        }
        return new OperationInfo(method.name(), produces, consumes);
    }

    private String replaceBrackets(String path) {
        return PARAMETERS_BRACKETS_MATCHER.matcher(path).replaceAll("");
    }

    private List<DatatypeModel> extractDataTypeModels(OpenAPIRefResolver openAPIRefResolver, OpenAPI openAPI, Set<String> allTheRefsWhichAreDataTypes) {
        ArrayList<DatatypeModel> result = new ArrayList<DatatypeModel>();
        for (String datatypeRef : allTheRefsWhichAreDataTypes) {
            Schema schema = (Schema)OpenLOpenAPIUtils.resolveByRef(openAPIRefResolver, datatypeRef);
            if (schema == null || !OpenAPITypeUtils.isComplexSchema(openAPIRefResolver, schema)) continue;
            DatatypeModel dm = this.createModel(openAPIRefResolver, openAPI, OpenAPITypeUtils.getSimpleName(datatypeRef), schema);
            result.add(dm);
        }
        return result;
    }

    private DatatypeModel createSimpleModel(String type) {
        DatatypeModel dm = new DatatypeModel("");
        dm.setFields(Collections.singletonList(new FieldModel("this", type)));
        return dm;
    }

    private DatatypeModel createModel(OpenAPIRefResolver openAPIRefResolver, OpenAPI openAPI, String schemaName, Schema<?> schema) {
        Map<String, Schema> properties;
        DatatypeModel dm = new DatatypeModel(OpenLOpenAPIUtils.normalizeName(schemaName));
        List<Object> fields = new ArrayList();
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            String parentName = OpenAPITypeUtils.getParentName(composedSchema, openAPI);
            properties = OpenAPITypeUtils.getFieldsOfChild(composedSchema);
            if (composedSchema.getProperties() != null) {
                composedSchema.getProperties().forEach(properties::putIfAbsent);
            }
            dm.setParent(parentName);
        } else {
            properties = schema.getProperties();
        }
        if (properties != null) {
            fields = properties.entrySet().stream().filter(property -> {
                boolean isIgnoredField = IGNORED_FIELDS.contains(property.getKey());
                String ref = ((Schema)property.getValue()).get$ref();
                boolean isRuntimeContext = ref != null && ref.equals("#/components/schemas/DefaultRulesRuntimeContext");
                return !isIgnoredField && !isRuntimeContext;
            }).map(p -> this.extractField(openAPIRefResolver, (Map.Entry<String, Schema>)p)).collect(Collectors.toList());
        }
        dm.setFields(fields);
        return dm;
    }

    private DatatypeModel createModelForDataTable(OpenAPIRefResolver openAPIRefResolver, OpenAPI openAPI, String schemaName, Schema<?> schema) {
        DatatypeModel dm = new DatatypeModel(OpenLOpenAPIUtils.normalizeName(schemaName));
        List<Object> fields = new ArrayList();
        Map<String, Schema> properties = schema instanceof ComposedSchema ? OpenAPITypeUtils.getAllProperties((ComposedSchema)schema, openAPI) : schema.getProperties();
        if (properties != null) {
            fields = properties.entrySet().stream().filter(property -> !IGNORED_FIELDS.contains(property.getKey())).map(p -> this.extractField(openAPIRefResolver, (Map.Entry<String, Schema>)p)).collect(Collectors.toList());
        }
        dm.setFields(fields);
        return dm;
    }

    private FieldModel extractField(OpenAPIRefResolver openAPIRefResolver, Map.Entry<String, Schema> property) {
        String propertyName = property.getKey();
        Schema valueSchema = property.getValue();
        TypeInfo typeInfo = OpenAPITypeUtils.extractType(openAPIRefResolver, valueSchema, false);
        String typeModel = typeInfo.getSimpleName();
        Object defaultValue = valueSchema instanceof IntegerSchema && valueSchema.getFormat() == null ? (valueSchema.getDefault() == null ? Integer.valueOf(0) : valueSchema.getDefault()) : (valueSchema instanceof NumberSchema && valueSchema.getFormat() == null && valueSchema.getDefault() != null ? valueSchema.getDefault().toString() : valueSchema.getDefault());
        return new FieldModel(propertyName, typeModel, defaultValue);
    }

    private StepModel extractStep(OpenAPIRefResolver openAPIRefResolver, Map.Entry<String, Schema> property) {
        String propertyName = property.getKey();
        Schema valueSchema = property.getValue();
        TypeInfo typeInfo = OpenAPITypeUtils.extractType(openAPIRefResolver, valueSchema, false);
        String typeModel = typeInfo.getSimpleName();
        String value = this.makeValue(typeModel);
        return new StepModel(OpenLOpenAPIUtils.normalizeName(propertyName), typeModel, value);
    }

    private String makeValue(String type) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)type)) {
            result = OpenAPITypeUtils.isSimpleType(type) ? OpenAPITypeUtils.getSimpleValue(type) : this.createNewInstance(type);
        }
        return result;
    }

    private String createNewInstance(String type) {
        StringBuilder result = new StringBuilder().append("= ").append("new ").append(type);
        if (type.endsWith("[]")) {
            result.append("{}");
        } else {
            result.append("()");
        }
        return result.toString();
    }

    private String makeCall(String type, String value) {
        return type + "(" + value + ")";
    }

    private String formatTableName(String name) {
        String value = name.replaceFirst("^get", "");
        return name.equals(value) ? value : StringUtils.capitalize((String)value);
    }
}

