/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.openapi.impl;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.model.scaffolding.TypeInfo;
import org.openl.rules.openapi.impl.OpenAPIScaffoldingConverter;
import org.openl.rules.openapi.impl.OpenLOpenAPIUtils;
import org.openl.rules.project.openapi.OpenAPIRefResolver;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPITypeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPITypeUtils.class);
    protected static final Map<String, TypeInfo> PRIMITIVE_CLASSES = OpenAPITypeUtils.initPrimitiveMap();
    protected static final Map<String, TypeInfo> WRAPPER_CLASSES = OpenAPITypeUtils.initWrapperMap();
    public static final String SCHEMAS_LINK = "#/components/schemas/";
    public static final String DEFAULT_RUNTIME_CONTEXT = "DefaultRulesRuntimeContext";
    public static final String LINK_TO_DEFAULT_RUNTIME_CONTEXT = "#/components/schemas/DefaultRulesRuntimeContext";
    public static final TypeInfo RUNTIME_CONTEXT_TYPE = new TypeInfo(IRulesRuntimeContext.class, TypeInfo.Type.RUNTIMECONTEXT);
    public static final TypeInfo SPREADSHEET_RESULT_TYPE = new TypeInfo(SpreadsheetResult.class, TypeInfo.Type.SPREADSHEET);
    public static final String OBJECT = "Object";
    public static final String DATE = "Date";
    public static final String BOOLEAN = "Boolean";
    public static final String STRING = "String";
    public static final String INTEGER = "Integer";
    public static final String LONG = "Long";
    public static final String FLOAT = "Float";
    public static final String DOUBLE = "Double";
    public static final String DOUBLE_PRIMITIVE = "double";
    public static final String FLOAT_PRIMITIVE = "float";
    public static final String BOOLEAN_PRIMITIVE = "boolean";
    public static final String INTEGER_PRIMITIVE = "int";
    public static final String LONG_PRIMITIVE = "long";
    public static final Pattern ARRAY_MATCHER = Pattern.compile("[\\[\\]]");

    private OpenAPITypeUtils() {
    }

    private static Map<String, TypeInfo> initPrimitiveMap() {
        return Map.of(Float.TYPE.getSimpleName(), new TypeInfo(Float.TYPE), Double.TYPE.getSimpleName(), new TypeInfo(Double.TYPE), Long.TYPE.getSimpleName(), new TypeInfo(Long.TYPE), Integer.TYPE.getSimpleName(), new TypeInfo(Integer.TYPE), Boolean.TYPE.getSimpleName(), new TypeInfo(Boolean.TYPE));
    }

    private static Map<String, TypeInfo> initWrapperMap() {
        return Map.of(Date.class.getSimpleName(), new TypeInfo(Date.class), String.class.getSimpleName(), new TypeInfo(String.class), Float.TYPE.getSimpleName(), new TypeInfo(Float.class), Double.TYPE.getSimpleName(), new TypeInfo(Double.class), Long.TYPE.getSimpleName(), new TypeInfo(Long.class), Integer.TYPE.getSimpleName(), new TypeInfo(Integer.class), Boolean.TYPE.getSimpleName(), new TypeInfo(Boolean.class), Object.class.getSimpleName(), new TypeInfo(Object.class), "bigInt", new TypeInfo(BigInteger.class));
    }

    public static TypeInfo extractType(OpenAPIRefResolver openAPIRefResolver, Schema<?> schema, boolean allowPrimitiveTypes) {
        boolean isRefToComplexType = false;
        Schema foundSchema = null;
        if (schema.get$ref() != null) {
            foundSchema = OpenLOpenAPIUtils.resolve(openAPIRefResolver, schema, Schema::get$ref);
            isRefToComplexType = OpenAPITypeUtils.isComplexSchema(openAPIRefResolver, foundSchema);
        }
        if (isRefToComplexType) {
            String simpleName = OpenAPITypeUtils.getSimpleName(schema.get$ref());
            if (DEFAULT_RUNTIME_CONTEXT.equals(simpleName)) {
                return RUNTIME_CONTEXT_TYPE;
            }
            if ("SpreadsheetResult".equals(simpleName)) {
                return SPREADSHEET_RESULT_TYPE;
            }
            return new TypeInfo(simpleName, simpleName, true, 0);
        }
        if (foundSchema != null) {
            schema = foundSchema;
        }
        String schemaType = schema.getType();
        String format = schema.getFormat();
        TypeInfo result = null;
        if ("string".equals(schemaType)) {
            result = "date".equals(format) || "date-time".equals(format) ? WRAPPER_CLASSES.get(DATE) : WRAPPER_CLASSES.get(STRING);
        } else if ("number".equals(schemaType)) {
            result = FLOAT_PRIMITIVE.equals(format) || DOUBLE_PRIMITIVE.equals(format) ? (allowPrimitiveTypes ? PRIMITIVE_CLASSES.get(format) : WRAPPER_CLASSES.get(format)) : WRAPPER_CLASSES.get(DOUBLE_PRIMITIVE);
        } else if ("integer".equals(schemaType)) {
            result = "int64".equals(format) ? (allowPrimitiveTypes ? PRIMITIVE_CLASSES.get(LONG_PRIMITIVE) : WRAPPER_CLASSES.get(LONG_PRIMITIVE)) : ("int32".equals(format) ? (allowPrimitiveTypes ? PRIMITIVE_CLASSES.get(INTEGER_PRIMITIVE) : WRAPPER_CLASSES.get(INTEGER_PRIMITIVE)) : WRAPPER_CLASSES.get(INTEGER_PRIMITIVE));
        } else if (BOOLEAN_PRIMITIVE.equals(schemaType)) {
            result = allowPrimitiveTypes ? PRIMITIVE_CLASSES.get(schemaType) : WRAPPER_CLASSES.get(schemaType);
        } else if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            TypeInfo type = OpenAPITypeUtils.extractType(openAPIRefResolver, arraySchema.getItems(), false);
            String name = type.getSimpleName() + "[]";
            int dim = type.getDimension() + 1;
            if (type.isReference()) {
                result = new TypeInfo(name, name, (TypeInfo.Type)(type.getType() == TypeInfo.Type.SPREADSHEET || type.getType() == TypeInfo.Type.SPREADSHEET_ARRAY ? TypeInfo.Type.SPREADSHEET_ARRAY : null), dim, true);
            } else {
                String className = OpenAPITypeUtils.getArrayClassName(type.getJavaName(), dim);
                result = new TypeInfo(className, name, (TypeInfo.Type)(type.getType() == TypeInfo.Type.SPREADSHEET || type.getType() == TypeInfo.Type.SPREADSHEET_ARRAY ? TypeInfo.Type.SPREADSHEET_ARRAY : null), dim, false);
            }
        }
        if (result == null) {
            result = WRAPPER_CLASSES.get(OBJECT);
        }
        return result;
    }

    public static boolean isComplexSchema(OpenAPIRefResolver openAPIRefResolver, Schema<?> foundSchema) {
        boolean result = false;
        if (foundSchema instanceof ComposedSchema) {
            result = true;
        } else if (foundSchema instanceof ArraySchema) {
            TypeInfo typeInfo = OpenAPITypeUtils.extractType(openAPIRefResolver, foundSchema, false);
            result = typeInfo.isReference();
        } else if (OBJECT.equalsIgnoreCase(foundSchema.getType())) {
            result = true;
        }
        return result;
    }

    public static String getArrayClassName(String javaName, int dim) {
        Object className = dim == 0 ? javaName : (dim == 1 ? "[L" + javaName + ";" : "[" + javaName);
        return className;
    }

    public static String getSpreadsheetArrayClassName(int dim) {
        if (dim == 0) {
            return OpenAPIScaffoldingConverter.SPREADSHEET_RESULT_CLASS_NAME;
        }
        if (dim == 1) {
            return "[L" + OpenAPIScaffoldingConverter.SPREADSHEET_RESULT_CLASS_NAME + ";";
        }
        return "[" + OpenAPITypeUtils.getSpreadsheetArrayClassName(dim - 1);
    }

    public static String getSimpleName(String ref) {
        if (!ref.startsWith("#/components/")) {
            throw new IllegalStateException(String.format("Invalid ref %s", ref));
        }
        ref = ref.substring(ref.lastIndexOf(47) + 1);
        return ref;
    }

    public static boolean isSimpleType(String type) {
        return STRING.equals(type) || FLOAT.equals(type) || DOUBLE.equals(type) || INTEGER.equals(type) || LONG.equals(type) || BOOLEAN.equals(type) || DATE.equals(type) || OBJECT.equals(type) || OpenAPITypeUtils.isPrimitiveType(type);
    }

    public static boolean isPrimitiveType(String type) {
        return FLOAT_PRIMITIVE.equals(type) || BOOLEAN_PRIMITIVE.equals(type) || INTEGER_PRIMITIVE.equals(type) || LONG_PRIMITIVE.equals(type) || DOUBLE_PRIMITIVE.equals(type);
    }

    public static String getSimpleValue(String type) {
        switch (type) {
            case "Integer": 
            case "int": {
                return "= 0";
            }
            case "Long": 
            case "long": {
                return "= 0L";
            }
            case "Double": 
            case "double": {
                return "= 0.0";
            }
            case "Float": 
            case "float": {
                return "= 0.0f";
            }
            case "String": {
                return "= \"\"";
            }
            case "Date": {
                return "= new Date()";
            }
            case "Boolean": 
            case "boolean": {
                return "= false";
            }
        }
        return "= new Object()";
    }

    public static String getJavaDefaultValue(TypeInfo type) {
        switch (type.getJavaName()) {
            case "int": {
                return "0";
            }
            case "long": {
                return "0L";
            }
            case "double": {
                return "0.0";
            }
            case "float": {
                return "0.0f";
            }
            case "boolean": {
                return "false";
            }
        }
        return "null";
    }

    public static String getParentName(ComposedSchema composedSchema, OpenAPI openAPI) {
        Map<String, Schema> allSchemas = OpenLOpenAPIUtils.getSchemas(openAPI);
        List<Schema> interfaces = OpenLOpenAPIUtils.getInterfaces(composedSchema);
        ArrayList<String> refedWithoutDiscriminator = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(interfaces)) {
            for (Schema schema : interfaces) {
                if (!StringUtils.isNotEmpty((CharSequence)schema.get$ref())) continue;
                String parentName = OpenAPITypeUtils.getSimpleName(schema.get$ref());
                Schema s = allSchemas.get(parentName);
                if (s == null) {
                    LOGGER.error("Failed to obtain schema from {}", (Object)parentName);
                    return "UNKNOWN_PARENT_NAME";
                }
                if (OpenAPITypeUtils.hasOrInheritsDiscriminator(s, allSchemas)) {
                    return parentName;
                }
                refedWithoutDiscriminator.add(parentName);
            }
        }
        if (refedWithoutDiscriminator.size() == 1) {
            return (String)refedWithoutDiscriminator.get(0);
        }
        return null;
    }

    private static boolean hasOrInheritsDiscriminator(Schema<?> schema, Map<String, Schema> allSchemas) {
        if (schema.getDiscriminator() != null && StringUtils.isNotEmpty((CharSequence)schema.getDiscriminator().getPropertyName())) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            String parentName = OpenAPITypeUtils.getSimpleName(schema.get$ref());
            Schema s = allSchemas.get(parentName);
            if (s != null) {
                return OpenAPITypeUtils.hasOrInheritsDiscriminator(s, allSchemas);
            }
            LOGGER.error("Failed to obtain schema from {}", (Object)parentName);
        } else if (schema instanceof ComposedSchema) {
            ComposedSchema composed = (ComposedSchema)schema;
            List<Schema> interfaces = OpenLOpenAPIUtils.getInterfaces(composed);
            for (Schema i : interfaces) {
                if (!OpenAPITypeUtils.hasOrInheritsDiscriminator(i, allSchemas)) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public static Map<String, List<String>> getChildrenMap(OpenAPI openAPI) {
        Map<String, Schema> allSchemas = OpenLOpenAPIUtils.getSchemas(openAPI);
        Map<String, List<Map.Entry>> groupedByParent = allSchemas.entrySet().stream().filter(entry -> OpenAPITypeUtils.isComposedSchema((Schema)entry.getValue())).filter(entry -> OpenAPITypeUtils.getParentName((ComposedSchema)entry.getValue(), openAPI) != null).collect(Collectors.groupingBy(entry -> OpenAPITypeUtils.getParentName((ComposedSchema)entry.getValue(), openAPI)));
        return groupedByParent.entrySet().stream().collect(Collectors.toMap(mapEntry -> SCHEMAS_LINK + (String)mapEntry.getKey(), entry -> ((List)entry.getValue()).stream().map(x -> SCHEMAS_LINK + (String)x.getKey()).collect(Collectors.toList())));
    }

    public static Map<String, Schema> getFieldsOfChild(ComposedSchema cs) {
        HashMap<String, Schema> propMap = new HashMap<String, Schema>();
        List<Schema> interfaces = OpenLOpenAPIUtils.getInterfaces(cs);
        if (CollectionUtils.isNotEmpty(interfaces)) {
            for (Schema sc : interfaces) {
                if (!StringUtils.isEmpty((CharSequence)sc.get$ref()) || !CollectionUtils.isNotEmpty((Map)sc.getProperties())) continue;
                sc.getProperties().forEach(propMap::putIfAbsent);
            }
        }
        return propMap;
    }

    public static Map<String, Schema> getAllProperties(ComposedSchema cs, OpenAPI openAPI) {
        Map properties;
        HashMap<String, Schema> allProperties = new HashMap<String, Schema>(OpenAPITypeUtils.getFieldsOfChild(cs));
        String parentName = OpenAPITypeUtils.getParentName(cs, openAPI);
        Schema parentSchema = OpenLOpenAPIUtils.getSchemas(openAPI).get(parentName);
        if (parentSchema != null) {
            properties = parentSchema.getProperties();
            if (CollectionUtils.isNotEmpty((Map)properties)) {
                properties.forEach(allProperties::putIfAbsent);
            }
            if (parentSchema instanceof ComposedSchema) {
                OpenAPITypeUtils.getAllProperties((ComposedSchema)parentSchema, openAPI).forEach(allProperties::putIfAbsent);
            }
        }
        if (cs != null && CollectionUtils.isNotEmpty((Map)(properties = cs.getProperties()))) {
            properties.forEach(allProperties::putIfAbsent);
        }
        return allProperties;
    }

    public static String removeArrayBrackets(String type) {
        return ARRAY_MATCHER.matcher(type).replaceAll("");
    }

    private static boolean isComposedSchema(Schema<?> schema) {
        return schema instanceof ComposedSchema;
    }
}

