/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.openapi.impl;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.rules.model.scaffolding.InputParameter;
import org.openl.rules.model.scaffolding.ParameterModel;
import org.openl.rules.model.scaffolding.TypeInfo;
import org.openl.rules.openapi.impl.MediaTypeInfo;
import org.openl.rules.openapi.impl.OpenAPITypeUtils;
import org.openl.rules.project.openapi.OpenAPIRefResolver;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLOpenAPIUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenLOpenAPIUtils.class);
    public static final String APPLICATION_JSON = "application/json";
    public static final String TEXT_PLAIN = "text/plain";
    public static final int MIN_PARAMETERS_COUNT = 1;

    private OpenLOpenAPIUtils() {
    }

    public static <T> T resolve(OpenAPIRefResolver openAPIRefResolver, T obj, Function<T, String> getRefFuc) {
        if (obj != null && getRefFuc.apply(obj) != null) {
            return (T)OpenLOpenAPIUtils.resolve(openAPIRefResolver, OpenLOpenAPIUtils.resolveByRef(openAPIRefResolver, getRefFuc.apply(obj)), getRefFuc);
        }
        return obj;
    }

    public static Object resolveByRef(OpenAPIRefResolver openAPIRefResolver, String ref) {
        return openAPIRefResolver.resolve(ref);
    }

    public static ParseOptions getParseOptions() {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        options.setFlatten(true);
        return options;
    }

    public static Set<String> getUnusedSchemaRefs(OpenAPI openAPI, Iterable<String> usedRefs) {
        Set<String> schemaNames = OpenLOpenAPIUtils.getSchemas(openAPI).keySet().stream().map(name -> "#/components/schemas/" + name).collect(Collectors.toSet());
        for (String usedRef : usedRefs) {
            schemaNames.remove(usedRef);
        }
        return schemaNames;
    }

    public static Schema<?> getUsedSchemaInResponse(OpenAPIRefResolver openAPIRefResolver, Operation operation) {
        Schema mediaTypeSchema;
        MediaTypeInfo mediaType;
        ApiResponse response;
        ApiResponses responses;
        Schema type = null;
        if (operation != null && (responses = operation.getResponses()) != null && (response = OpenLOpenAPIUtils.getResponse(openAPIRefResolver, responses)) != null && CollectionUtils.isNotEmpty((Map)response.getContent()) && (mediaType = OpenLOpenAPIUtils.getMediaType(response.getContent())) != null && (mediaTypeSchema = mediaType.getContent().getSchema()) != null) {
            type = mediaTypeSchema;
        }
        return type;
    }

    public static ApiResponse getResponse(OpenAPIRefResolver openAPIRefResolver, ApiResponses apiResponses) {
        if (CollectionUtils.isEmpty((Map)apiResponses)) {
            return null;
        }
        ApiResponse successResponse = (ApiResponse)apiResponses.get((Object)"200");
        ApiResponse defaultResponse = apiResponses.getDefault();
        ApiResponse result = successResponse != null ? successResponse : (defaultResponse != null ? defaultResponse : (ApiResponse)apiResponses.values().iterator().next());
        return OpenLOpenAPIUtils.resolve(openAPIRefResolver, result, ApiResponse::get$ref);
    }

    public static MediaTypeInfo getMediaType(Content content) {
        Set mediaTypes = content.keySet();
        if (mediaTypes.contains(APPLICATION_JSON)) {
            return new MediaTypeInfo((MediaType)content.get((Object)APPLICATION_JSON), APPLICATION_JSON);
        }
        if (mediaTypes.contains(TEXT_PLAIN)) {
            return new MediaTypeInfo((MediaType)content.get((Object)TEXT_PLAIN), TEXT_PLAIN);
        }
        Optional mediaType = content.entrySet().stream().findFirst();
        if (mediaType.isPresent()) {
            Map.Entry e = (Map.Entry)mediaType.get();
            return new MediaTypeInfo((MediaType)e.getValue(), (String)e.getKey());
        }
        return null;
    }

    public static Map<String, Integer> getAllUsedSchemaRefs(Paths paths, OpenAPIRefResolver openAPIRefResolver) {
        HashMap<String, Integer> types = new HashMap<String, Integer>();
        OpenLOpenAPIUtils.visitOpenAPI(paths, openAPIRefResolver, s -> {
            String ref = s.get$ref();
            if (ref != null) {
                Schema x = (Schema)OpenLOpenAPIUtils.resolveByRef(openAPIRefResolver, ref);
                if (!OpenAPITypeUtils.isComplexSchema(openAPIRefResolver, x)) {
                    return;
                }
                types.merge(ref, 1, Integer::sum);
            }
        });
        return types;
    }

    public static Map<String, Map<String, Integer>> collectPathsWithParams(Paths paths, OpenAPIRefResolver openAPIRefResolver) {
        HashMap<String, Map<String, Integer>> resultMap = new HashMap<String, Map<String, Integer>>();
        HashSet<String> visitedSchemas = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Map)paths)) {
            for (Map.Entry pathWithItem : paths.entrySet()) {
                OpenLOpenAPIUtils.visitPathItemRequests((PathItem)pathWithItem.getValue(), openAPIRefResolver, s -> {
                    String ref = s.get$ref();
                    if (ref != null) {
                        Schema x = (Schema)OpenLOpenAPIUtils.resolveByRef(openAPIRefResolver, ref);
                        if (!OpenAPITypeUtils.isComplexSchema(openAPIRefResolver, x)) {
                            return;
                        }
                        String path = (String)pathWithItem.getKey();
                        HashMap<String, Integer> requestRefs = (HashMap<String, Integer>)resultMap.get(path);
                        if (requestRefs == null) {
                            requestRefs = new HashMap<String, Integer>();
                            requestRefs.put(ref, 1);
                        } else {
                            requestRefs.merge(ref, 1, Integer::sum);
                        }
                        resultMap.put(path, requestRefs);
                    }
                }, visitedSchemas);
            }
        }
        return resultMap;
    }

    public static Map<Pair<String, PathItem.HttpMethod>, Set<String>> getAllUsedRefResponses(Paths paths, OpenAPIRefResolver openAPIRefResolver) {
        HashMap<Pair<String, PathItem.HttpMethod>, Set<String>> allSchemaRefResponses = new HashMap<Pair<String, PathItem.HttpMethod>, Set<String>>();
        if (paths != null) {
            for (Map.Entry pathEntry : paths.entrySet()) {
                String path = (String)pathEntry.getKey();
                PathItem pathItem = (PathItem)pathEntry.getValue();
                Map operationsMap = pathItem.readOperationsMap();
                if (!CollectionUtils.isNotEmpty((Map)operationsMap)) continue;
                for (Map.Entry methodOperationEntry : operationsMap.entrySet()) {
                    Schema mediaTypeSchema;
                    MediaTypeInfo mediaType;
                    ApiResponse response;
                    ApiResponses responses;
                    Operation operation = (Operation)methodOperationEntry.getValue();
                    PathItem.HttpMethod httpMethod = (PathItem.HttpMethod)methodOperationEntry.getKey();
                    if (operation == null || (responses = operation.getResponses()) == null || (response = OpenLOpenAPIUtils.getResponse(openAPIRefResolver, responses)) == null || !CollectionUtils.isNotEmpty((Map)response.getContent()) || (mediaType = OpenLOpenAPIUtils.getMediaType(response.getContent())) == null || (mediaTypeSchema = mediaType.getContent().getSchema()) == null) continue;
                    Set<String> refs = OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, mediaTypeSchema, false, false);
                    Pair pathWithOperation = Pair.of((Object)path, (Object)httpMethod);
                    if (allSchemaRefResponses.containsKey(pathWithOperation)) {
                        Set existingRefs = (Set)allSchemaRefResponses.get(pathWithOperation);
                        existingRefs.addAll(refs);
                        continue;
                    }
                    allSchemaRefResponses.put((Pair<String, PathItem.HttpMethod>)pathWithOperation, refs);
                }
            }
        }
        return allSchemaRefResponses;
    }

    public static Set<String> visitSchema(OpenAPIRefResolver openAPIRefResolver, Schema<?> schema, boolean visitInterfaces, boolean visitProperties) {
        HashSet<String> result = new HashSet<String>();
        HashSet<String> visitedSchema = new HashSet<String>();
        OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, schema, null, visitedSchema, x -> {
            String ref = x.get$ref();
            if (ref != null) {
                Schema s = (Schema)OpenLOpenAPIUtils.resolveByRef(openAPIRefResolver, ref);
                if (!OpenAPITypeUtils.isComplexSchema(openAPIRefResolver, s)) {
                    return;
                }
                result.add(ref);
            }
        }, visitInterfaces, visitProperties);
        return result;
    }

    private static void visitOpenAPI(Paths paths, OpenAPIRefResolver openAPIRefResolver, Consumer<Schema<?>> visitor) {
        HashSet<String> visitedSchemas = new HashSet<String>();
        if (paths != null) {
            for (PathItem path : paths.values()) {
                OpenLOpenAPIUtils.visitPathItem(path, openAPIRefResolver, visitor, visitedSchemas);
            }
        }
    }

    private static void visitPathItem(PathItem pathItem, OpenAPIRefResolver openAPIRefResolver, Consumer<Schema<?>> visitor, Set<String> visitedSchemas) {
        List allOperations = pathItem.readOperations();
        if (allOperations != null) {
            for (Operation operation : allOperations) {
                OpenLOpenAPIUtils.visitParameters(openAPIRefResolver, operation.getParameters(), visitor, visitedSchemas, true, true);
                RequestBody requestBody = OpenLOpenAPIUtils.resolve(openAPIRefResolver, operation.getRequestBody(), RequestBody::get$ref);
                if (requestBody != null) {
                    OpenLOpenAPIUtils.visitContent(openAPIRefResolver, requestBody.getContent(), visitor, visitedSchemas, true);
                }
                if (operation.getResponses() != null) {
                    for (ApiResponse r : operation.getResponses().values()) {
                        ApiResponse apiResponse = OpenLOpenAPIUtils.resolve(openAPIRefResolver, r, ApiResponse::get$ref);
                        if (apiResponse == null) continue;
                        OpenLOpenAPIUtils.visitContent(openAPIRefResolver, apiResponse.getContent(), visitor, visitedSchemas, true);
                        if (apiResponse.getHeaders() == null) continue;
                        for (Map.Entry entry : apiResponse.getHeaders().entrySet()) {
                            Header header = OpenLOpenAPIUtils.resolve(openAPIRefResolver, (Header)entry.getValue(), Header::get$ref);
                            if (header.getSchema() != null) {
                                OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, header.getSchema(), (String)entry.getKey(), visitedSchemas, visitor, true, true);
                            }
                            OpenLOpenAPIUtils.visitContent(openAPIRefResolver, header.getContent(), visitor, visitedSchemas, true);
                        }
                    }
                }
                if (operation.getCallbacks() == null) continue;
                for (Callback c : operation.getCallbacks().values()) {
                    Callback callback = OpenLOpenAPIUtils.resolve(openAPIRefResolver, c, Callback::get$ref);
                    if (callback == null) continue;
                    for (PathItem pathItem2 : callback.values()) {
                        OpenLOpenAPIUtils.visitPathItem(pathItem2, openAPIRefResolver, visitor, visitedSchemas);
                    }
                }
            }
        }
        OpenLOpenAPIUtils.visitParameters(openAPIRefResolver, pathItem.getParameters(), visitor, visitedSchemas, true, true);
    }

    private static void visitPathItemRequests(PathItem pathItem, OpenAPIRefResolver openAPIRefResolver, Consumer<Schema<?>> visitor, Set<String> visitedSchemas) {
        List allOperations = pathItem.readOperations();
        if (allOperations != null) {
            for (Operation operation : allOperations) {
                OpenLOpenAPIUtils.visitParameters(openAPIRefResolver, operation.getParameters(), visitor, visitedSchemas, false, true);
                RequestBody requestBody = OpenLOpenAPIUtils.resolve(openAPIRefResolver, operation.getRequestBody(), RequestBody::get$ref);
                if (requestBody == null) continue;
                OpenLOpenAPIUtils.visitContent(openAPIRefResolver, requestBody.getContent(), visitor, visitedSchemas, false);
            }
        }
        OpenLOpenAPIUtils.visitParameters(openAPIRefResolver, pathItem.getParameters(), visitor, visitedSchemas, false, true);
    }

    private static void visitParameters(OpenAPIRefResolver openAPIRefResolver, List<Parameter> parameters, Consumer<Schema<?>> visitor, Set<String> visitedSchemas, boolean visitInterfaces, boolean visitProperties) {
        if (parameters != null) {
            for (Parameter p : parameters) {
                Parameter parameter = OpenLOpenAPIUtils.resolve(openAPIRefResolver, p, Parameter::get$ref);
                if (parameter != null) {
                    if (parameter.getSchema() != null) {
                        OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, parameter.getSchema(), null, visitedSchemas, visitor, visitInterfaces, visitProperties);
                    }
                    OpenLOpenAPIUtils.visitContent(openAPIRefResolver, parameter.getContent(), visitor, visitedSchemas, visitInterfaces);
                    continue;
                }
                LOGGER.warn("An unreferenced parameter(s) found.");
            }
        }
    }

    private static void visitContent(OpenAPIRefResolver openAPIRefResolver, Content content, Consumer<Schema<?>> visitor, Set<String> visitedSchemas, boolean visitInterfaces) {
        if (content != null) {
            for (Map.Entry e : content.entrySet()) {
                Schema mediaTypeSchema = ((MediaType)e.getValue()).getSchema();
                if (mediaTypeSchema == null) continue;
                OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, mediaTypeSchema, (String)e.getKey(), visitedSchemas, visitor, visitInterfaces, true);
            }
        }
    }

    private static void visitSchema(OpenAPIRefResolver openAPIRefResolver, Schema<?> schema, String mimeType, Set<String> visitedSchemas, Consumer<Schema<?>> visitor, boolean visitInterfaces, boolean visitProperties) {
        Map properties;
        Object additionalProperties;
        String ref;
        visitor.accept(schema);
        if (schema.get$ref() != null && !visitedSchemas.contains(ref = schema.get$ref())) {
            visitedSchemas.add(ref);
            Schema referencedSchema = OpenLOpenAPIUtils.resolve(openAPIRefResolver, schema, Schema::get$ref);
            if (referencedSchema != null) {
                OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, referencedSchema, mimeType, visitedSchemas, visitor, visitInterfaces, visitProperties);
            }
        }
        if (schema instanceof ComposedSchema && visitInterfaces) {
            List anyOf;
            List allOf;
            List oneOf = ((ComposedSchema)schema).getOneOf();
            if (oneOf != null) {
                for (Schema s : oneOf) {
                    OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, s, mimeType, visitedSchemas, visitor, visitInterfaces, visitProperties);
                }
            }
            if ((allOf = ((ComposedSchema)schema).getAllOf()) != null) {
                for (Schema s : allOf) {
                    OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, s, mimeType, visitedSchemas, visitor, visitInterfaces, visitProperties);
                }
            }
            if ((anyOf = ((ComposedSchema)schema).getAnyOf()) != null) {
                for (Schema s : anyOf) {
                    OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, s, mimeType, visitedSchemas, visitor, visitInterfaces, visitProperties);
                }
            }
        } else if (schema instanceof ArraySchema) {
            Schema itemsSchema = ((ArraySchema)schema).getItems();
            if (itemsSchema != null) {
                OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, itemsSchema, mimeType, visitedSchemas, visitor, visitInterfaces, visitProperties);
            }
        } else if (OpenLOpenAPIUtils.isMapSchema(schema) && (additionalProperties = schema.getAdditionalProperties()) instanceof Schema) {
            OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, (Schema)additionalProperties, mimeType, visitedSchemas, visitor, visitInterfaces, visitProperties);
        }
        if (schema.getNot() != null) {
            OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, schema.getNot(), mimeType, visitedSchemas, visitor, visitInterfaces, visitProperties);
        }
        if (visitProperties && (properties = schema.getProperties()) != null) {
            for (Schema property : properties.values()) {
                OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, property, mimeType, visitedSchemas, visitor, visitInterfaces, visitProperties);
            }
        }
    }

    private static boolean isMapSchema(Schema<?> schema) {
        if (schema instanceof MapSchema) {
            return true;
        }
        if (schema == null) {
            return false;
        }
        if (schema.getAdditionalProperties() instanceof Schema) {
            return true;
        }
        return schema.getAdditionalProperties() instanceof Boolean && (Boolean)schema.getAdditionalProperties() != false;
    }

    public static Map<String, Schema> getSchemas(OpenAPI openAPI) {
        if (openAPI != null && openAPI.getComponents() != null && CollectionUtils.isNotEmpty((Map)openAPI.getComponents().getSchemas())) {
            return openAPI.getComponents().getSchemas();
        }
        return Collections.emptyMap();
    }

    public static Map<String, Schema> getAllFields(OpenAPIRefResolver openAPIRefResolver, ComposedSchema cs) {
        HashMap<String, Schema> propMap = new HashMap<String, Schema>();
        List<Schema> interfaces = OpenLOpenAPIUtils.getInterfaces(cs);
        if (CollectionUtils.isNotEmpty((Map)cs.getProperties())) {
            propMap.putAll(cs.getProperties());
        }
        if (CollectionUtils.isNotEmpty(interfaces)) {
            for (Schema sc : interfaces) {
                Schema s;
                String reference = sc.get$ref();
                if (StringUtils.isEmpty((CharSequence)reference) && CollectionUtils.isNotEmpty((Map)sc.getProperties())) {
                    propMap.putAll(sc.getProperties());
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)reference) || (s = OpenLOpenAPIUtils.resolve(openAPIRefResolver, sc, Schema::get$ref)) == null || !CollectionUtils.isNotEmpty((Map)s.getProperties())) continue;
                propMap.putAll(s.getProperties());
            }
        }
        return propMap;
    }

    public static Map<String, Set<String>> getRefsInProperties(OpenAPI openAPI, OpenAPIRefResolver openAPIRefResolver) {
        HashMap<String, Set<String>> refs = new HashMap<String, Set<String>>();
        Map<String, Schema> schemas = OpenLOpenAPIUtils.getSchemas(openAPI);
        if (CollectionUtils.isNotEmpty(schemas)) {
            for (Map.Entry<String, Schema> schema : schemas.entrySet()) {
                HashSet<String> schemaRefs = new HashSet<String>(OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, schema.getValue(), false, true));
                if (!CollectionUtils.isNotEmpty(schemaRefs)) continue;
                refs.put("#/components/schemas/" + schema.getKey(), schemaRefs);
            }
        }
        return refs;
    }

    public static List<Schema> getInterfaces(ComposedSchema composed) {
        List result = composed.getAllOf() != null && !composed.getAllOf().isEmpty() ? composed.getAllOf() : (composed.getAnyOf() != null && !composed.getAnyOf().isEmpty() ? composed.getAnyOf() : (composed.getOneOf() != null && !composed.getOneOf().isEmpty() ? composed.getOneOf() : Collections.emptyList()));
        return result;
    }

    public static List<InputParameter> extractParameters(OpenAPIRefResolver openAPIRefResolver, Set<String> refsToExpand, PathItem pathItem, Map.Entry<PathItem.HttpMethod, Operation> operationEntry) {
        return OpenLOpenAPIUtils.visitPathItemForParametersOfRequest(openAPIRefResolver, pathItem, refsToExpand, operationEntry);
    }

    private static List<InputParameter> visitPathItemForParametersOfRequest(OpenAPIRefResolver openAPIRefResolver, PathItem pathItem, Set<String> refsToExpand, Map.Entry<PathItem.HttpMethod, Operation> operationEntry) {
        ArrayList<InputParameter> parameterModels = new ArrayList<InputParameter>();
        List pathParameters = pathItem.getParameters();
        boolean pathParametersArePresented = CollectionUtils.isNotEmpty((Collection)pathParameters);
        if (pathParametersArePresented) {
            parameterModels.addAll(OpenLOpenAPIUtils.collectInputParams(openAPIRefResolver, pathParameters, refsToExpand, true));
        }
        if (operationEntry != null) {
            MediaTypeInfo mediaType;
            RequestBody requestBody;
            Operation satisfyingOperation = operationEntry.getValue();
            PathItem.HttpMethod method = operationEntry.getKey();
            List parameters = satisfyingOperation.getParameters();
            boolean allowPrimitiveTypes = method.equals((Object)PathItem.HttpMethod.GET);
            boolean operationsParametersArePresented = CollectionUtils.isNotEmpty((Collection)parameters);
            if (operationsParametersArePresented) {
                parameterModels.addAll(OpenLOpenAPIUtils.collectInputParams(openAPIRefResolver, parameters, refsToExpand, allowPrimitiveTypes));
            }
            if ((requestBody = OpenLOpenAPIUtils.resolve(openAPIRefResolver, satisfyingOperation.getRequestBody(), RequestBody::get$ref)) != null && CollectionUtils.isNotEmpty((Map)requestBody.getContent()) && (mediaType = OpenLOpenAPIUtils.getMediaType(requestBody.getContent())) != null) {
                MediaType content = mediaType.getContent();
                Schema resSchema = OpenLOpenAPIUtils.resolve(openAPIRefResolver, content.getSchema(), Schema::get$ref);
                parameterModels.addAll(OpenLOpenAPIUtils.collectInputParams(openAPIRefResolver, refsToExpand, mediaType, resSchema, pathParametersArePresented || operationsParametersArePresented));
            }
        }
        return parameterModels;
    }

    public static String normalizeName(String originalName) {
        StringBuilder resultName = new StringBuilder();
        for (int i = 0; i < originalName.length(); ++i) {
            char curChar = originalName.charAt(i);
            if (resultName.length() == 0) {
                if (!Character.isJavaIdentifierStart(curChar)) continue;
                resultName.append(curChar);
                continue;
            }
            if (!Character.isJavaIdentifierPart(curChar)) continue;
            resultName.append(curChar);
        }
        return resultName.toString();
    }

    private static List<InputParameter> collectInputParams(OpenAPIRefResolver openAPIRefResolver, Collection<Parameter> params, Set<String> refsToExpand, boolean allowPrimitiveTypes) {
        ArrayList<InputParameter> result = new ArrayList<InputParameter>();
        for (Parameter param : params) {
            Schema paramSchema;
            Parameter p = OpenLOpenAPIUtils.resolve(openAPIRefResolver, param, Parameter::get$ref);
            if (p == null || (paramSchema = p.getSchema()) == null) continue;
            Schema resSchema = OpenLOpenAPIUtils.resolve(openAPIRefResolver, paramSchema, Schema::get$ref);
            String ref = paramSchema.get$ref();
            if (ref != null && refsToExpand.contains(ref)) {
                result.addAll(OpenLOpenAPIUtils.collectParameters(openAPIRefResolver, refsToExpand, resSchema, ref));
                continue;
            }
            if (paramSchema instanceof ArraySchema) {
                refsToExpand.removeIf(x -> x.equals(((ArraySchema)paramSchema).getItems().get$ref()));
            }
            ParameterModel parameterModel = new ParameterModel(OpenAPITypeUtils.extractType(openAPIRefResolver, paramSchema, allowPrimitiveTypes), OpenLOpenAPIUtils.normalizeName(p.getName()), p.getName());
            Optional.ofNullable(p.getIn()).map(String::toUpperCase).map(InputParameter.In::valueOf).ifPresent(arg_0 -> ((ParameterModel)parameterModel).setIn(arg_0));
            result.add((InputParameter)parameterModel);
        }
        return result;
    }

    private static List<InputParameter> collectParameters(OpenAPIRefResolver openAPIRefResolver, Set<String> refsToExpand, Schema<?> paramSchema, String ref) {
        Map<String, Schema> properties;
        List<Object> result = new ArrayList<InputParameter>();
        if (paramSchema instanceof ComposedSchema) {
            ComposedSchema cs = (ComposedSchema)paramSchema;
            properties = OpenLOpenAPIUtils.getAllFields(openAPIRefResolver, cs);
        } else {
            properties = paramSchema.getProperties();
        }
        if (CollectionUtils.isNotEmpty((Map)properties)) {
            int propertiesCount = properties.size();
            if (propertiesCount == 1) {
                refsToExpand.remove(ref);
                String name = OpenAPITypeUtils.getSimpleName(ref);
                TypeInfo typeInfo = "DefaultRulesRuntimeContext".equals(name) ? OpenAPITypeUtils.RUNTIME_CONTEXT_TYPE : new TypeInfo(name, name, TypeInfo.Type.DATATYPE);
                ParameterModel parameterModel = new ParameterModel(typeInfo, StringUtils.uncapitalize((String)OpenLOpenAPIUtils.normalizeName(name)), name);
                result = Collections.singletonList(parameterModel);
            } else {
                result = properties.entrySet().stream().map(p -> OpenLOpenAPIUtils.extractParameter(p, openAPIRefResolver)).collect(Collectors.toList());
            }
        }
        return result;
    }

    private static List<InputParameter> collectInputParams(OpenAPIRefResolver openAPIRefResolver, Set<String> refsToExpand, MediaTypeInfo mediaType, Schema<?> resSchema, boolean parametersArePresented) {
        List<Object> result = new ArrayList<InputParameter>();
        if (resSchema != null) {
            String ref;
            boolean refIsPresented;
            Set<String> allSchemasUsedInRequest = OpenLOpenAPIUtils.visitSchema(openAPIRefResolver, resSchema, false, true);
            boolean requestBodyHasExpandableParam = allSchemasUsedInRequest.stream().anyMatch(refsToExpand::contains);
            if (requestBodyHasExpandableParam) {
                for (String internalModel : allSchemasUsedInRequest) {
                    refsToExpand.remove(internalModel);
                }
            }
            boolean bl = refIsPresented = (ref = mediaType.getContent().getSchema().get$ref()) != null;
            if (parametersArePresented && refIsPresented) {
                refsToExpand.remove(ref);
            }
            if (refIsPresented && refsToExpand.contains(ref)) {
                result = OpenLOpenAPIUtils.collectParameters(openAPIRefResolver, refsToExpand, resSchema, ref);
            } else {
                TypeInfo typeInfo = OpenAPITypeUtils.extractType(openAPIRefResolver, mediaType.getContent().getSchema(), false);
                String type = typeInfo.getSimpleName();
                if (StringUtils.isBlank((CharSequence)type)) {
                    result = Collections.emptyList();
                } else {
                    Object parameter = type;
                    if (typeInfo.getDimension() > 0) {
                        parameter = OpenAPITypeUtils.removeArrayBrackets(type);
                    }
                    if (OpenAPITypeUtils.isPrimitiveType(type)) {
                        parameter = (String)parameter + "Param";
                    }
                    result = new ArrayList<ParameterModel>(Collections.singletonList(new ParameterModel(typeInfo, StringUtils.uncapitalize((String)parameter), (String)parameter)));
                }
            }
        }
        return result;
    }

    public static ParameterModel extractParameter(Map.Entry<String, Schema> property, OpenAPIRefResolver openAPIRefResolver) {
        String propertyName = property.getKey();
        Schema valueSchema = property.getValue();
        TypeInfo typeModel = OpenAPITypeUtils.extractType(openAPIRefResolver, valueSchema, false);
        return new ParameterModel(typeModel, OpenLOpenAPIUtils.normalizeName(propertyName), propertyName);
    }

    public static boolean checkVariations(OpenAPI openAPI, Set<String> variationsSchemasName) {
        return OpenLOpenAPIUtils.getSchemas(openAPI).keySet().containsAll(variationsSchemasName);
    }
}

