/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatExpLog
extends FloatExpImpl {
    private static final int[] event_map = new int[]{6, 2, 6, 4, 1, 1, 8, 8};
    private FloatExp _exp;
    private ExpressionObserver _observer;

    public FloatExpLog(FloatExp exp) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._observer = new FloatExpLogObserver();
        this._exp.attachObserver(this._observer);
    }

    @Override
    public double max() {
        return Math.log(this._exp.max());
    }

    @Override
    public double min() {
        return Math.log(this._exp.min());
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void setMax(double max) throws Failure {
        this._exp.setMax(Math.exp(max));
    }

    @Override
    public void setMin(double min) throws Failure {
        this._exp.setMin(Math.exp(min));
    }

    @Override
    public void setValue(double value) throws Failure {
        this._exp.setValue(Math.exp(value));
    }

    @Override
    public String toString() {
        return "log(" + this._exp + ")" + this.domainToString();
    }

    class FloatExpLogObserver
    extends ExpressionObserver {
        FloatExpLogObserver() {
            super(event_map);
        }

        @Override
        public Object master() {
            return FloatExpLog.this;
        }

        @Override
        public String toString() {
            return "FloatExpLogObserver: " + FloatExpLog.this._exp;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatEvent e = (FloatEvent)event;
            FloatEventLog ev = FloatEventLog.getEvent(e, FloatExpLog.this);
            FloatExpLog.this.notifyObservers(ev);
        }
    }

    static final class FloatEventLog
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new FloatEventLog();
            }
        };
        FloatEvent _event;
        int _type = 0;

        FloatEventLog() {
        }

        static FloatEventLog getEvent(FloatEvent event, FloatExp exp) {
            FloatEventLog ev = (FloatEventLog)_factory.getElement();
            ev.init(event, exp);
            return ev;
        }

        void init(FloatEvent event, FloatExp exp_) {
            this.exp(exp_);
            this._event = event;
            this._type = 0;
            if (this.max() < this.oldmax()) {
                this._type |= 4;
            }
            if (this.min() > this.oldmin()) {
                this._type |= 2;
            }
            if (this.min() == this.max()) {
                this._type |= 1;
            }
        }

        @Override
        public double max() {
            return Math.log(this._event.max());
        }

        @Override
        public double min() {
            return Math.log(this._event.min());
        }

        @Override
        public String name() {
            return "FloatEventLog";
        }

        @Override
        public double oldmax() {
            return Math.log(this._event.oldmax());
        }

        @Override
        public double oldmin() {
            return Math.log(this._event.oldmin());
        }

        @Override
        public int type() {
            return this._type;
        }
    }
}

