/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatCalc;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatExpSqr
extends FloatExpImpl {
    private static final int[] event_map = new int[]{6, 2, 6, 4, 1, 1, 8, 8};
    private FloatExp _exp;
    private ExpressionObserver _observer;

    public FloatExpSqr(FloatExp exp) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._observer = new FloatExpSqrObserver();
        this._exp.attachObserver(this._observer);
    }

    @Override
    public double max() {
        return FloatCalc.sqrMax(this._exp.min(), this._exp.max());
    }

    @Override
    public double min() {
        return FloatCalc.sqrMin(this._exp.min(), this._exp.max());
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void setMax(double max) throws Failure {
        if (max < 0.0) {
            this.constrainer().fail("max < 0");
        }
        double expMax = Math.sqrt(max);
        this._exp.setMax(expMax);
        this._exp.setMin(-expMax);
    }

    @Override
    public void setMin(double min) throws Failure {
        if (min <= 0.0) {
            return;
        }
    }

    @Override
    public void setValue(double value) throws Failure {
        if (value < 0.0) {
            this.constrainer().fail("value < 0");
        }
        this._exp.setValue(Math.sqrt(value));
    }

    @Override
    public String toString() {
        return "sqr(" + this._exp + ")" + this.domainToString();
    }

    class FloatExpSqrObserver
    extends ExpressionObserver {
        FloatExpSqrObserver() {
            super(event_map);
        }

        @Override
        public Object master() {
            return FloatExpSqr.this;
        }

        @Override
        public String toString() {
            return "FloatExpSqrObserver: " + FloatExpSqr.this._exp;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatEvent e = (FloatEvent)event;
            FloatEventSqr ev = FloatEventSqr.getEvent(e, FloatExpSqr.this);
            FloatExpSqr.this.notifyObservers(ev);
        }
    }

    static final class FloatEventSqr
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new FloatEventSqr();
            }
        };
        FloatEvent _event;
        int _type = 0;

        FloatEventSqr() {
        }

        static FloatEventSqr getEvent(FloatEvent event, FloatExp exp) {
            FloatEventSqr ev = (FloatEventSqr)_factory.getElement();
            ev.init(event, exp);
            return ev;
        }

        void init(FloatEvent event, FloatExp exp_) {
            this.exp(exp_);
            this._event = event;
            this._type = 0;
            if (this.max() < this.oldmax()) {
                this._type |= 4;
            }
            if (this.min() > this.oldmin()) {
                this._type |= 2;
            }
            if (this.min() == this.max()) {
                this._type |= 1;
            }
        }

        @Override
        public double max() {
            return FloatCalc.sqrMax(this._event.min(), this._event.max());
        }

        @Override
        public double min() {
            return FloatCalc.sqrMin(this._event.min(), this._event.max());
        }

        @Override
        public String name() {
            return "FloatEventSqr";
        }

        @Override
        public double oldmax() {
            return FloatCalc.sqrMax(this._event.oldmin(), this._event.oldmax());
        }

        @Override
        public double oldmin() {
            return FloatCalc.sqrMin(this._event.oldmin(), this._event.oldmax());
        }

        @Override
        public int type() {
            return this._type;
        }
    }
}

