/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntBoolExpForSubject;

public final class IntBoolExpEqValue
extends IntBoolExpForSubject {
    private IntExp _exp;
    private int _value;

    public IntBoolExpEqValue(IntExp exp, int value) {
        super(exp.constrainer());
        this._exp = exp;
        this._value = value;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "==" + value + ")";
        }
        this.setDomainMinMaxSafe();
        this._exp.attachObserver(new ObserverMinMax());
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp.neg().add(this._value).calcCoeffs(map, factor);
    }

    @Override
    public boolean isLinear() {
        return this._exp.isLinear();
    }

    @Override
    protected boolean isSubjectFalse() {
        return !this._exp.contains(this._value);
    }

    @Override
    protected boolean isSubjectTrue() {
        return this._exp.min() == this._value && this._exp.max() == this._value;
    }

    @Override
    protected void setSubjectFalse() throws Failure {
        this._exp.removeValue(this._value);
    }

    @Override
    protected void setSubjectTrue() throws Failure {
        this._exp.setValue(this._value);
    }

    final class ObserverMinMax
    extends Observer {
        ObserverMinMax() {
        }

        @Override
        public Object master() {
            return IntBoolExpEqValue.this;
        }

        @Override
        public int subscriberMask() {
            return 15;
        }

        @Override
        public void update(Subject exp, EventOfInterest interest) throws Failure {
            IntBoolExpEqValue.this.setDomainMinMax();
        }
    }
}

